/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.metadata.i18n.Errors;
import org.geotools.parameter.AbstractParameter;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterValueList;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.util.Utilities;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterCardinalityException;
import org.opengis.parameter.InvalidParameterTypeException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;

public class ParameterGroup
extends AbstractParameter
implements ParameterValueGroup {
    private static final long serialVersionUID = -1985309386356545126L;
    public static ParameterValueGroup EMPTY = new ParameterGroup(Collections.singletonMap("name", "Void"), (GeneralParameterValue[])new ParameterValue[0]);
    private ArrayList<GeneralParameterValue> values;
    private transient List<GeneralParameterValue> asList;

    public ParameterGroup(ParameterDescriptorGroup descriptor) {
        super((GeneralParameterDescriptor)descriptor);
        List parameters = descriptor.descriptors();
        this.values = new ArrayList(parameters.size());
        for (GeneralParameterDescriptor element : parameters) {
            int count = element.getMinimumOccurs();
            while (--count >= 0) {
                GeneralParameterValue value = element.createValue();
                ParameterGroup.ensureNonNull("createValue", value);
                this.values.add(value);
            }
        }
    }

    public ParameterGroup(ParameterDescriptorGroup descriptor, GeneralParameterValue ... values) {
        super((GeneralParameterDescriptor)descriptor);
        ParameterGroup.ensureNonNull("values", values);
        this.values = new ArrayList(values.length);
        this.values.addAll(Arrays.asList(values));
        List parameters = descriptor.descriptors();
        LinkedHashMap<GeneralParameterDescriptor, int[]> occurences = new LinkedHashMap<GeneralParameterDescriptor, int[]>(Math.round((float)parameters.size() / 0.75f) + 1, 0.75f);
        for (GeneralParameterDescriptor param : parameters) {
            ParameterGroup.ensureNonNull("parameters", param);
            occurences.put(param, new int[1]);
        }
        ParameterGroup.ensureValidOccurs(values, occurences);
    }

    public ParameterGroup(Map<String, ?> properties, GeneralParameterValue ... values) {
        super((GeneralParameterDescriptor)ParameterGroup.createDescriptor(properties, values));
        this.values = new ArrayList(values.length);
        this.values.addAll(Arrays.asList(values));
    }

    private static ParameterDescriptorGroup createDescriptor(Map<String, ?> properties, GeneralParameterValue ... values) {
        ParameterGroup.ensureNonNull("values", values);
        LinkedHashMap<GeneralParameterDescriptor, int[]> occurences = new LinkedHashMap<GeneralParameterDescriptor, int[]>(Math.round((float)values.length / 0.75f) + 1, 0.75f);
        for (int i = 0; i < values.length; ++i) {
            ParameterGroup.ensureNonNull("values", values, i);
            occurences.put(values[i].getDescriptor(), new int[1]);
        }
        ParameterGroup.ensureValidOccurs(values, occurences);
        Set descriptors = occurences.keySet();
        return new DefaultParameterDescriptorGroup(properties, descriptors.toArray(new GeneralParameterDescriptor[descriptors.size()]));
    }

    private static void ensureValidOccurs(GeneralParameterValue[] values, Map<GeneralParameterDescriptor, int[]> occurences) {
        for (int i = 0; i < values.length; ++i) {
            ParameterGroup.ensureNonNull("values", values, i);
            GeneralParameterDescriptor descriptor = values[i].getDescriptor();
            int[] count = occurences.get(descriptor);
            if (count == null) {
                String name = ParameterGroup.getName(descriptor);
                throw new InvalidParameterTypeException(Errors.format((int)65, (Object)name), name);
            }
            count[0] = count[0] + 1;
        }
        for (Map.Entry<GeneralParameterDescriptor, int[]> entry : occurences.entrySet()) {
            GeneralParameterDescriptor descriptor = entry.getKey();
            int count = entry.getValue()[0];
            int min = descriptor.getMinimumOccurs();
            int max = descriptor.getMaximumOccurs();
            if (count >= min && count <= max) continue;
            String name = ParameterGroup.getName(descriptor);
            throw new InvalidParameterCardinalityException(Errors.format((int)71, (Object)name, (Object)count, (Object)min, (Object)max), name);
        }
    }

    public ParameterDescriptorGroup getDescriptor() {
        return (ParameterDescriptorGroup)super.getDescriptor();
    }

    public List<GeneralParameterValue> values() {
        if (this.asList == null) {
            this.asList = new ParameterValueList((ParameterDescriptorGroup)this.descriptor, this.values);
        }
        return this.asList;
    }

    final GeneralParameterValue parameter(int index) throws IndexOutOfBoundsException {
        return this.values.get(index);
    }

    public ParameterValue parameter(String name) throws ParameterNotFoundException {
        ParameterGroup.ensureNonNull("name", name);
        name = name.trim();
        for (GeneralParameterValue value : this.values) {
            if (!(value instanceof ParameterValue) || !AbstractIdentifiedObject.nameMatches((IdentifiedObject)value.getDescriptor(), name)) continue;
            return (ParameterValue)value;
        }
        for (GeneralParameterDescriptor descriptor : this.getDescriptor().descriptors()) {
            if (!(descriptor instanceof ParameterDescriptor) || !AbstractIdentifiedObject.nameMatches((IdentifiedObject)descriptor, name)) continue;
            ParameterValue value = ((ParameterDescriptor)descriptor).createValue();
            this.values.add((GeneralParameterValue)value);
            return value;
        }
        throw new ParameterNotFoundException(Errors.format((int)99, (Object)name), name);
    }

    public List<ParameterValueGroup> groups(String name) throws ParameterNotFoundException {
        GeneralParameterDescriptor check;
        ParameterGroup.ensureNonNull("name", name);
        name = name.trim();
        ArrayList<ParameterValueGroup> groups = new ArrayList<ParameterValueGroup>(Math.min(this.values.size(), 10));
        for (GeneralParameterValue value : this.values) {
            if (!(value instanceof ParameterValueGroup) || !AbstractIdentifiedObject.nameMatches((IdentifiedObject)value.getDescriptor(), name)) continue;
            groups.add((ParameterValueGroup)value);
        }
        if (groups.isEmpty() && !((check = ((ParameterDescriptorGroup)this.descriptor).descriptor(name)) instanceof ParameterDescriptorGroup)) {
            throw new ParameterNotFoundException(Errors.format((int)99, (Object)name), name);
        }
        return groups;
    }

    public ParameterValueGroup addGroup(String name) throws ParameterNotFoundException, InvalidParameterCardinalityException {
        GeneralParameterDescriptor check = ((ParameterDescriptorGroup)this.descriptor).descriptor(name);
        if (!(check instanceof ParameterDescriptorGroup)) {
            throw new ParameterNotFoundException(Errors.format((int)99, (Object)name), name);
        }
        int count = 0;
        for (GeneralParameterValue value : this.values) {
            if (!AbstractIdentifiedObject.nameMatches((IdentifiedObject)value.getDescriptor(), name)) continue;
            ++count;
        }
        if (count >= check.getMaximumOccurs()) {
            throw new InvalidParameterCardinalityException(Errors.format((int)169, (Object)name, (Object)count), name);
        }
        ParameterValueGroup value = ((ParameterDescriptorGroup)check).createValue();
        this.values.add((GeneralParameterValue)value);
        return value;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            ParameterGroup that = (ParameterGroup)object;
            return Utilities.equals(this.values, that.values);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.values.hashCode();
    }

    @Override
    public ParameterGroup clone() {
        ParameterGroup copy = (ParameterGroup)super.clone();
        copy.values = (ArrayList)copy.values.clone();
        int i = copy.values.size();
        while (--i >= 0) {
            copy.values.set(i, copy.values.get(i).clone());
        }
        copy.asList = null;
        return copy;
    }
}

