/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.config;

import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.filter.SaServletFilter;
import cn.dev33.satoken.router.SaHttpMethod;
import cn.dev33.satoken.router.SaRouter;
import cn.dev33.satoken.stp.StpUtil;
import cn.hutool.core.util.StrUtil;
import com.geoway.config.AtlasSsoClientConfig;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class SaTokenConfigure
implements WebMvcConfigurer {
    @Resource
    private AtlasSsoClientConfig atlasSsoClientConfig;
    @Value(value="${server.servlet.context-path:}")
    private String contextPath;
    @Resource
    private Environment environment;

    @Bean
    public SaServletFilter getSaServletFilter() {
        if ("/".equals(this.contextPath)) {
            this.contextPath = "";
        }
        return new SaServletFilter().addInclude(new String[]{"/**"}).addExclude(new String[]{"/sso/*", "/favicon.ico"}).addExclude(StrUtil.split((CharSequence)this.atlasSsoClientConfig.getIgnorePaths(), (CharSequence)",", (boolean)true, (boolean)true).toArray(new String[0])).setAuth(obj -> {
            SaRouter.match((SaHttpMethod[])new SaHttpMethod[]{SaHttpMethod.OPTIONS}).free(r -> this.addCors()).back();
            if (!StpUtil.isLogin()) {
                this.addCors();
                SaHolder.getResponse().setStatus(HttpStatus.UNAUTHORIZED.value());
                SaRouter.back();
            }
        });
    }

    private void addCors() {
        SaHolder.getResponse().setHeader("Access-Control-Allow-Origin", this.environment.getProperty("geoway.cors.allowed-patterns", "*")).setHeader("Access-Control-Allow-Methods", this.environment.getProperty("geoway.cors.allowed-methods", "GET,POST,PUT,DELETE,OPTIONS")).setHeader("Access-Control-Max-Age", "3600").setHeader("Access-Control-Allow-Headers", this.environment.getProperty("geoway.cors.allowed-headers", "*"));
    }
}

