/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.ssoserver.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.db.Db;
import cn.hutool.db.Entity;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.stereotype.Component;

@Component
public class DbHelper {
    @Resource
    DataSource dataSource;
    private Db db;

    @PostConstruct
    private void init() {
        this.db = Db.use((DataSource)this.dataSource);
    }

    public Entity find(String table, Map<String, Object> map) {
        Entity where = Entity.create((String)table);
        map.forEach((arg_0, arg_1) -> ((Entity)where).set(arg_0, arg_1));
        try {
            return this.db.get(where);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T find(String table, Map<String, Object> map, Class<T> clazz) {
        return this.find(table, map, clazz, null);
    }

    public <T> T find(String table, Map<String, Object> map, Class<T> clazz, Map<String, String> fieldsMapping) {
        Entity where = Entity.create((String)table);
        map.forEach((arg_0, arg_1) -> ((Entity)where).set(arg_0, arg_1));
        try {
            Entity entity = this.db.get(where);
            if (entity == null) {
                return null;
            }
            CopyOptions copyOptions = null;
            if (fieldsMapping != null) {
                copyOptions = CopyOptions.create().setFieldMapping(fieldsMapping);
            }
            return (T)BeanUtil.toBean((Object)entity, clazz, (CopyOptions)copyOptions);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> List<T> list(String table, Map<String, Object> map, Class<T> clazz) {
        return this.list(table, map, clazz, null);
    }

    public <T> List<T> list(String table, Map<String, Object> map, Class<T> clazz, Map<String, String> fieldsMapping) {
        Entity where = Entity.create((String)table);
        map.forEach((arg_0, arg_1) -> ((Entity)where).set(arg_0, arg_1));
        try {
            CopyOptions copyOptions = null;
            if (fieldsMapping != null) {
                copyOptions = CopyOptions.create().setFieldMapping(fieldsMapping);
            }
            List entities = this.db.find(where);
            return BeanUtil.copyToList((Collection)entities, clazz, (CopyOptions)copyOptions);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public long count(String table, Map<String, Object> map) {
        Entity where = Entity.create((String)table);
        map.forEach((arg_0, arg_1) -> ((Entity)where).set(arg_0, arg_1));
        try {
            return this.db.count(where);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> List<T> query(String sql, Class<T> clazz, Object ... params) {
        try {
            return this.db.query(sql, clazz, params);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public int insert(Entity entity) {
        try {
            return this.db.insert(entity);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public long insertForGeneratedKey(Entity entity) {
        try {
            return this.db.insertForGeneratedKey(entity);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

