/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.ssoserver.controller;

import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.sso.processor.SaSsoServerProcessor;
import cn.dev33.satoken.sso.template.SaSsoServerTemplate;
import cn.dev33.satoken.stp.StpUtil;
import cn.dev33.satoken.util.SaResult;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import cn.hutool.log.StaticLog;
import com.geoway.atlas.ssoserver.config.AtlasConfig;
import com.geoway.atlas.ssoserver.dao.UisTenantMapper;
import com.geoway.atlas.ssoserver.dao.UisTenantTargetMapper;
import com.geoway.atlas.ssoserver.dao.UisUserMapper;
import com.geoway.atlas.ssoserver.po.UisTenant;
import com.geoway.atlas.ssoserver.po.UisTenantTarget;
import com.geoway.atlas.ssoserver.po.UisUser;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
public class SsoServerController {
    private static final List<String> themes = ListUtil.of((Object[])new String[]{"flighthub", "onemap", "sa-res", "webstore"});
    @Resource
    private AtlasConfig atlasConfig;
    @Resource
    UisUserMapper userDao;
    @Resource
    UisTenantMapper uisTenantDao;
    @Resource
    UisTenantTargetMapper uisTenantTargetDao;

    @RequestMapping(value={"/sso/*"})
    public Object ssoRequest() {
        return SaSsoServerProcessor.instance.dister();
    }

    @RequestMapping(value={"/sso/test"})
    public Object test(@RequestParam String name) {
        UisUser user = this.userDao.findByUsername(name);
        return SaResult.data((Object)user);
    }

    @Autowired
    private void configSso(SaSsoServerTemplate ssoServerTemplate) {
        ssoServerTemplate.strategy.notLoginView = () -> {
            String client = SaHolder.getRequest().getParam("client");
            String theme = themes.contains(client) ? client : this.atlasConfig.getDefaultTheme();
            HashMap model = new HashMap();
            return new ModelAndView(theme + "/login.html", model);
        };
        ssoServerTemplate.strategy.doLoginHandle = (name, pwd) -> {
            UisUser user = this.userDao.findByUsername((String)name);
            if (user == null) {
                return SaResult.error((String)"\u7528\u6237\u4e0d\u5b58\u5728\uff01");
            }
            if (!pwd.equals(user.getPassword())) {
                return SaResult.error((String)"\u5bc6\u7801\u9519\u8bef\uff01");
            }
            StpUtil.login((Object)user.getId());
            return SaResult.ok((String)"\u767b\u5f55\u6210\u529f\uff01").setData((Object)StpUtil.getTokenValue());
        };
        ssoServerTemplate.messageHolder.addHandle("userinfo", (ssoTemplate, message) -> {
            UisUser user = this.getSsoUser(message.get("loginId"));
            return SaResult.data((Object)user);
        }).addHandle("tenantInfo", (ssoTemplate, message) -> SaResult.data(this.getTenants(message.get("loginId")))).addHandle("saveUser", (ssoTemplate, message) -> SaResult.data((Object)this.saveUser(message.get("uisUser"))));
    }

    private Object saveUser(Object uisUser) {
        UisUser user = (UisUser)JSONUtil.toBean((JSONObject)JSONUtil.parseObj((Object)uisUser), UisUser.class);
        UisUser userById = this.userDao.findById(user.getId());
        if (userById != null) {
            StaticLog.warn((String)("\u7528\u6237\u5df2\u5b58\u5728, \u8df3\u8fc7\u540c\u6b65 : " + userById.getUsername()), (Object[])new Object[0]);
            return SaResult.ok((String)"\u7528\u6237\u5df2\u5b58\u5728");
        }
        int i = this.userDao.insertSelective(user);
        if (i > 0) {
            return SaResult.ok((String)"\u4fdd\u5b58\u7528\u6237\u6210\u529f");
        }
        return SaResult.error((String)("\u4fdd\u5b58\u7528\u6237\u5931\u8d25 : " + user.getId()));
    }

    @NotNull
    private UisUser getSsoUser(Object loginId) {
        UisUser user = this.userDao.findById(String.valueOf(loginId));
        user.setPassword(null);
        return user;
    }

    @NotNull
    private List<UisTenant> getTenants(Object loginId) {
        String client = SaHolder.getRequest().getParam("client");
        Assert.notEmpty((CharSequence)client, (String)"client\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
        List<UisTenant> uisTenants = this.uisTenantDao.listByAppCode(client);
        if (uisTenants.isEmpty()) {
            return Collections.emptyList();
        }
        if (ObjectUtil.isEmpty((Object)loginId)) {
            return uisTenants;
        }
        List<UisTenantTarget> uisTenantTargets = this.uisTenantTargetDao.selectByUserId(String.valueOf(loginId));
        if (uisTenantTargets.isEmpty()) {
            return Collections.emptyList();
        }
        Set tenantIds = uisTenantTargets.stream().map(UisTenantTarget::getTenantId).collect(Collectors.toSet());
        return uisTenants.stream().filter(ut -> tenantIds.contains(ut.getId())).collect(Collectors.toList());
    }
}

