/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.ssoserver.controller;

import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.sso.message.SaSsoMessage;
import cn.dev33.satoken.sso.processor.SaSsoServerProcessor;
import cn.dev33.satoken.sso.template.SaSsoServerTemplate;
import cn.dev33.satoken.stp.StpUtil;
import cn.dev33.satoken.util.SaResult;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import cn.hutool.log.StaticLog;
import com.geoway.atlas.ssoserver.config.AtlasConfig;
import com.geoway.atlas.ssoserver.constant.DataMode;
import com.geoway.atlas.ssoserver.po.Tenant;
import com.geoway.atlas.ssoserver.po.User;
import com.geoway.atlas.ssoserver.po.UserTenant;
import com.geoway.atlas.ssoserver.service.BusinessFactory;
import com.geoway.atlas.ssoserver.service.UisService;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
public class SsoServerController {
    private static final List<String> themes = ListUtil.of((Object[])new String[]{"flighthub", "onemap", "sa-res", "webstore"});
    @Resource
    private AtlasConfig atlasConfig;
    @Resource
    private BusinessFactory businessFactory;
    @Resource
    private UisService uisService;
    private List<String> deptIds;
    private List<String> orgIds;
    private List<String> tenantIds;

    @PostConstruct
    private void checkUisConfig() {
        String defaultTenants;
        String defaultDepts;
        if (this.businessFactory.dataMode() != DataMode.uis) {
            return;
        }
        String defaultOrgs = this.atlasConfig.getDefaultOrgs();
        if (StrUtil.isAllNotBlank((CharSequence[])new CharSequence[]{defaultOrgs, defaultDepts = this.atlasConfig.getDefaultDepts(), defaultTenants = this.atlasConfig.getDefaultTenants()})) {
            this.orgIds = StrUtil.split((CharSequence)defaultOrgs, (CharSequence)",", (boolean)true, (boolean)true);
            this.deptIds = StrUtil.split((CharSequence)defaultDepts, (CharSequence)",", (boolean)true, (boolean)true);
            this.tenantIds = StrUtil.split((CharSequence)defaultTenants, (CharSequence)",", (boolean)true, (boolean)true);
            Assert.state((this.deptIds.size() == this.tenantIds.size() && this.orgIds.size() == this.deptIds.size() ? 1 : 0) != 0, (String)"\u9ed8\u8ba4\u79df\u6237\u914d\u7f6e\u6709\u8bef", (Object[])new Object[0]);
        } else {
            StaticLog.warn((String)"\u65e0\u9ed8\u8ba4\u79df\u6237\u76f8\u5173\u914d\u7f6e", (Object[])new Object[0]);
        }
    }

    @RequestMapping(value={"/sso/*"})
    public Object ssoRequest() {
        return SaSsoServerProcessor.instance.dister();
    }

    @RequestMapping(value={"/sso/test"})
    public Object test(@RequestParam String name) {
        User user = this.businessFactory.findUserByName(name);
        return SaResult.data((Object)user);
    }

    @Autowired
    private void configSso(SaSsoServerTemplate ssoServerTemplate) {
        ssoServerTemplate.strategy.notLoginView = () -> {
            String client = SaHolder.getRequest().getParam("client");
            String theme = themes.contains(client) ? client : this.atlasConfig.getDefaultTheme();
            HashMap model = new HashMap();
            return new ModelAndView(theme + "/login.html", model);
        };
        ssoServerTemplate.strategy.doLoginHandle = (name, pwd) -> {
            User user = this.businessFactory.findUserByName((String)name);
            if (user == null) {
                return SaResult.error((String)"\u7528\u6237\u4e0d\u5b58\u5728\uff01");
            }
            if (!pwd.equals(user.getPassword())) {
                return SaResult.error((String)"\u5bc6\u7801\u9519\u8bef\uff01");
            }
            StpUtil.login((Object)user.getId());
            return SaResult.data((Object)StpUtil.getTokenInfo());
        };
        ssoServerTemplate.messageHolder.addHandle("userinfo", (ssoTemplate, message) -> {
            User user = this.getSsoUser(message.get("loginId"));
            return SaResult.data((Object)user);
        }).addHandle("tenantInfo", (ssoTemplate, message) -> SaResult.data(this.getTenants(message.get("loginId")))).addHandle("saveUser", (ssoTemplate, message) -> this.saveUser(message.get("User"))).addHandle("restLogin", (ssoTemplate, message) -> this.restLogin(message));
    }

    private SaResult restLogin(SaSsoMessage message) {
        String username = message.getString("username");
        String password = message.getString("password");
        return (SaResult)SaSsoServerProcessor.instance.ssoServerTemplate.strategy.doLoginHandle.apply((Object)username, (Object)password);
    }

    private SaResult saveUser(Object User2) {
        User user = (User)JSONUtil.toBean((JSONObject)JSONUtil.parseObj((Object)User2), User.class);
        User userById = this.businessFactory.findUserById(user.getId());
        if (userById != null) {
            StaticLog.warn((String)("\u7528\u6237\u5df2\u5b58\u5728, \u8df3\u8fc7\u540c\u6b65 : " + userById.getUsername()), (Object[])new Object[0]);
        } else {
            int count = this.businessFactory.insertUser(user);
            if (count <= 0) {
                return SaResult.error((String)("\u4fdd\u5b58\u7528\u6237\u5931\u8d25 : " + user.getId()));
            }
        }
        if (CollectionUtil.isNotEmpty(this.tenantIds) && this.businessFactory.dataMode() == DataMode.uis) {
            for (int i = 0; i < this.tenantIds.size(); ++i) {
                long result1;
                long result;
                String tenantId = this.tenantIds.get(i);
                long count = this.uisService.countUserTenant(user.getId(), tenantId);
                if (count == 0L && (result = this.uisService.insertUserTenant(user.getId(), tenantId)) <= 0L) {
                    return SaResult.error((String)("\u7528\u6237\u5173\u8054\u79df\u6237\u5931\u8d25 : " + user.getId()));
                }
                String orgId = this.orgIds.get(i);
                String deptId = this.deptIds.get(i);
                long count1 = this.uisService.countUserOrgDept(user.getId(), orgId, deptId);
                if (count1 != 0L || (result1 = this.uisService.insertUserOrgDept(user.getId(), orgId, deptId)) > 0L) continue;
                return SaResult.error((String)("\u7528\u6237\u5173\u8054\u5355\u4f4d\u5931\u8d25 : " + user.getId()));
            }
        }
        return SaResult.ok((String)"\u4fdd\u5b58\u7528\u6237\u6210\u529f");
    }

    @NotNull
    private User getSsoUser(Object loginId) {
        User user = this.businessFactory.findUserById(String.valueOf(loginId));
        user.setPassword(null);
        return user;
    }

    @NotNull
    private List<Tenant> getTenants(Object loginId) {
        String client = SaHolder.getRequest().getParam("client");
        Assert.notEmpty((CharSequence)client, (String)"client\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
        List<Tenant> Tenants = this.businessFactory.findTenantByClient(client);
        if (Tenants.isEmpty()) {
            return Collections.emptyList();
        }
        if (ObjectUtil.isEmpty((Object)loginId)) {
            return Tenants;
        }
        List<UserTenant> userTenants = this.businessFactory.findUserTenantByUserId(String.valueOf(loginId));
        if (userTenants.isEmpty()) {
            return Collections.emptyList();
        }
        Set tenantIds = userTenants.stream().map(UserTenant::getTenantId).collect(Collectors.toSet());
        return Tenants.stream().filter(ut -> tenantIds.contains(ut.getId())).collect(Collectors.toList());
    }
}

