/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.ssoserver.service;

import cn.hutool.db.Db;
import cn.hutool.db.Entity;
import cn.hutool.log.StaticLog;
import com.geoway.atlas.ssoserver.constant.DataMode;
import com.geoway.atlas.ssoserver.po.Tenant;
import com.geoway.atlas.ssoserver.po.User;
import com.geoway.atlas.ssoserver.po.UserTenant;
import com.geoway.atlas.ssoserver.service.BusinessService;
import com.geoway.atlas.ssoserver.service.JckjService;
import com.geoway.atlas.ssoserver.service.UisService;
import java.sql.SQLException;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.stereotype.Component;

@Component
public class BusinessFactory {
    @Resource
    private DataSource dataSource;
    @Resource
    UisService uisService;
    @Resource
    JckjService jckjService;
    private BusinessService service;
    private DataMode dataMode = DataMode.uis;

    public DataMode dataMode() {
        return this.dataMode;
    }

    @PostConstruct
    private void setService() {
        if (this.isTableExists("uis_user")) {
            this.dataMode = DataMode.uis;
            this.service = this.uisService;
        } else {
            this.dataMode = DataMode.jckj;
            this.service = this.jckjService;
        }
        StaticLog.info((String)("\u5f53\u524d\u6570\u636e\u6a21\u5f0f : " + (Object)((Object)this.dataMode)), (Object[])new Object[0]);
    }

    public boolean isTableExists(String tableName) {
        String sql = "select count(*) from information_schema.tables where table_name = ?";
        try {
            Entity entity = Db.use((DataSource)this.dataSource).queryOne(sql, new Object[]{tableName});
            return entity.getLong("count") > 0L;
        }
        catch (SQLException e) {
            StaticLog.error((String)("\u6821\u9a8c\u8868\u5931\u8d25 : " + e.getMessage()), (Object[])new Object[0]);
            return false;
        }
    }

    public User findUserByName(String name) {
        return this.service.findByUsername(name);
    }

    public User findUserById(String id) {
        return this.service.findUserById(id);
    }

    public int insertUser(User user) {
        return this.service.insertUser(user);
    }

    public List<Tenant> findTenantByClient(String client) {
        return this.service.findTenantByClient(client);
    }

    public List<UserTenant> findUserTenantByUserId(String userId) {
        return this.service.findUserTenantByUserId(userId);
    }
}

