/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.ssoserver.service;

import cn.hutool.core.util.StrUtil;
import cn.hutool.db.Entity;
import com.geoway.atlas.ssoserver.po.App;
import com.geoway.atlas.ssoserver.po.Menu;
import com.geoway.atlas.ssoserver.po.Tenant;
import com.geoway.atlas.ssoserver.po.User;
import com.geoway.atlas.ssoserver.po.UserTenant;
import com.geoway.atlas.ssoserver.service.BusinessService;
import com.geoway.atlas.ssoserver.service.DbHelper;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class JckjService
implements BusinessService {
    @Resource
    private DbHelper dbHelper;
    public static final String userTable = "sys_user";
    public static final String userSecurityTable = "sys_user_security";
    public static final String tenantTable = "sys_tenant";
    public static final String userTenantTable = "sys_tenant_user";
    public static final String appTable = "sys_system";
    public static final String menuTable = "sys_menu";
    private static final Map<String, String> userFieldsMapping = new HashMap<String, String>(){
        {
            this.put("f_id", "id");
            this.put("f_name", "username");
            this.put("f_aname", "alias");
            this.put("f_tel", "phone");
        }
    };
    private static final Map<String, String> tenantFieldsMapping = new HashMap<String, String>(){
        {
            this.put("f_id", "id");
            this.put("f_name", "name");
        }
    };
    private static final Map<String, String> userTenantFieldsMapping = new HashMap<String, String>(){
        {
            this.put("f_userid", "userId");
            this.put("f_tenantid", "tenantId");
        }
    };
    private static final Map<String, String> appFieldsMapping = new HashMap<String, String>(){
        {
            this.put("f_id", "appId");
            this.put("f_key", "appSecret");
        }
    };

    @Override
    public List<App> listApp() {
        return this.dbHelper.list(appTable, Collections.emptyMap(), App.class, appFieldsMapping);
    }

    @Override
    public List<Menu> listMenus(String client, String loginId) {
        String sql = "select distinct sm.f_id   as id,\n                        sm.f_name as name,\n                        sm.f_key  as \"key\"\n        from sys_role_menu srm\n                 left join sys_menu sm on\n            srm.f_menuid = sm.f_id\n                 left join sys_user_role sur on\n            srm.f_roleid = sur.f_roleid\n        where sur.f_userid = ?          and sm.f_systemid = ?";
        return this.dbHelper.query(sql, Menu.class, loginId, client);
    }

    @Override
    public User findByUsername(String username) {
        return this.dbHelper.find(userTable, Collections.singletonMap("f_name", username), User.class, userFieldsMapping);
    }

    @Override
    public User findUserById(String id) {
        return this.dbHelper.find(userTable, Collections.singletonMap("f_id", id), User.class, userFieldsMapping);
    }

    @Override
    public int insertUser(User user) {
        Entity entity = Entity.create((String)userTable);
        entity.set("f_id", (Object)user.getId());
        entity.set("f_name", (Object)user.getUsername());
        entity.set("f_aname", (Object)user.getAlias());
        String phone = user.getPhone();
        entity.set("f_tel", (Object)phone);
        int insert = this.dbHelper.insert(entity);
        Entity entity1 = Entity.create((String)userSecurityTable);
        entity1.set("f_id", (Object)user.getId());
        entity1.set("f_password", (Object)user.getPassword());
        entity1.set("f_createtime", (Object)new Date());
        entity1.set("f_resetpassword", (Object)"123456");
        this.dbHelper.insert(entity1);
        return insert;
    }

    @Override
    public List<Tenant> findTenantByClient(String client) {
        String sql = "select st.f_id as id, st.f_name as name from sys_tenant st , sys_tenant_system sts where st.f_id = sts.f_tenantid and sts.f_systemid = ?";
        return this.dbHelper.query(sql, Tenant.class, client);
    }

    @Override
    public List<UserTenant> findUserTenantByUserId(String userId) {
        return this.dbHelper.list(userTenantTable, Collections.singletonMap("f_userid", userId), UserTenant.class, userTenantFieldsMapping);
    }

    @Override
    public boolean isPwdValid(User user, String pwd) {
        Entity entity = this.dbHelper.find(userSecurityTable, Collections.singletonMap("f_id", user.getId()));
        if (entity == null) {
            return false;
        }
        return StrUtil.equals((CharSequence)entity.getStr("f_password"), (CharSequence)pwd);
    }
}

