/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.api.action;

import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.common.web.ResponsePage;
import com.geoway.adf.gis.basic.PageList;
import com.geoway.dgt.frame.dto.FlowTaskCreateDTO;
import com.geoway.dgt.frame.dto.TaskCreateDTO;
import com.geoway.dgt.frame.dto.TaskDTO;
import com.geoway.dgt.frame.dto.TaskLogDTO;
import com.geoway.dgt.frame.service.ToolTaskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dgt/task"})
@Api(tags={"02-\u4efb\u52a1\u7ba1\u7406"})
public class ToolTaskController {
    @Resource
    private ToolTaskService toolTaskService;

    @ApiOperation(value="\u4efb\u52a1\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageIndex", value="\u5206\u9875\u7d22\u5f15", paramType="query", defaultValue="0"), @ApiImplicitParam(name="rows", value="\u6bcf\u9875\u6570\u91cf", paramType="query", defaultValue="10"), @ApiImplicitParam(name="status", value="\u72b6\u6001", paramType="query", allowableValues="com.geoway.dgt.frame.constants.TaskStatusEnum"), @ApiImplicitParam(name="type", value="\u4efb\u52a1\u7c7b\u578b", paramType="query", allowableValues="com.geoway.dgt.frame.constants.TaskTypeEnum"), @ApiImplicitParam(name="keyword", value="\u540d\u79f0\u8fc7\u6ee4", paramType="query")})
    @GetMapping(value={"/list"})
    public ResponsePage<TaskDTO> listTask(@RequestParam(required=false) String toolId, @RequestParam(required=false, defaultValue="0") Integer pageIndex, @RequestParam(required=false, defaultValue="10") Integer rows, @RequestParam(required=false) String status, @RequestParam(required=false) Integer type, @RequestParam(required=false) String keyword, @RequestParam(required=false) String category) {
        PageList list = this.toolTaskService.listTask(toolId, pageIndex.intValue(), rows.intValue(), status, type, keyword, category);
        return ResponsePage.ok((PageList)list);
    }

    @ApiOperation(value="\u4efb\u52a1\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", required=true, value="\u4efb\u52a1id", paramType="query"), @ApiImplicitParam(name="pageIndex", value="\u5206\u9875\u7d22\u5f15", paramType="query", defaultValue="0"), @ApiImplicitParam(name="rows", value="\u6bcf\u9875\u6570\u91cf", paramType="query", defaultValue="10"), @ApiImplicitParam(name="status", value="\u72b6\u6001", paramType="query", allowableValues="com.geoway.dgt.frame.constants.TaskStatusEnum"), @ApiImplicitParam(name="keyword", value="\u540d\u79f0\u8fc7\u6ee4", paramType="query")})
    @GetMapping(value={"/detail"})
    public Response<TaskDTO> getTaskDetail(@RequestParam String taskId, @RequestParam(required=false, defaultValue="0") Integer pageIndex, @RequestParam(required=false, defaultValue="10") Integer rows, @RequestParam(required=false) String status, @RequestParam(required=false) String keyword) {
        return Response.ok((Object)this.toolTaskService.getTaskDetail(taskId, pageIndex.intValue(), rows.intValue(), status, keyword));
    }

    @ApiOperation(value="\u521b\u5efa\u4efb\u52a1")
    @PostMapping(value={"/create"})
    public Response<String> createTask(@RequestBody TaskCreateDTO taskCreateDTO) {
        return Response.ok((Object)this.toolTaskService.createTask(taskCreateDTO));
    }

    @ApiOperation(value="\u521b\u5efa\u6d41\u7a0b\u4efb\u52a1")
    @PostMapping(value={"/createflow"})
    public Response<String> createTaskFlow(@RequestBody FlowTaskCreateDTO taskCreateDTO) {
        return Response.ok((Object)this.toolTaskService.createTaskFlow(taskCreateDTO));
    }

    @ApiOperation(value="\u5f00\u59cb\u6267\u884c\u4efb\u52a1")
    @PostMapping(value={"/start"})
    public Response startTask(String taskId) {
        this.toolTaskService.startTask(taskId);
        return Response.ok();
    }

    @ApiOperation(value="\u505c\u6b62\u4efb\u52a1")
    @PostMapping(value={"/stop"})
    public Response stopTask(String taskId) {
        this.toolTaskService.stopTask(taskId);
        return Response.ok();
    }

    @ApiOperation(value="\u5220\u9664\u4efb\u52a1")
    @PostMapping(value={"/del"})
    public Response deleteTask(String taskId) {
        this.toolTaskService.deleteTask(taskId);
        return Response.ok();
    }

    @ApiOperation(value="\u4efb\u52a1\u65e5\u5fd7")
    @GetMapping(value={"/log"})
    public Response<List<TaskLogDTO>> listLog(String itemId, @RequestParam(required=false) String toolId) {
        return Response.ok((Object)this.toolTaskService.getTasklogs(itemId, toolId));
    }
}

