/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.frame.service;

import com.alibaba.fastjson.JSONArray;
import com.geoway.adf.dms.common.dto.FieldDTO;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.FeatureClassDTO;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.dgt.frame.dao.DgtExtractSchemeDao;
import com.geoway.dgt.frame.dto.extract.ExtractSchemeDTO;
import com.geoway.dgt.frame.dto.extract.ExtractSchemeFieldDTO;
import com.geoway.dgt.frame.dto.extract.ExtractSchemeLayerDTO;
import com.geoway.dgt.frame.dto.extract.ExtractSchemeSimpleDTO;
import com.geoway.dgt.frame.entity.DgtExtractScheme;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ExtractSchemeService {
    private static final Logger log = LoggerFactory.getLogger(ExtractSchemeService.class);
    @Resource
    private DgtExtractSchemeDao extractSchemeDao;
    @Resource
    private DataSourceService dataSourceService;

    public List<ExtractSchemeSimpleDTO> list(String keyword) {
        List schemes = this.extractSchemeDao.selectAll();
        if (schemes.size() == 0) {
            return new ArrayList<ExtractSchemeSimpleDTO>();
        }
        if (StringUtil.isNotEmpty((String)keyword)) {
            schemes = ListUtil.findAll(schemes, f -> f.getName() != null && f.getName().contains(keyword));
        }
        ArrayList<ExtractSchemeSimpleDTO> dtoList = new ArrayList<ExtractSchemeSimpleDTO>();
        schemes.forEach(item -> {
            ExtractSchemeSimpleDTO dto = new ExtractSchemeSimpleDTO();
            dto.setId(item.getId());
            dto.setName(item.getName());
            dto.setDesc(item.getDesc());
            dtoList.add(dto);
        });
        return dtoList;
    }

    public String add(ExtractSchemeSimpleDTO createDTO) {
        Assert.notNull((Object)createDTO.getName(), (String)"\u8bf7\u8bbe\u7f6e\u540d\u79f0");
        if (this.exitSameName(createDTO.getName())) {
            throw new RuntimeException("\u540d\u79f0\uff1a" + createDTO.getName() + "\u91cd\u590d");
        }
        DgtExtractScheme scheme = new DgtExtractScheme();
        scheme.setId(UUID.randomUUID().toString());
        scheme.setName(createDTO.getName());
        scheme.setDesc(createDTO.getDesc());
        this.extractSchemeDao.insert(scheme);
        return scheme.getId();
    }

    public void update(ExtractSchemeSimpleDTO editDTO) {
        DgtExtractScheme scheme = this.extractSchemeDao.selectByPrimaryKey(editDTO.getId());
        Assert.notNull((Object)scheme, (String)("\u672a\u67e5\u8be2\u5230\u6807\u8bc6\u4e3a" + editDTO.getId() + "\u7684\u6a21\u677f"));
        Assert.notNull((Object)editDTO.getName(), (String)"\u8bf7\u8bbe\u7f6e\u540d\u79f0");
        if (!editDTO.getName().equals(scheme.getName()) && this.exitSameName(editDTO.getName())) {
            throw new RuntimeException("\u540d\u79f0\uff1a" + editDTO.getName() + "\u91cd\u590d");
        }
        scheme.setName(editDTO.getName());
        scheme.setDesc(editDTO.getDesc());
        this.extractSchemeDao.updateByPrimaryKey(scheme);
    }

    public void updateLayers(ExtractSchemeDTO editDTO) {
        DgtExtractScheme scheme = this.extractSchemeDao.selectByPrimaryKey(editDTO.getId());
        Assert.notNull((Object)scheme, (String)("\u672a\u67e5\u8be2\u5230\u6807\u8bc6\u4e3a" + editDTO.getId() + "\u7684\u6a21\u677f"));
        if (editDTO.getLayers() != null && editDTO.getLayers().size() > 0) {
            for (ExtractSchemeLayerDTO layerItem : editDTO.getLayers()) {
                if (layerItem.getFieldsMapping() != null && layerItem.getFieldsMapping().size() != 0) continue;
                layerItem.setFieldsMapping(this.createDefaultSchemeField(layerItem.getDatasetId()));
            }
            scheme.setLayers(JSONArray.toJSONString(editDTO.getLayers()));
        } else {
            scheme.setLayers("");
        }
        this.extractSchemeDao.updateByPrimaryKey(scheme);
    }

    public void delete(String id) {
        this.extractSchemeDao.deleteByPrimaryKey(id);
    }

    public ExtractSchemeDTO getDetail(String id) {
        DgtExtractScheme scheme = this.extractSchemeDao.selectByPrimaryKey(id);
        Assert.notNull((Object)scheme, (String)("\u672a\u67e5\u8be2\u5230\u6807\u8bc6\u4e3a" + id + "\u7684\u6a21\u677f"));
        ExtractSchemeDTO dto = new ExtractSchemeDTO();
        dto.setId(id);
        dto.setName(scheme.getName());
        dto.setDesc(scheme.getDesc());
        dto.setLayers(new ArrayList<ExtractSchemeLayerDTO>());
        if (StringUtil.isNotEmpty((String)scheme.getLayers())) {
            List layers = JSONArray.parseArray((String)scheme.getLayers(), ExtractSchemeLayerDTO.class);
            dto.setLayers(layers);
        }
        return dto;
    }

    private boolean exitSameName(String name) {
        List<DgtExtractScheme> list = this.extractSchemeDao.selectByName(name);
        return list.size() > 0;
    }

    private List<ExtractSchemeFieldDTO> createDefaultSchemeField(String datasetId) {
        ArrayList<ExtractSchemeFieldDTO> list = new ArrayList<ExtractSchemeFieldDTO>();
        DatasetDTO datasetDTO = this.dataSourceService.getDatasetDetail(datasetId);
        if (datasetDTO instanceof FeatureClassDTO) {
            List fields = ((FeatureClassDTO)datasetDTO).getFields();
            for (FieldDTO field : fields) {
                ExtractSchemeFieldDTO schemeFieldDTO = new ExtractSchemeFieldDTO();
                schemeFieldDTO.setSrcFieldName(field.getName());
                schemeFieldDTO.setTargetFieldName(field.getName());
                list.add(schemeFieldDTO);
            }
            return list;
        }
        throw new RuntimeException("\u6570\u636e\u96c6\u7684\u7c7b\u578b\u6709\u8bef\uff01");
    }
}

