/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.frame.util;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.geoway.dgt.frame.enums.VectorFormatEnum;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class VectorFileUtil {
    public static VectorFormatEnum vectorFormat(File file) {
        if (file.isFile()) {
            if (VectorFileUtil.exactlyMatch(file, VectorFormatEnum.GeoPackage)) {
                return VectorFormatEnum.GeoPackage;
            }
            if (VectorFileUtil.exactlyMatch(file, VectorFormatEnum.MDB)) {
                return VectorFormatEnum.MDB;
            }
            if (VectorFileUtil.exactlyMatch(file, VectorFormatEnum.Shapefile)) {
                return VectorFormatEnum.Shapefile;
            }
            if (VectorFileUtil.exactlyMatch(file, VectorFormatEnum.MapInfo)) {
                return VectorFormatEnum.MapInfo;
            }
            if (VectorFileUtil.exactlyMatch(file, VectorFormatEnum.GeoJson)) {
                return VectorFormatEnum.GeoJson;
            }
            if (VectorFileUtil.exactlyMatch(file, VectorFormatEnum.S57)) {
                return VectorFormatEnum.S57;
            }
        } else {
            if (VectorFileUtil.exactlyMatch(file, VectorFormatEnum.Shapefile)) {
                return VectorFormatEnum.Shapefile;
            }
            if (VectorFileUtil.exactlyMatch(file, VectorFormatEnum.FileGDB)) {
                return VectorFormatEnum.FileGDB;
            }
        }
        throw new RuntimeException("\u672a\u77e5\u77e2\u91cf\u7c7b\u578b : " + file.getAbsolutePath());
    }

    public static List<File> getVectorFiles(File dir, int maxDepth) {
        return FileUtil.loopFiles((Path)dir.toPath(), (int)maxDepth, VectorFileUtil::exactlyMatchAny);
    }

    public static List<File> getVectorFiles(File dir, int maxDepth, VectorFormatEnum vectorFormatEnum) {
        if (vectorFormatEnum == null) {
            return VectorFileUtil.getVectorFiles(dir, maxDepth);
        }
        return FileUtil.loopFiles((Path)dir.toPath(), (int)maxDepth, f -> VectorFileUtil.exactlyMatch(f, vectorFormatEnum));
    }

    public static List<File> getVectorFilesByEnums(File dir, int maxDepth, List<VectorFormatEnum> vectorFormatEnums) {
        if (vectorFormatEnums == null || vectorFormatEnums.isEmpty()) {
            return VectorFileUtil.getVectorFiles(dir, maxDepth);
        }
        ArrayList<File> list = new ArrayList<File>();
        if (VectorFileUtil.exactlyMatch(dir, VectorFormatEnum.Shapefile)) {
            list.add(dir);
            for (VectorFormatEnum vectorFormatEnum : vectorFormatEnums) {
                if (vectorFormatEnum == VectorFormatEnum.Shapefile) continue;
                List<File> vectorFiles = VectorFileUtil.getVectorFiles(dir, 1, vectorFormatEnum);
                list.addAll(vectorFiles);
            }
            return list;
        }
        ArrayList<VectorFormatEnum> rasterFormats = new ArrayList<VectorFormatEnum>();
        ArrayList<VectorFormatEnum> otherFormats = new ArrayList<VectorFormatEnum>();
        for (VectorFormatEnum enumItem : vectorFormatEnums) {
            switch (enumItem) {
                case MDB: 
                case FileGDB: 
                case Shapefile: 
                case GeoPackage: 
                case Excel: 
                case Folder: 
                case MapInfo: 
                case GeoJson: 
                case S57: {
                    otherFormats.add(enumItem);
                    break;
                }
                case TIF: 
                case IMG: 
                case ESRI: {
                    rasterFormats.add(enumItem);
                    break;
                }
            }
        }
        ArrayList<File> fileList = new ArrayList<File>();
        if (rasterFormats.size() > 0) {
            fileList.addAll(FileUtil.loopFiles((Path)dir.toPath(), (int)2, f -> {
                for (VectorFormatEnum vectorFormatEnum : rasterFormats) {
                    if (!VectorFileUtil.exactlyMatch(f, vectorFormatEnum)) continue;
                    return true;
                }
                return false;
            }));
        }
        if (otherFormats.size() > 0) {
            fileList.addAll(FileUtil.loopFiles((Path)dir.toPath(), (int)maxDepth, f -> {
                for (VectorFormatEnum vectorFormatEnum : otherFormats) {
                    if (!VectorFileUtil.exactlyMatch(f, vectorFormatEnum)) continue;
                    return true;
                }
                return false;
            }));
        }
        return fileList;
    }

    public static boolean match(File file, VectorFormatEnum vectorFormatEnum) {
        if (VectorFileUtil.exactlyMatch(file, vectorFormatEnum)) {
            return true;
        }
        if (file.isFile()) {
            return false;
        }
        File[] files = file.listFiles();
        if (files == null) {
            return false;
        }
        return Arrays.stream(files).anyMatch(subFile -> VectorFileUtil.exactlyMatch(subFile, vectorFormatEnum));
    }

    public static boolean exactlyMatchFile(File file) {
        return VectorFileUtil.exactlyMatch(file, VectorFormatEnum.MDB) || VectorFileUtil.exactlyMatch(file, VectorFormatEnum.GeoPackage) || VectorFileUtil.exactlyMatch(file, VectorFormatEnum.Shapefile) || VectorFileUtil.exactlyMatch(file, VectorFormatEnum.Excel);
    }

    public static boolean exactlyMatchDir(File file) {
        return VectorFileUtil.exactlyMatch(file, VectorFormatEnum.FileGDB) || VectorFileUtil.exactlyMatch(file, VectorFormatEnum.Shapefile);
    }

    public static boolean exactlyMatchAny(File file) {
        return VectorFileUtil.exactlyMatchFile(file) || VectorFileUtil.exactlyMatchDir(file);
    }

    public static boolean exactlyMatch(File file, VectorFormatEnum vectorFormatEnum) {
        if (vectorFormatEnum == null) {
            return VectorFileUtil.exactlyMatchAny(file);
        }
        switch (vectorFormatEnum) {
            case MDB: {
                if (file.isDirectory()) {
                    return false;
                }
                return "mdb".equalsIgnoreCase(FileUtil.getSuffix((File)file));
            }
            case FileGDB: {
                if (file.isFile()) {
                    return false;
                }
                if (!StrUtil.endWithIgnoreCase((CharSequence)file.getAbsolutePath(), (CharSequence)".gdb")) {
                    return false;
                }
                List gdb = FileUtil.loopFiles((File)file, (int)1, f -> f.getName().equalsIgnoreCase("gdb"));
                return gdb.size() > 0;
            }
            case Shapefile: {
                if (file.isFile()) {
                    return StrUtil.endWithIgnoreCase((CharSequence)file.getAbsolutePath(), (CharSequence)".shp");
                }
                List files = FileUtil.loopFiles((File)file, (int)1, f -> "shp".equalsIgnoreCase(FileUtil.getSuffix((File)f)));
                return files.size() > 0;
            }
            case GeoPackage: {
                if (file.isDirectory()) {
                    return false;
                }
                return "gpkg".equalsIgnoreCase(FileUtil.getSuffix((File)file));
            }
            case MapInfo: {
                if (file.isFile()) {
                    return StrUtil.endWithIgnoreCase((CharSequence)file.getAbsolutePath(), (CharSequence)".mif");
                }
                List files = FileUtil.loopFiles((File)file, (int)1, f -> "mif".equalsIgnoreCase(FileUtil.getSuffix((File)f)));
                return files.size() > 0;
            }
            case GeoJson: {
                if (file.isDirectory()) {
                    return false;
                }
                return "geojson".equalsIgnoreCase(FileUtil.getSuffix((File)file));
            }
            case S57: {
                if (file.isDirectory()) {
                    return false;
                }
                return "000".equalsIgnoreCase(FileUtil.getSuffix((File)file));
            }
            case TIF: {
                if (file.isDirectory()) {
                    return false;
                }
                return "tif".equalsIgnoreCase(FileUtil.getSuffix((File)file));
            }
            case IMG: {
                if (file.isDirectory()) {
                    return false;
                }
                return "img".equalsIgnoreCase(FileUtil.getSuffix((File)file));
            }
            case ESRI: {
                if (file.isDirectory()) {
                    if (new File(file, "w001001.adf").exists()) {
                        return true;
                    }
                    File[] subFiles = file.listFiles();
                    if (subFiles == null) {
                        return false;
                    }
                    for (File subFile : subFiles) {
                        if (!new File(subFile, "w001001.adf").exists()) continue;
                        return true;
                    }
                }
                return false;
            }
            case Excel: {
                if (file.isDirectory()) {
                    return false;
                }
                return "xls".equalsIgnoreCase(FileUtil.getSuffix((File)file)) || "xlsx".equalsIgnoreCase(FileUtil.getSuffix((File)file)) || "csv".equalsIgnoreCase(FileUtil.getSuffix((File)file));
            }
            case Folder: {
                return file.isDirectory();
            }
        }
        throw new RuntimeException("\u672a\u77e5\u9519\u8bef");
    }

    public static String mainName(File file) {
        String mainName = FileUtil.mainName((File)file);
        if (StrUtil.endWithIgnoreCase((CharSequence)mainName, (CharSequence)".gdb")) {
            return StrUtil.subBefore((CharSequence)mainName, (CharSequence)".", (boolean)true);
        }
        if (StrUtil.endWithIgnoreCase((CharSequence)mainName, (CharSequence)".shp")) {
            return StrUtil.subBefore((CharSequence)mainName, (CharSequence)".", (boolean)true);
        }
        return mainName;
    }
}

