/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.frame.service;

import com.geoway.adf.dms.common.util.DateTimeUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.gis.basic.PageList;
import com.geoway.dgt.frame.constants.TaskStatusEnum;
import com.geoway.dgt.frame.dao.DgtTaskDao;
import com.geoway.dgt.frame.dao.DgtTaskItemDao;
import com.geoway.dgt.frame.dao.DgtTaskLogDao;
import com.geoway.dgt.frame.dao.DgtTaskSubItemDao;
import com.geoway.dgt.frame.dto.FlowTaskCreateDTO;
import com.geoway.dgt.frame.dto.TaskCreateDTO;
import com.geoway.dgt.frame.dto.TaskDTO;
import com.geoway.dgt.frame.dto.TaskItemDTO;
import com.geoway.dgt.frame.dto.TaskLogDTO;
import com.geoway.dgt.frame.entity.DgtTask;
import com.geoway.dgt.frame.entity.DgtTaskItem;
import com.geoway.dgt.frame.entity.DgtTaskSubItem;
import com.geoway.dgt.frame.manager.ToolTaskManager;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ToolTaskService {
    @Resource
    private DgtTaskDao taskDao;
    @Resource
    private DgtTaskItemDao taskItemDao;
    @Resource
    private DgtTaskSubItemDao taskSubItemDao;
    @Resource
    private DgtTaskLogDao taskLogDao;
    @Resource
    private ToolTaskManager taskManager;

    public String createTask(TaskCreateDTO taskCreateDTO) {
        DgtTask impTask = this.taskManager.createTask(taskCreateDTO);
        if (Boolean.TRUE.equals(taskCreateDTO.getStartTask())) {
            this.startTask(impTask.getId());
        }
        return impTask.getId();
    }

    public String createTaskFlow(FlowTaskCreateDTO taskFlowCreateDTO) {
        if (taskFlowCreateDTO.getFlowParam() == null || taskFlowCreateDTO.getFlowParam().getToolParamList() == null || taskFlowCreateDTO.getFlowParam().getToolParamList().size() == 0) {
            throw new RuntimeException("\u672a\u8f93\u5165\u6d41\u7a0b\u53c2\u6570");
        }
        DgtTask impTask = this.taskManager.createFlowTask(taskFlowCreateDTO);
        if (Boolean.TRUE.equals(taskFlowCreateDTO.getStartTask())) {
            this.startTask(impTask.getId());
        }
        return impTask.getId();
    }

    public void startTask(String taskId) {
        DgtTask task = this.taskDao.selectByPrimaryKey(taskId);
        Assert.notNull((Object)task, (String)"\u4efb\u52a1\u4e0d\u5b58\u5728");
        if (task.getStatus().intValue() == TaskStatusEnum.Processing.getValue()) {
            return;
        }
        this.taskItemDao.resetStatus(taskId);
        this.taskManager.execute(task);
    }

    public void stopTask(String taskId) {
        this.taskManager.stopTask(taskId);
    }

    public void deleteTask(String taskId) {
        DgtTask task = this.taskDao.selectByPrimaryKey(taskId);
        if (task != null) {
            if (task.getStatus().intValue() == TaskStatusEnum.Processing.getValue()) {
                throw new RuntimeException("\u4efb\u52a1\u6b63\u5728\u6267\u884c\uff0c\u4e0d\u80fd\u5220\u9664");
            }
            this.taskDao.deleteByPrimaryKey(taskId);
        }
    }

    public PageList<TaskDTO> listTask(int pageIndex, int rows, String status, Integer type, String keyword) {
        PageHelper.startPage((int)(pageIndex + 1), (int)rows);
        List statusList = null;
        if (StringUtil.isNotEmpty((String)status)) {
            statusList = StringUtil.split((String)status, (String)",", Integer::valueOf);
        }
        List<DgtTask> dgtTasks = this.taskDao.selectByStatus(statusList, type, keyword);
        PageInfo pageInfo = new PageInfo(dgtTasks);
        List taskDTOS = ListUtil.convertAll(dgtTasks, t -> {
            TaskDTO taskDTO = new TaskDTO();
            BeanUtils.copyProperties((Object)t, (Object)taskDTO);
            taskDTO.setProgress(this.getDataProgress(t.getStatus(), t.getSuccessCount(), t.getFailCount(), t.getTotalCount()));
            taskDTO.setTimeCost(this.getTimeCost(t.getStartTime(), t.getEndTime()));
            return taskDTO;
        });
        return new PageList(taskDTOS, Long.valueOf(pageInfo.getTotal()));
    }

    public TaskDTO getTaskDetail(String taskId, int itemPageIndex, int itemRows, String itemStatus, String itemKeyword) {
        DgtTask dgtTask = this.taskDao.selectByPrimaryKey(taskId);
        Assert.notNull((Object)dgtTask, (String)"\u4efb\u52a1\u4e0d\u5b58\u5728");
        TaskDTO taskDTO = new TaskDTO();
        BeanUtils.copyProperties((Object)dgtTask, (Object)taskDTO);
        taskDTO.setProgress(this.getDataProgress(dgtTask.getStatus(), dgtTask.getSuccessCount(), dgtTask.getFailCount(), dgtTask.getTotalCount()));
        taskDTO.setTimeCost(this.getTimeCost(dgtTask.getStartTime(), dgtTask.getEndTime()));
        taskDTO.setItems(this.listTaskItem(taskId, itemPageIndex, itemRows, itemStatus, itemKeyword));
        Integer runningCount = this.taskItemDao.selectCountByStatus(taskId, Collections.singletonList(2));
        if (runningCount == null) {
            runningCount = 0;
        }
        taskDTO.setRunningCount((long)runningCount);
        taskDTO.setReadyCount(taskDTO.getTotalCount() - taskDTO.getSuccessCount() - taskDTO.getFailCount() - taskDTO.getRunningCount());
        return taskDTO;
    }

    public List<TaskLogDTO> getTasklogs(String taskItemId, String toolId) {
        return this.taskLogDao.selectLogs(taskItemId, toolId);
    }

    private PageList<TaskItemDTO> listTaskItem(String taskId, int pageIndex, int rows, String status, String keyword) {
        PageHelper.startPage((int)(pageIndex + 1), (int)rows);
        List statusList = null;
        if (StringUtil.isNotEmpty((String)status)) {
            statusList = StringUtil.split((String)status, (String)",", Integer::valueOf);
        }
        List<DgtTaskItem> taskItemList = this.taskItemDao.selectByTaskId(taskId, statusList, keyword);
        PageInfo pageInfo = new PageInfo(taskItemList);
        long total = pageInfo.getTotal();
        PageHelper.clearPage();
        ArrayList itemDTOS = new ArrayList();
        List taskItemIdList = ListUtil.convertAll(taskItemList, DgtTaskItem::getId);
        if (taskItemIdList.size() > 0) {
            List<DgtTaskSubItem> allSubItems = this.taskSubItemDao.selectByTaskItemIdList(taskItemIdList);
            taskItemList.forEach(dgtTaskItem -> {
                TaskItemDTO taskUnitDTO = new TaskItemDTO();
                BeanUtils.copyProperties((Object)dgtTaskItem, (Object)taskUnitDTO);
                taskUnitDTO.setTimeCost(this.getTimeCost(dgtTaskItem.getStartTime(), dgtTaskItem.getEndTime()));
                if (allSubItems.size() > 0) {
                    List subItems = ListUtil.findAll((List)allSubItems, f -> dgtTaskItem.getId().equals(f.getTaskItemId()));
                    taskUnitDTO.setChildren(ListUtil.convertAll((List)subItems, this::subItemToItem));
                }
                itemDTOS.add(taskUnitDTO);
            });
        }
        return new PageList(itemDTOS, Long.valueOf(total));
    }

    private TaskItemDTO subItemToItem(DgtTaskSubItem subItem) {
        TaskItemDTO dto = new TaskItemDTO();
        dto.setId(subItem.getId());
        dto.setName(subItem.getName());
        dto.setStatus(subItem.getStatus());
        dto.setTimeCost(this.getTimeCost(subItem.getStartTime(), subItem.getEndTime()));
        dto.setStartTime(subItem.getStartTime());
        dto.setEndTime(subItem.getEndTime());
        return dto;
    }

    private String getTimeCost(Date startTime, Date endTime) {
        if (startTime != null) {
            if (endTime == null) {
                endTime = new Date();
            }
            return DateTimeUtil.getTimeIntervalStr((Date)startTime, (Date)endTime);
        }
        return null;
    }

    private int getDataProgress(Integer status, Long success, Long fail, Long total) {
        success = success == null ? 0L : success;
        fail = fail == null ? 0L : fail;
        total = total == null ? 0L : total;
        if (status.intValue() == TaskStatusEnum.FinishedSuccessed.getValue()) {
            return 100;
        }
        if (total == 0L) {
            return 0;
        }
        int progress = (int)((double)(success + fail) * 100.0 / (double)total.longValue());
        progress = progress > 100 ? 100 : Math.max(progress, 0);
        return progress;
    }
}

