/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.frame.service;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.dgt.frame.constants.ToolTypeEnum;
import com.geoway.dgt.frame.dao.DgtToolDao;
import com.geoway.dgt.frame.dao.DgtToolFlowDao;
import com.geoway.dgt.frame.dto.ToolDTO;
import com.geoway.dgt.frame.dto.ToolFlowCreateDTO;
import com.geoway.dgt.frame.entity.DgtTool;
import com.geoway.dgt.frame.entity.DgtToolFlow;
import com.geoway.dgt.frame.tools.IToolParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class ToolService {
    private static final Logger log = LoggerFactory.getLogger(ToolService.class);
    @Resource
    private DgtToolDao toolDao;
    @Resource
    private DgtToolFlowDao toolFlowDao;

    public List<ToolDTO> listTool(Boolean onlyCanFlow) {
        List<DgtTool> dgtToolList = this.toolDao.selectAll();
        return this.buildToolDTOs(dgtToolList, null, onlyCanFlow);
    }

    private List<ToolDTO> buildToolDTOs(List<DgtTool> dgtToolList, ToolDTO parentTool, Boolean onlyCanFlow) {
        List subTools = parentTool == null ? ListUtil.findAll(dgtToolList, t -> StringUtil.isEmpty((String)t.getPid())) : ListUtil.findAll(dgtToolList, t -> parentTool.getId().equals(t.getPid()));
        ArrayList<ToolDTO> toolDTOS = new ArrayList<ToolDTO>();
        for (DgtTool dgtTool : subTools) {
            if (dgtTool.getEnable() < 1 || Boolean.TRUE.equals(onlyCanFlow) && !Short.valueOf((short)1).equals(dgtTool.getCanFlow())) continue;
            ToolDTO sTool = this.convertTool(dgtTool);
            sTool.setSubTools(this.buildToolDTOs(dgtToolList, sTool, onlyCanFlow));
            toolDTOS.add(sTool);
        }
        return toolDTOS;
    }

    public List<ToolDTO> listToolFlow() {
        List<DgtToolFlow> dgtToolFlowList = this.toolFlowDao.selectAll();
        if (dgtToolFlowList.size() == 0) {
            return new ArrayList<ToolDTO>();
        }
        Map<String, List<DgtToolFlow>> flowMap = dgtToolFlowList.stream().collect(Collectors.groupingBy(f -> StringUtil.isEmpty((String)f.getGroup()) ? "\u9ed8\u8ba4" : f.getGroup()));
        List<DgtTool> allTools = this.toolDao.selectAll();
        ArrayList<ToolDTO> allFlowDTOS = new ArrayList<ToolDTO>();
        for (Map.Entry<String, List<DgtToolFlow>> entry : flowMap.entrySet()) {
            ToolDTO groupToolDTO = new ToolDTO();
            groupToolDTO.setId(entry.getKey());
            groupToolDTO.setName(entry.getKey());
            groupToolDTO.setType(ToolTypeEnum.Group.getValue());
            ArrayList<ToolDTO> toolFlowDTOS = new ArrayList<ToolDTO>();
            for (DgtToolFlow dgtToolFlow : dgtToolFlowList) {
                ToolDTO toolFlowDTO = this.convertFlowTool(dgtToolFlow, allTools);
                toolFlowDTOS.add(toolFlowDTO);
            }
            groupToolDTO.setSubTools(toolFlowDTOS);
            allFlowDTOS.add(groupToolDTO);
        }
        return allFlowDTOS;
    }

    public List<ToolDTO> listToolAndFlow(String flowRootName) {
        List<ToolDTO> toolList = this.listTool(true);
        ToolDTO rootFlowGroup = new ToolDTO();
        rootFlowGroup.setId("root_group");
        if (StringUtil.isEmpty((String)flowRootName)) {
            rootFlowGroup.setName("\u6211\u7684\u65b9\u6848");
        } else {
            rootFlowGroup.setName(flowRootName);
        }
        rootFlowGroup.setType(-1);
        rootFlowGroup.setSubTools(new ArrayList<ToolDTO>());
        toolList.add(rootFlowGroup);
        List<DgtToolFlow> dgtToolFlowList = this.toolFlowDao.selectAll();
        Map<String, List<DgtToolFlow>> flowMap = dgtToolFlowList.stream().collect(Collectors.groupingBy(f -> StringUtil.isEmpty((String)f.getGroup()) ? "\u9ed8\u8ba4" : f.getGroup()));
        List<DgtTool> allTools = this.toolDao.selectAll();
        for (Map.Entry<String, List<DgtToolFlow>> entry : flowMap.entrySet()) {
            for (DgtToolFlow dgtToolFlow : entry.getValue()) {
                ToolDTO toolFlowDTO = this.convertFlowTool(dgtToolFlow, allTools);
                rootFlowGroup.getSubTools().add(toolFlowDTO);
            }
        }
        return toolList;
    }

    public List<ToolDTO> listToolAndFlow(String category, String flowRootName) {
        List<ToolDTO> toolList = this.listTool(true);
        ToolDTO rootFlowGroup = new ToolDTO();
        rootFlowGroup.setId("root_group");
        if (StringUtil.isEmpty((String)flowRootName)) {
            rootFlowGroup.setName("\u6211\u7684\u65b9\u6848");
        } else {
            rootFlowGroup.setName(flowRootName);
        }
        rootFlowGroup.setType(-1);
        rootFlowGroup.setSubTools(new ArrayList<ToolDTO>());
        toolList.add(rootFlowGroup);
        List<DgtToolFlow> dgtToolFlowList = this.toolFlowDao.selectByCategory(category);
        Map<String, List<DgtToolFlow>> flowMap = dgtToolFlowList.stream().collect(Collectors.groupingBy(f -> StringUtil.isEmpty((String)f.getGroup()) ? "\u9ed8\u8ba4" : f.getGroup()));
        List<DgtTool> allTools = this.toolDao.selectAll();
        for (Map.Entry<String, List<DgtToolFlow>> entry : flowMap.entrySet()) {
            for (DgtToolFlow dgtToolFlow : entry.getValue()) {
                ToolDTO toolFlowDTO = this.convertFlowTool(dgtToolFlow, allTools);
                rootFlowGroup.getSubTools().add(toolFlowDTO);
            }
        }
        return toolList;
    }

    public String addToolFlow(ToolFlowCreateDTO toolFlowDTO) {
        DgtToolFlow dgtToolFlow = new DgtToolFlow();
        dgtToolFlow.setId(UUID.randomUUID().toString());
        dgtToolFlow.setName(toolFlowDTO.getName());
        dgtToolFlow.setGroup(toolFlowDTO.getGroup());
        dgtToolFlow.setTools(toolFlowDTO.getToolIds());
        dgtToolFlow.setCategory(toolFlowDTO.getCategory());
        this.toolFlowDao.insertSelective(dgtToolFlow);
        return dgtToolFlow.getId();
    }

    public void deleteToolFlow(String id) {
        this.toolFlowDao.deleteByPrimaryKey(id);
    }

    private ToolDTO convertTool(DgtTool dgtTool) {
        ToolDTO sTool = new ToolDTO();
        BeanUtils.copyProperties((Object)dgtTool, (Object)sTool);
        if (StringUtil.isNotEmpty((String)dgtTool.getParamClassName())) {
            try {
                Class<?> aClass = Class.forName(dgtTool.getParamClassName());
                IToolParam toolParam = (IToolParam)aClass.newInstance();
                String paramStr = JSONObject.toJSONString((Object)toolParam, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                sTool.setParamFormat(paramStr);
            }
            catch (Exception e) {
                log.error(dgtTool.getParamClassName() + "\u5de5\u5177\u53c2\u6570\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
            }
        }
        return sTool;
    }

    private ToolDTO convertFlowTool(DgtToolFlow dgtToolFlow, List<DgtTool> allTools) {
        ToolDTO toolFlowDTO = new ToolDTO();
        toolFlowDTO.setId(dgtToolFlow.getId());
        toolFlowDTO.setName(dgtToolFlow.getName());
        toolFlowDTO.setType(ToolTypeEnum.Flow.getValue());
        String[] ids = dgtToolFlow.getTools().split(",");
        ArrayList<ToolDTO> tools = new ArrayList<ToolDTO>();
        for (String toolId : ids) {
            DgtTool dgtTool = (DgtTool)ListUtil.find(allTools, t -> t.getId().equals(toolId));
            if (dgtTool == null) continue;
            ToolDTO toolDTO = this.convertTool(dgtTool);
            tools.add(toolDTO);
        }
        toolFlowDTO.setSubTools(tools);
        return toolFlowDTO;
    }
}

