/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.globemodel;

import com.geoway.adf.dms.common.config.UploadPathConfig;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class HttpHelper {
    private static final Logger log = LoggerFactory.getLogger(UploadPathConfig.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, MultipartFile file, List<NameValuePair> params) throws Exception {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        entityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        entityBuilder.setCharset(StandardCharsets.UTF_8);
        String resultString = "";
        try {
            HttpPost httpPost = new HttpPost(url);
            if (file != null && !file.isEmpty()) {
                entityBuilder.addBinaryBody("file", file.getInputStream(), ContentType.create((String)"multipart/form-data", (Charset)Consts.UTF_8), file.getOriginalFilename());
                if (params != null && params.size() > 0) {
                    params.forEach(item -> entityBuilder.addTextBody(item.getName(), item.getValue()));
                }
                HttpEntity httpEntity = entityBuilder.build();
                httpPost.setEntity(httpEntity);
            } else if (params != null && params.size() > 0) {
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, StandardCharsets.UTF_8));
            }
            response = httpClient.execute((HttpUriRequest)httpPost);
            resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        return resultString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String url) throws Exception {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        String resultString = "";
        try (CloseableHttpResponse response = null;){
            HttpGet httpGet = new HttpGet(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(50000).setConnectionRequestTimeout(50000).setSocketTimeout(50000).build();
            httpGet.setConfig(requestConfig);
            response = httpClient.execute((HttpUriRequest)httpGet);
            resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
        }
        return resultString;
    }
}

