/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.onecode.tool;

import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.util.GeoDatasetUtil;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.cursor.IRow;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.QueryFilter;
import com.geoway.dgt.frame.constants.TaskLogLevelEnum;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.ToolBase;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.DataStripingResult;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.onecode.entity.CodeRecord;
import com.geoway.dgt.onecode.manager.GraphDatabaseManager;
import com.geoway.dgt.onecode.service.CodeEntityClassService;
import com.geoway.dgt.onecode.service.CodeRecordService;
import com.geoway.dgt.onecode.tool.BasicGeoCodingToolParam;
import com.geoway.webstore.realscene.code.GeoCodingService;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;

public class BasicGeoCodingTool
extends ToolBase {
    protected final int maxErrorLogCount = 100;
    protected final int batchCount = 100000;
    protected static final DecimalFormat decimalFormat = new DecimalFormat("###################.###########");
    protected GeoDatabaseService geoDatabaseService = (GeoDatabaseService)SpringContextUtil.getBean(GeoDatabaseService.class);
    protected GeoCodingService geoCodingService = (GeoCodingService)SpringContextUtil.getBean(GeoCodingService.class);
    protected GraphDatabaseManager graphDatabaseManager = (GraphDatabaseManager)SpringContextUtil.getBean(GraphDatabaseManager.class);
    protected CodeEntityClassService codeEntityClassService = (CodeEntityClassService)SpringContextUtil.getBean(CodeEntityClassService.class);
    protected CodeRecordService codeRecordService = (CodeRecordService)SpringContextUtil.getBean(CodeRecordService.class);

    public void batchDataStriping(DataParam batchInputData, DataParam batchOutputData, IToolParam toolParam, Consumer<DataStripingResult> oneDataCallback) {
        DataStripingResult item = new DataStripingResult();
        item.setName(batchInputData.getName());
        item.setInputData(batchInputData);
        item.setOutputData(batchOutputData);
        item.setToolExecuteParam(toolParam);
        oneDataCallback.accept(item);
    }

    public ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputDataPath, IToolParam toolParam) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResult execute(DataParam inputDataParam, DataParam outputDataParam, IToolParam executeParam) {
        ExecuteResult executeResult = new ExecuteResult();
        this.invokeExcuteLog("\u5f00\u59cb\u5904\u7406\u6570\u636e\uff1a" + inputDataParam.getName());
        IFeatureWorkspace workspace = null;
        IFeatureCursor cursor = null;
        Driver graphDriver = null;
        Session session = null;
        int successCount = 0;
        int failCount = 0;
        try {
            Map<String, String> classNameMap = this.codeEntityClassService.getClassNames();
            if (classNameMap.size() == 0) {
                this.invokeExcuteLog("\u672a\u914d\u7f6e\u5b9e\u4f53\u5206\u7c7b", TaskLogLevelEnum.Error);
                executeResult.setSuccess(Boolean.valueOf(false));
                ExecuteResult executeResult2 = executeResult;
                return executeResult2;
            }
            workspace = this.geoDatabaseService.openGeoWorkspace(inputDataParam.getDsKey());
            IFeatureClass dltbTable = workspace.openFeatureClass(inputDataParam.getName());
            if (dltbTable == null) {
                this.invokeExcuteLog(inputDataParam.getName() + "\u6570\u636e\u6253\u5f00\u5931\u8d25", TaskLogLevelEnum.Error);
                executeResult.setSuccess(Boolean.valueOf(false));
                ExecuteResult executeResult3 = executeResult;
                return executeResult3;
            }
            BasicGeoCodingToolParam geoCodeParam = (BasicGeoCodingToolParam)executeParam;
            String datasetId = GeoDatasetUtil.getGeoDatasetId((String)inputDataParam.getDsKey(), (IGeoDataset)dltbTable);
            IField dlmcField = dltbTable.getFields().findField(geoCodeParam.getDlmcField());
            if (dlmcField == null) {
                this.invokeExcuteLog("\u5730\u7c7b\u540d\u79f0\u5b57\u6bb5\u4e0d\u5b58\u5728\uff1a" + geoCodeParam.getDlmcField(), TaskLogLevelEnum.Error);
                executeResult.setSuccess(Boolean.valueOf(false));
                ExecuteResult executeResult4 = executeResult;
                return executeResult4;
            }
            if (!dltbTable.getFields().contains("bsm")) {
                this.invokeExcuteLog("\u5730\u7c7b\u6807\u8bc6\u7801\u5b57\u6bb5\u4e0d\u5b58\u5728\uff1absm", TaskLogLevelEnum.Error);
                executeResult.setSuccess(Boolean.valueOf(false));
                ExecuteResult executeResult5 = executeResult;
                return executeResult5;
            }
            graphDriver = this.graphDatabaseManager.getNeo4jDriver(geoCodeParam.getGraphDbKey());
            session = graphDriver.session();
            this.graphDatabaseManager.addGraphIndex(graphDriver, datasetId);
            boolean overwrite = Boolean.TRUE.equals(geoCodeParam.getOverwrite());
            if (overwrite) {
                int delCount = this.geoCodingService.deleteByBizFlag("dltb", datasetId);
                this.invokeExcuteLog("\u5220\u9664\u5b9e\u4f53\u7801" + delCount + "\u4e2a");
                try {
                    Result result = session.run(String.format("Call apoc.periodic.iterate(\"MATCH (n:`%s`) return id(n) as id\", \"MATCH (n) WHERE id(n) = id DETACH DELETE n\", {batchSize:50000}) yield batches, total return batches, total", datasetId));
                    this.log.info(result.next().toString());
                }
                catch (Exception e) {
                    this.invokeExcuteLog("\u5220\u9664\u5b9e\u4f53\u5931\u8d25", e);
                }
            }
            String guid = UUID.randomUUID().toString();
            String csvPath = this.graphDatabaseManager.getTempPath(guid);
            FileUtil.mkdirs((String)csvPath);
            BufferedWriter csvWriter = null;
            int fileIndex = 0;
            int entityCount = 0;
            LinkedHashMap<String, String> nodePropertys = new LinkedHashMap<String, String>();
            boolean needProject = false;
            ISpatialReferenceSystem spatialReferenceSystem = null;
            if (dltbTable.getSpatialReferenceSystem() != null && dltbTable.getSpatialReferenceSystem().getType() != SpatialReferenceSystemType.Geographic) {
                needProject = true;
                spatialReferenceSystem = SpatialReferenceSystemFunc.createSpatialReference((int)4490);
            }
            ArrayList<String> fields = new ArrayList<String>();
            fields.add(dltbTable.getOidFieldName());
            fields.add(dltbTable.getShapeFieldName());
            fields.add(geoCodeParam.getDlmcField());
            fields.add("bsm");
            fields.add("tbmj");
            if (dltbTable.getFields().contains("dlbm")) {
                fields.add("dlbm");
            }
            if (dltbTable.getFields().contains("tbbh")) {
                fields.add("tbbh");
            }
            int errorLogCount = 0;
            QueryFilter filter = new QueryFilter();
            filter.setSubFields(String.join((CharSequence)",", fields));
            cursor = dltbTable.searchFeature((IQueryFilter)filter);
            IFeature feature = cursor.nextFeature();
            while (feature != null) {
                if (this.isAborted()) {
                    throw new RuntimeException("\u4efb\u52a1\u5df2\u88ab\u4e2d\u6b62");
                }
                try {
                    String nodeId = datasetId + "-" + feature.getObjectId();
                    if (!overwrite && this.graphDatabaseManager.existEntityNode(session, nodeId)) {
                        ++successCount;
                        continue;
                    }
                    String dlmc = this.valueOf((IRow)feature, geoCodeParam.getDlmcField());
                    String dlbm = this.valueOf((IRow)feature, "dlbm");
                    String bsm = this.valueOf((IRow)feature, "bsm");
                    String tbmj = this.valueOf((IRow)feature, "tbmj");
                    String tbbh = this.valueOf((IRow)feature, "tbbh");
                    if (StringUtil.isEmpty((String)dlmc)) {
                        this.invokeExcuteLog(feature.getObjectId() + "\u5730\u7c7b\u540d\u79f0\u4e3a\u7a7a", TaskLogLevelEnum.Error, ++errorLogCount);
                        ++failCount;
                        continue;
                    }
                    if (StringUtil.isEmpty((String)bsm)) {
                        this.invokeExcuteLog(feature.getObjectId() + "\u5730\u7c7b\u6807\u8bc6\u7801\u4e3a\u7a7a", TaskLogLevelEnum.Error, ++errorLogCount);
                        ++failCount;
                        continue;
                    }
                    String xzqdm = bsm.substring(0, 6);
                    String entityClass = classNameMap.get(dlmc);
                    if (StringUtil.isEmpty((String)entityClass)) {
                        this.invokeExcuteLog(feature.getObjectId() + "-" + dlmc + " \u672a\u5339\u914d\u5230\u5b9e\u4f53\u5206\u7c7b\u4ee3\u7801", TaskLogLevelEnum.Error, ++errorLogCount);
                        ++failCount;
                        continue;
                    }
                    IGeometry geometry = feature.getGeometry();
                    if (geometry == null) {
                        this.invokeExcuteLog(feature.getObjectId() + "\u51e0\u4f55\u4e3a\u7a7a", TaskLogLevelEnum.Error, ++errorLogCount);
                        ++failCount;
                        continue;
                    }
                    if (needProject) {
                        geometry = geometry.projectToCopy(dltbTable.getSpatialReferenceSystem(), spatialReferenceSystem);
                    }
                    double xmin = geometry.getEnvelope().getXMin();
                    double ymin = geometry.getEnvelope().getYMin();
                    double xmax = geometry.getEnvelope().getXMax();
                    double ymax = geometry.getEnvelope().getYMax();
                    String entityID = this.geoCodingService.geoCodingEntityCode(xmin, ymin, xmax, ymax, entityClass, 8, 4, null, "dltb", datasetId);
                    nodePropertys.put("node_id", nodeId);
                    nodePropertys.put("node_class", "\u81ea\u7136\u8d44\u6e90\u5b9e\u4f53");
                    nodePropertys.put("node_name", dlmc);
                    nodePropertys.put("stma", entityID);
                    nodePropertys.put("stfl", entityClass);
                    nodePropertys.put("year", geoCodeParam.getDataYear());
                    nodePropertys.put("xzqdm", xzqdm);
                    nodePropertys.put("ywlx", geoCodeParam.getBizCode());
                    nodePropertys.put("bsm", bsm);
                    nodePropertys.put("dlbm", dlbm);
                    nodePropertys.put("tbmj", tbmj);
                    nodePropertys.put("tbbh", tbbh);
                    nodePropertys.put("code_type", "01");
                    if (csvWriter == null) {
                        File csvFile = new File(csvPath, "entity" + ++fileIndex + ".csv");
                        csvFile.createNewFile();
                        csvWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(csvFile), StandardCharsets.UTF_8), 1024);
                    }
                    this.graphDatabaseManager.appendEntityNode(csvWriter, nodePropertys);
                    if (++entityCount == 100000) {
                        csvWriter.flush();
                        csvWriter.close();
                        csvWriter = null;
                        entityCount = 0;
                        this.graphDatabaseManager.importEntityNode(graphDriver, datasetId, nodePropertys.keySet(), guid, "entity" + fileIndex);
                    }
                    ++successCount;
                }
                catch (Exception e) {
                    this.invokeExcuteLog(feature.getObjectId() + "\u5904\u7406\u5931\u8d25", e, ++errorLogCount);
                    ++failCount;
                }
                finally {
                    feature = cursor.nextFeature();
                }
            }
            if (csvWriter != null) {
                csvWriter.flush();
                csvWriter.close();
                csvWriter = null;
                this.graphDatabaseManager.importEntityNode(graphDriver, datasetId, nodePropertys.keySet(), guid, "entity" + fileIndex);
            }
            if (successCount > 0) {
                CodeRecord codeRecord = new CodeRecord();
                codeRecord.setDatasetId(datasetId);
                codeRecord.setBizClassCode(geoCodeParam.getBizCode());
                codeRecord.setDataYear(geoCodeParam.getDataYear());
                this.codeRecordService.saveCodeRecord(codeRecord);
            }
            this.invokeExcuteLog(String.format("[%s]\u8d4b\u7801\u5b8c\u6210\uff0c\u6210\u529f%d\u6761\uff0c\u5931\u8d25%d\u6761", inputDataParam.getName(), successCount, failCount));
            executeResult.setSuccess(Boolean.valueOf(failCount == 0));
        }
        catch (Exception e) {
            this.invokeExcuteLog(String.format("[%s]\u8d4b\u7801\u5931\u8d25", inputDataParam.getName()), e);
            executeResult.setSuccess(Boolean.valueOf(false));
        }
        finally {
            if (cursor != null) {
                cursor.release();
            }
            if (workspace != null) {
                workspace.close();
            }
            if (session != null) {
                session.close();
            }
            if (graphDriver != null) {
                graphDriver.close();
            }
        }
        return executeResult;
    }

    protected void invokeExcuteLog(String logMsg, TaskLogLevelEnum logLevelEnum, int errorLogCount) {
        if (errorLogCount <= this.maxErrorLogCount) {
            this.invokeExcuteLog(logMsg, logLevelEnum);
        } else {
            this.log.error(logMsg);
        }
    }

    protected void invokeExcuteLog(String logMsg, Throwable exceptionThrow, int errorLogCount) {
        if (errorLogCount <= this.maxErrorLogCount) {
            this.invokeExcuteLog(logMsg, exceptionThrow);
        } else {
            this.log.error(logMsg, exceptionThrow);
        }
    }

    protected void deleteDatasetIndex(Session session, String datasetId) {
        try {
            session.run(String.format("drop index on :`%s`(%s)", datasetId, "bsm"));
        }
        catch (Exception e) {
            this.log.error(datasetId + "\u5220\u9664\u7d22\u5f15\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    protected String valueOf(IRow row, String fld) {
        Object value = row.getValue(fld);
        return value == null ? null : value.toString();
    }
}

