/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.onecode.tool;

import cn.hutool.core.util.IdUtil;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.util.GeoDatasetUtil;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.cursor.ICursor;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.cursor.IRow;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.QueryFilter;
import com.geoway.dgt.frame.constants.TaskLogLevelEnum;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.onecode.entity.CodeRecord;
import com.geoway.dgt.onecode.tool.BasicGeoCodingTool;
import com.geoway.dgt.onecode.tool.UpdateGeoCodingToolParam;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.value.NodeValue;
import org.neo4j.driver.types.Node;

public class UpdateGeoCodingTool
extends BasicGeoCodingTool {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecuteResult execute(DataParam inputDataParam, DataParam outputDataParam, IToolParam executeParam) {
        ExecuteResult executeResult = new ExecuteResult();
        this.invokeExcuteLog("\u5f00\u59cb\u5904\u7406\u6570\u636e\uff1a" + inputDataParam.getName());
        IFeatureWorkspace workspace = null;
        IFeatureCursor cursor = null;
        IFeatureWorkspace previousWorkspace = null;
        IFeatureWorkspace changeWorkspace = null;
        Driver graphDriver = null;
        Session session = null;
        int successCount = 0;
        int failCount = 0;
        try {
            UpdateGeoCodingToolParam geoCodeParam = (UpdateGeoCodingToolParam)executeParam;
            String previousDatasetId = geoCodeParam.getPreviousDatasetId();
            CodeRecord preCodeRecord = this.codeRecordService.getCodeRecord(previousDatasetId);
            if (preCodeRecord == null) {
                this.invokeExcuteLog("\u4e0a\u4e00\u671f\u6570\u636e\u672a\u8d4b\u7801", TaskLogLevelEnum.Error);
                executeResult.setSuccess(Boolean.valueOf(false));
                ExecuteResult executeResult2 = executeResult;
                return executeResult2;
            }
            DatasetNameInfo preDatasetInfo = new DatasetNameInfo(previousDatasetId);
            String bizClassCode = preCodeRecord.getBizClassCode();
            Map<String, String> classNameMap = this.codeEntityClassService.getClassNames();
            if (classNameMap.size() == 0) {
                this.invokeExcuteLog("\u672a\u914d\u7f6e\u5b9e\u4f53\u5206\u7c7b", TaskLogLevelEnum.Error);
                executeResult.setSuccess(Boolean.valueOf(false));
                ExecuteResult executeResult3 = executeResult;
                return executeResult3;
            }
            workspace = this.geoDatabaseService.openGeoWorkspace(inputDataParam.getDsKey());
            IFeatureClass dltbTable = workspace.openFeatureClass(inputDataParam.getName());
            if (dltbTable == null) {
                this.invokeExcuteLog(inputDataParam.getName() + "\u6570\u636e\u6253\u5f00\u5931\u8d25", TaskLogLevelEnum.Error);
                executeResult.setSuccess(Boolean.valueOf(false));
                ExecuteResult executeResult4 = executeResult;
                return executeResult4;
            }
            String datasetId = GeoDatasetUtil.getGeoDatasetId((String)inputDataParam.getDsKey(), (IGeoDataset)dltbTable);
            if (dltbTable.getFields().findField(geoCodeParam.getDlmcField()) == null) {
                this.invokeExcuteLog("\u5730\u7c7b\u540d\u79f0\u5b57\u6bb5\u4e0d\u5b58\u5728\uff1a" + geoCodeParam.getDlmcField(), TaskLogLevelEnum.Error);
                executeResult.setSuccess(Boolean.valueOf(false));
                ExecuteResult executeResult5 = executeResult;
                return executeResult5;
            }
            if (!dltbTable.getFields().contains("bsm")) {
                this.invokeExcuteLog("\u5730\u7c7b\u6807\u8bc6\u7801\u5b57\u6bb5\u4e0d\u5b58\u5728\uff1absm", TaskLogLevelEnum.Error);
                executeResult.setSuccess(Boolean.valueOf(false));
                ExecuteResult executeResult6 = executeResult;
                return executeResult6;
            }
            previousWorkspace = this.geoDatabaseService.openGeoWorkspace(preDatasetInfo.getDsKey());
            IFeatureClass previousDltbTable = previousWorkspace.openFeatureClass(preDatasetInfo.getName());
            if (previousDltbTable == null) {
                this.invokeExcuteLog(preDatasetInfo.getName() + "\u4e0a\u4e00\u671f\u6570\u636e\u6253\u5f00\u5931\u8d25", TaskLogLevelEnum.Error);
                executeResult.setSuccess(Boolean.valueOf(false));
                ExecuteResult executeResult7 = executeResult;
                return executeResult7;
            }
            DatasetNameInfo changeDatasetInfo = new DatasetNameInfo(geoCodeParam.getChangeDatasetId());
            changeWorkspace = this.geoDatabaseService.openGeoWorkspace(changeDatasetInfo.getDsKey());
            ITable changeTable = changeWorkspace.openTable(changeDatasetInfo.getName());
            if (changeTable == null) {
                this.invokeExcuteLog(preDatasetInfo.getName() + "\u53d8\u66f4\u4e00\u89c8\u8868\u6570\u636e\u6253\u5f00\u5931\u8d25", TaskLogLevelEnum.Error);
                executeResult.setSuccess(Boolean.valueOf(false));
                ExecuteResult executeResult8 = executeResult;
                return executeResult8;
            }
            ChangeTableContent allChangRecords = this.queryChangeRecords(changeTable);
            graphDriver = this.graphDatabaseManager.getNeo4jDriver(geoCodeParam.getGraphDbKey());
            session = graphDriver.session();
            this.graphDatabaseManager.addGraphIndex(graphDriver, datasetId);
            boolean overwrite = Boolean.TRUE.equals(geoCodeParam.getOverwrite());
            if (overwrite) {
                int delCount = this.geoCodingService.deleteByBizFlag("dltb", datasetId);
                this.invokeExcuteLog("\u5220\u9664\u5b9e\u4f53\u7801" + delCount + "\u4e2a");
                try {
                    Result result = session.run(String.format("Call apoc.periodic.iterate(\"MATCH (n:`%s`) return id(n) as id\", \"MATCH (n) WHERE id(n) = id DETACH DELETE n\", {batchSize:50000}) yield batches, total return batches, total", datasetId));
                    this.log.info(result.next().toString());
                }
                catch (Exception e) {
                    this.invokeExcuteLog("\u5220\u9664\u5b9e\u4f53\u5931\u8d25", e);
                }
            }
            String guid = UUID.randomUUID().toString();
            String csvPath = this.graphDatabaseManager.getTempPath(guid);
            FileUtil.mkdirs((String)csvPath);
            BufferedWriter csvWriter = null;
            int fileIndex = 0;
            int entityCount = 0;
            LinkedHashMap<String, String> nodePropertys = new LinkedHashMap<String, String>();
            BufferedWriter relationCsvWriter = null;
            int relationFileIndex = 0;
            int relationCount = 0;
            LinkedHashMap<String, String> relationPropertys = new LinkedHashMap<String, String>();
            boolean needProject = false;
            ISpatialReferenceSystem spatialReferenceSystem = null;
            if (dltbTable.getSpatialReferenceSystem() != null && dltbTable.getSpatialReferenceSystem().getType() != SpatialReferenceSystemType.Geographic) {
                needProject = true;
                spatialReferenceSystem = SpatialReferenceSystemFunc.createSpatialReference((int)4490);
            }
            ArrayList<String> fields = new ArrayList<String>();
            fields.add(dltbTable.getOidFieldName());
            fields.add(dltbTable.getShapeFieldName());
            fields.add(geoCodeParam.getDlmcField());
            fields.add("bsm");
            fields.add("tbmj");
            if (dltbTable.getFields().contains("dlbm")) {
                fields.add("dlbm");
            }
            if (dltbTable.getFields().contains("tbbh")) {
                fields.add("tbbh");
            }
            int errorLogCount = 0;
            QueryFilter filter = new QueryFilter();
            filter.setSubFields(String.join((CharSequence)",", fields));
            cursor = dltbTable.searchFeature((IQueryFilter)filter);
            IFeature feature = cursor.nextFeature();
            while (feature != null) {
                if (this.isAborted()) {
                    throw new RuntimeException("\u4efb\u52a1\u5df2\u88ab\u4e2d\u6b62");
                }
                try {
                    Map<String, ChangeRow> changeRecords;
                    String nodeId = datasetId + "-" + feature.getObjectId();
                    if (!overwrite && this.graphDatabaseManager.existEntityNode(session, nodeId)) {
                        ++successCount;
                        continue;
                    }
                    String dlmc = this.valueOf((IRow)feature, geoCodeParam.getDlmcField());
                    String dlbm = this.valueOf((IRow)feature, "dlbm");
                    String bsm = this.valueOf((IRow)feature, "bsm");
                    String tbmj = this.valueOf((IRow)feature, "tbmj");
                    String tbbh = this.valueOf((IRow)feature, "tbbh");
                    String code_type = "02";
                    if (StringUtil.isEmpty((String)dlmc)) {
                        this.invokeExcuteLog(feature.getObjectId() + "\u5730\u7c7b\u540d\u79f0\u4e3a\u7a7a", TaskLogLevelEnum.Error, ++errorLogCount);
                        ++failCount;
                        continue;
                    }
                    if (StringUtil.isEmpty((String)bsm)) {
                        this.invokeExcuteLog(feature.getObjectId() + "\u5730\u7c7b\u6807\u8bc6\u7801\u4e3a\u7a7a", TaskLogLevelEnum.Error, ++errorLogCount);
                        ++failCount;
                        continue;
                    }
                    String xzqdm = bsm.substring(0, 6);
                    String entityClass = classNameMap.get(dlmc);
                    if (StringUtil.isEmpty((String)entityClass)) {
                        this.invokeExcuteLog(feature.getObjectId() + "-" + dlmc + " \u672a\u5339\u914d\u5230\u5b9e\u4f53\u5206\u7c7b\u4ee3\u7801", TaskLogLevelEnum.Error, ++errorLogCount);
                        ++failCount;
                        continue;
                    }
                    String entityID = null;
                    if (relationCsvWriter == null) {
                        File csvFile = new File(csvPath, "relation" + ++relationFileIndex + ".csv");
                        csvFile.createNewFile();
                        relationCsvWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(csvFile), StandardCharsets.UTF_8), 1024);
                    }
                    if ((changeRecords = allChangRecords.getByAfterBSM(bsm)) == null || changeRecords.size() == 0) {
                        Node preNode = this.queryNode(session, previousDatasetId, bsm);
                        String string = entityID = preNode == null ? null : preNode.get("stma").asString();
                        if (StringUtil.isEmpty((String)entityID)) {
                            this.invokeExcuteLog(feature.getObjectId() + "-" + bsm + " \u672a\u5339\u914d\u5230\u4e0a\u4e00\u671f\u6807\u8bc6\u7801", TaskLogLevelEnum.Error, ++errorLogCount);
                            ++failCount;
                            continue;
                        }
                        relationPropertys.put("edge_id", IdUtil.getSnowflakeNextIdStr());
                        relationPropertys.put("edge_class", "GUOTUDIAOCHA");
                        relationPropertys.put("edge_name", "\u5e74\u5ea6\u53d8\u66f4");
                        relationPropertys.put("yygx", "ndbg");
                        relationPropertys.put("mj", preNode.get("tbmj").asString());
                        this.graphDatabaseManager.appendEntityRelation(relationCsvWriter, preNode.get("node_id").asString(), nodeId, relationPropertys);
                        ++relationCount;
                    } else {
                        String previousBSM = null;
                        double bgmj = -1.0;
                        for (ChangeRow changeMap : changeRecords.values()) {
                            double mj = changeMap.bgmj;
                            if (!StringUtil.equals((String)changeMap.beforDLBM, (String)changeMap.afterDLBM) || !(mj > bgmj)) continue;
                            bgmj = mj;
                            previousBSM = changeMap.beforBSM;
                        }
                        if (previousBSM != null) {
                            Map<String, ChangeRow> beforeChangeRecords = allChangRecords.getByBeforBSM(previousBSM);
                            String afterBSM = null;
                            double bgmj2 = -1.0;
                            for (ChangeRow changeMap : beforeChangeRecords.values()) {
                                double mj = changeMap.bgmj;
                                if (!StringUtil.equals((String)changeMap.beforDLBM, (String)changeMap.afterDLBM) || !(mj > bgmj2)) continue;
                                bgmj2 = mj;
                                afterBSM = changeMap.afterBSM;
                            }
                            if (!bsm.equals(afterBSM)) {
                                previousBSM = null;
                            }
                        }
                        boolean hasErrorData = false;
                        for (ChangeRow changeRow : changeRecords.values()) {
                            String bgqtbbsm = changeRow.beforBSM;
                            double mj = changeRow.bgmj;
                            Node preNode = this.queryNode(session, previousDatasetId, bgqtbbsm);
                            if (preNode == null) {
                                this.invokeExcuteLog(feature.getObjectId() + "-" + bsm + " \u672a\u5339\u914d\u5230\u4e0a\u4e00\u671f\u53d8\u66f4\u6807\u8bc6\u7801\uff1a" + bgqtbbsm, TaskLogLevelEnum.Error, ++errorLogCount);
                                hasErrorData = true;
                                break;
                            }
                            if (bgqtbbsm.equals(previousBSM)) {
                                entityID = preNode.get("stma").asString();
                            }
                            relationPropertys.put("edge_id", IdUtil.getSnowflakeNextIdStr());
                            relationPropertys.put("edge_class", "GUOTUDIAOCHA");
                            relationPropertys.put("edge_name", "\u5e74\u5ea6\u53d8\u66f4");
                            relationPropertys.put("yygx", "ndbg");
                            relationPropertys.put("mj", decimalFormat.format(mj));
                            this.graphDatabaseManager.appendEntityRelation(relationCsvWriter, preNode.get("node_id").asString(), nodeId, relationPropertys);
                            ++relationCount;
                        }
                        if (hasErrorData) {
                            ++failCount;
                            continue;
                        }
                    }
                    if (relationCount >= 100000) {
                        relationCsvWriter.flush();
                        relationCsvWriter.close();
                        relationCsvWriter = null;
                        relationCount = 0;
                    }
                    if (StringUtil.isEmpty((String)entityID)) {
                        IGeometry geometry = feature.getGeometry();
                        if (geometry == null) {
                            this.invokeExcuteLog(feature.getObjectId() + "\u51e0\u4f55\u4e3a\u7a7a", TaskLogLevelEnum.Error, ++errorLogCount);
                            ++failCount;
                            continue;
                        }
                        if (needProject) {
                            geometry = geometry.projectToCopy(dltbTable.getSpatialReferenceSystem(), spatialReferenceSystem);
                        }
                        double xmin = geometry.getEnvelope().getXMin();
                        double ymin = geometry.getEnvelope().getYMin();
                        double xmax = geometry.getEnvelope().getXMax();
                        double ymax = geometry.getEnvelope().getYMax();
                        entityID = this.geoCodingService.geoCodingEntityCode(xmin, ymin, xmax, ymax, entityClass, 8, 4, null, "dltb", datasetId);
                        code_type = "01";
                    }
                    nodePropertys.put("node_id", nodeId);
                    nodePropertys.put("node_class", "\u81ea\u7136\u8d44\u6e90\u5b9e\u4f53");
                    nodePropertys.put("node_name", dlmc);
                    nodePropertys.put("stma", entityID);
                    nodePropertys.put("stfl", entityClass);
                    nodePropertys.put("year", geoCodeParam.getDataYear());
                    nodePropertys.put("xzqdm", xzqdm);
                    nodePropertys.put("ywlx", bizClassCode);
                    nodePropertys.put("bsm", bsm);
                    nodePropertys.put("dlbm", dlbm);
                    nodePropertys.put("tbmj", tbmj);
                    nodePropertys.put("tbbh", tbbh);
                    nodePropertys.put("code_type", code_type);
                    if (csvWriter == null) {
                        File csvFile = new File(csvPath, "entity" + ++fileIndex + ".csv");
                        csvFile.createNewFile();
                        csvWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(csvFile), StandardCharsets.UTF_8), 1024);
                    }
                    this.graphDatabaseManager.appendEntityNode(csvWriter, nodePropertys);
                    if (++entityCount == 100000) {
                        csvWriter.flush();
                        csvWriter.close();
                        csvWriter = null;
                        entityCount = 0;
                        this.graphDatabaseManager.importEntityNode(graphDriver, datasetId, nodePropertys.keySet(), guid, "entity" + fileIndex);
                    }
                    ++successCount;
                }
                catch (Exception e) {
                    this.invokeExcuteLog(feature.getObjectId() + "\u5904\u7406\u5931\u8d25", e, ++errorLogCount);
                    ++failCount;
                }
                finally {
                    feature = cursor.nextFeature();
                }
            }
            if (csvWriter != null) {
                csvWriter.flush();
                csvWriter.close();
                csvWriter = null;
                this.graphDatabaseManager.importEntityNode(graphDriver, datasetId, nodePropertys.keySet(), guid, "entity" + fileIndex);
            }
            if (relationCsvWriter != null) {
                relationCsvWriter.flush();
                relationCsvWriter.close();
                relationCsvWriter = null;
            }
            if (successCount > 0) {
                CodeRecord codeRecord = new CodeRecord();
                codeRecord.setDatasetId(datasetId);
                codeRecord.setBizClassCode(bizClassCode);
                codeRecord.setDataYear(geoCodeParam.getDataYear());
                codeRecord.setPreviousDatasetId(geoCodeParam.getPreviousDatasetId());
                codeRecord.setPreviousYear(preCodeRecord.getDataYear());
                this.codeRecordService.saveCodeRecord(codeRecord);
            }
            boolean success = failCount == 0;
            try {
                for (int index = 1; index <= relationFileIndex; ++index) {
                    this.graphDatabaseManager.importEntityRelation(graphDriver, "GUOTUDIAOCHA", relationPropertys.keySet(), guid, "relation" + index);
                }
            }
            catch (Exception e) {
                this.invokeExcuteLog("\u5b9e\u4f53\u5173\u7cfb\u5199\u5165\u5931\u8d25\uff1a" + e.getMessage(), e);
                success = false;
            }
            this.invokeExcuteLog(String.format("[%s]\u8d4b\u7801\u5b8c\u6210\uff0c\u6210\u529f%d\u6761\uff0c\u5931\u8d25%d\u6761", inputDataParam.getName(), successCount, failCount));
            executeResult.setSuccess(Boolean.valueOf(success));
        }
        catch (Exception e) {
            this.invokeExcuteLog(String.format("[%s]\u8d4b\u7801\u5931\u8d25", inputDataParam.getName()), e);
            executeResult.setSuccess(Boolean.valueOf(false));
        }
        finally {
            if (cursor != null) {
                cursor.release();
            }
            if (workspace != null) {
                workspace.close();
            }
            if (session != null) {
                session.close();
            }
            if (graphDriver != null) {
                graphDriver.close();
            }
        }
        return executeResult;
    }

    private ChangeTableContent queryChangeRecords(ITable changeTable) {
        ChangeTableContent allChangRecords = new ChangeTableContent();
        ICursor cursor = null;
        try {
            QueryFilter filter = new QueryFilter();
            filter.setSubFields("bgqtbbsm,bgqdlbm,bghtbbsm,bghdlbm,bgmj");
            cursor = changeTable.searchRow((IQueryFilter)filter);
            IRow row = cursor.nextRow();
            while (row != null) {
                String afterBSM = this.valueOf(row.getValue("bghtbbsm"));
                if (afterBSM == null || afterBSM.isEmpty()) {
                    row = cursor.nextRow();
                    continue;
                }
                String beforBSM = this.valueOf(row.getValue("bgqtbbsm"));
                if (beforBSM == null || beforBSM.isEmpty()) {
                    beforBSM = "";
                }
                Map<String, ChangeRow> changeMap = allChangRecords.getByAfterBSM(afterBSM);
                ChangeRow changeRow = null;
                if (changeMap != null) {
                    changeRow = changeMap.get(beforBSM);
                }
                if (changeRow == null) {
                    changeRow = new ChangeRow();
                    changeRow.beforBSM = beforBSM;
                    changeRow.beforDLBM = this.valueOf(row.getValue("bgqdlbm"));
                    changeRow.afterBSM = afterBSM;
                    changeRow.afterDLBM = this.valueOf(row.getValue("bghdlbm"));
                    changeRow.bgmj = this.valueOfDouble(row.getValue("bgmj"));
                    allChangRecords.addRow(changeRow);
                } else {
                    changeRow.bgmj += this.valueOfDouble(row.getValue("bgmj"));
                }
                row = cursor.nextRow();
            }
            ChangeTableContent changeTableContent = allChangRecords;
            return changeTableContent;
        }
        catch (Exception e) {
            throw new RuntimeException("\u53d8\u66f4\u4e00\u89c8\u8868\u8bfb\u53d6\u5931\u8d25\uff1a" + e.getMessage(), e);
        }
        finally {
            if (cursor != null) {
                cursor.release();
            }
        }
    }

    private Node queryNode(Session session, String datasetId, String bsm) {
        String cql = String.format("Match(n:`%s` {%s:'%s'}) return n limit 1", datasetId, "bsm", bsm);
        Result nodeResult = session.run(cql);
        if (nodeResult.hasNext()) {
            Record nodeRecord = nodeResult.next();
            for (Value value : nodeRecord.values()) {
                if (!(value instanceof NodeValue)) continue;
                return value.asNode();
            }
        }
        return null;
    }

    private String valueOf(Object value) {
        return value == null ? null : value.toString();
    }

    private double valueOfDouble(Object value) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble(value.toString());
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public class ChangeRow {
        public String beforBSM;
        public String beforDLBM;
        public String afterBSM;
        public String afterDLBM;
        public double bgmj;
    }

    public class ChangeTableContent {
        private Map<String, Map<String, ChangeRow>> beforeChangeMap = new HashMap<String, Map<String, ChangeRow>>();
        private Map<String, Map<String, ChangeRow>> afterChangeMap = new HashMap<String, Map<String, ChangeRow>>();

        public void addRow(ChangeRow row) {
            Map afterRows = this.afterChangeMap.computeIfAbsent(row.afterBSM, k -> new HashMap());
            afterRows.put(row.beforBSM, row);
            Map beforeRows = this.beforeChangeMap.computeIfAbsent(row.beforBSM, k -> new HashMap());
            beforeRows.put(row.afterBSM, row);
        }

        public Map<String, ChangeRow> getByAfterBSM(String afterBSM) {
            return this.afterChangeMap.get(afterBSM);
        }

        public Map<String, ChangeRow> getByBeforBSM(String beforBSM) {
            return this.beforeChangeMap.get(beforBSM);
        }
    }
}

