/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.tile.image.generator;

import com.geoway.adf.dms.common.web.EnvironmentConfig;
import com.geoway.adf.gis.raster.IRasterDataset;
import com.geoway.adf.gis.raster.RasterFileWorkspace;
import com.geoway.adf.gis.tile.meta.MapExtent;
import com.geoway.dgt.tile.image.document.DxDocument;
import com.geoway.dgt.tile.image.document.DxLayer;
import com.geoway.dgt.tile.image.generator.BaseImageTileGenerator;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import org.gdal.gdal.Band;
import org.gdal.gdal.Dataset;
import org.gdal.gdal.Driver;
import org.gdal.gdal.gdal;
import org.gdal.gdalconst.gdalconstConstants;

public class GDALImageTileGenerator
extends BaseImageTileGenerator {
    private DxDocument document;
    private Integer currentLevel;

    @Override
    public boolean updateTile(int level, MapExtent mapExtent, Consumer<String> msgCallback, Supplier<Boolean> abortedCallback) {
        this.document = this.tileParameter.getMapDocument();
        return super.updateTile(level, mapExtent, msgCallback, abortedCallback);
    }

    @Override
    protected Image createMultiTileImage(MapExtent mapExt, int colCount, int rowCount, int level) {
        this.currentLevel = level;
        String[] anyOption = new String[]{};
        Dataset dsOut = null;
        for (DxLayer layer : this.document.getDxLayers()) {
            Band tarBand;
            String anotherShapeWkt;
            String sourceShapeWkt = this.getMapExtentWkt(layer.getExtent());
            if (!this.isIntersect(sourceShapeWkt, anotherShapeWkt = this.getMapExtentWkt(mapExt))) continue;
            RasterFileWorkspace workspace = new RasterFileWorkspace(layer.getPath());
            IRasterDataset rasterDataset = workspace.openRasterDataset(layer.getPath());
            Dataset dataset = rasterDataset.getRaster();
            Driver drv = gdal.GetDriverByName((String)"MEM");
            dataset = gdal.AutoCreateWarpedVRT((Dataset)dataset, (String)dataset.GetProjection(), (String)this.tileSchema.getSpatialReference().getWkt(), (int)0, (double)0.0);
            if (dsOut == null) {
                dsOut = drv.Create("filememory", colCount * this.tileWidth, rowCount * this.tileHeight, dataset.getRasterCount(), 1, anyOption);
                dsOut.SetProjection(this.tileSchema.getSpatialReference().getWkt());
                double[] gt = new double[6];
                dataset.GetGeoTransform(gt);
                gt[0] = mapExt.getMinX().doubleValue();
                gt[3] = mapExt.getMaxY().doubleValue();
                gt[1] = mapExt.getWidth().doubleValue() / (double)(colCount * this.tileWidth);
                gt[5] = -mapExt.getHeight().doubleValue() / (double)(rowCount * this.tileHeight);
                dsOut.SetGeoTransform(gt);
                for (int index = 1; index <= dataset.getRasterCount(); ++index) {
                    tarBand = dsOut.GetRasterBand(index);
                    tarBand.SetNoDataValue(255.0);
                    double[] defaultValue = new double[tarBand.getXSize() * tarBand.getYSize()];
                    Arrays.fill(defaultValue, 255.0);
                    tarBand.WriteRaster(0, 0, tarBand.getXSize(), tarBand.getYSize(), defaultValue);
                }
            }
            for (int index = 1; index <= dataset.getRasterCount(); ++index) {
                Band band = dataset.GetRasterBand(index);
                tarBand = dsOut.GetRasterBand(index);
                this.readBandRaster(band, tarBand, dataset, dsOut);
            }
        }
        if (dsOut == null) {
            return null;
        }
        Image image = this.datasetPng2File(dsOut);
        dsOut.FlushCache();
        dsOut.delete();
        return image;
    }

    private void readBandRaster(Band srcBand, Band tarBand, Dataset srcDataset, Dataset targetDataset) {
        double tempMinY;
        double tempMaxY;
        double[] tarGeoTransform = new double[6];
        targetDataset.GetGeoTransform(tarGeoTransform);
        double targetMinX = tarGeoTransform[0];
        double targetMaxY = tarGeoTransform[3];
        double targetMaxX = targetMinX + (double)targetDataset.GetRasterXSize() * tarGeoTransform[1];
        double targetMinY = targetMaxY + (double)targetDataset.GetRasterYSize() * tarGeoTransform[5];
        double[] srcGeoTransform = new double[6];
        srcDataset.GetGeoTransform(srcGeoTransform);
        double srcMinX = srcGeoTransform[0];
        double srcMaxY = srcGeoTransform[3];
        double srcMaxX = srcMinX + (double)srcDataset.GetRasterXSize() * srcGeoTransform[1];
        double srcMinY = srcMaxY + (double)srcDataset.GetRasterYSize() * srcGeoTransform[5];
        double tempMinx = Math.max(targetMinX, srcMinX);
        double tempMaxX = Math.min(targetMaxX, srcMaxX);
        if (tarGeoTransform[5] < 0.0) {
            tempMaxY = Math.min(targetMaxY, srcMaxY);
            tempMinY = Math.max(targetMinY, srcMinY);
        } else {
            tempMaxY = Math.max(targetMaxY, srcMaxY);
            tempMinY = Math.min(targetMinY, srcMinY);
        }
        if (tempMinx >= tempMaxX) {
            return;
        }
        if (tarGeoTransform[5] < 0.0 && tempMaxY <= tempMinY) {
            return;
        }
        if (tarGeoTransform[5] > 0.0 && tempMaxY >= tempMinY) {
            return;
        }
        int tarOffsetX = (int)Math.round((tempMinx - tarGeoTransform[0]) / tarGeoTransform[1]);
        int tarOffsetY = (int)Math.round((tempMaxY - tarGeoTransform[3]) / tarGeoTransform[5]);
        int tarXSize = (int)Math.round((tempMaxX - tarGeoTransform[0]) / tarGeoTransform[1]) - tarOffsetX;
        int tarYSize = (int)Math.round((tempMinY - tarGeoTransform[3]) / tarGeoTransform[5]) - tarOffsetY;
        if (tarXSize < 1 || tarYSize < 1) {
            return;
        }
        int srcXOffset = (int)Math.round((tempMinx - srcGeoTransform[0]) / srcGeoTransform[1]);
        int srcYOffset = (int)Math.round((tempMaxY - srcGeoTransform[3]) / srcGeoTransform[5]);
        int srcXSize = (int)Math.round((tempMaxX - srcGeoTransform[0]) / srcGeoTransform[1]) - srcXOffset;
        int srcYSize = (int)Math.round((tempMinY - srcGeoTransform[3]) / srcGeoTransform[5]) - srcYOffset;
        if (srcXSize < 1 || srcYSize < 1) {
            return;
        }
        double[] pixelsTileArr = new double[tarXSize * tarYSize];
        srcBand.ReadRaster(srcXOffset, srcYOffset, srcXSize, srcYSize, tarXSize, tarYSize, 7, pixelsTileArr, 0, 0);
        if (srcBand.getDataType() != 1) {
            this.stretchMinMax(srcBand, pixelsTileArr);
        } else {
            for (int i = 0; i < pixelsTileArr.length; ++i) {
                if (pixelsTileArr[i] != 255.0) continue;
                pixelsTileArr[i] = 254.0;
            }
        }
        tarBand.WriteRaster(tarOffsetX, tarOffsetY, tarXSize, tarYSize, tarXSize, tarYSize, 7, pixelsTileArr, 0, 0);
    }

    private Image datasetPng2File(Dataset ds) {
        Path uploadPath = Paths.get(EnvironmentConfig.getProperty((String)"project.globe-model-config-path", (String)"globemodel"), new String[0]).toAbsolutePath();
        try {
            File folder = uploadPath.toFile();
            if (!folder.exists()) {
                folder.mkdirs();
            }
        }
        catch (Exception e) {
            this.log.error("\u670d\u52a1\u6570\u636e\u52a0\u5de5\u76ee\u5f55\u521b\u5efa\u5931\u8d25", (Throwable)e);
        }
        String tmpFileName = Paths.get(uploadPath.toString(), UUID.randomUUID().toString() + "----" + this.currentLevel + ".png").toString();
        gdal.SetConfigOption((String)"GDAL_PAM_ENABLED", (String)"FALSE");
        Driver drv = gdal.GetDriverByName((String)"PNG");
        String[] aryOption = new String[]{};
        Dataset dsOut = drv.CreateCopy(tmpFileName, ds, 0, aryOption);
        int bandCount = dsOut.getRasterCount();
        dsOut.FlushCache();
        dsOut.delete();
        BufferedImage image = null;
        try {
            int i;
            File tmpFile = new File(tmpFileName);
            BufferedImage tempImage = ImageIO.read(tmpFile);
            image = new BufferedImage(tempImage.getWidth(), tempImage.getHeight(), 2);
            Graphics2D g2d = image.createGraphics();
            image = g2d.getDeviceConfiguration().createCompatibleImage(tempImage.getWidth(), tempImage.getHeight(), 3);
            g2d.dispose();
            g2d = image.createGraphics();
            byte[] sourcePixels = ((DataBufferByte)tempImage.getRaster().getDataBuffer()).getData();
            int[] targetPixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
            if (bandCount == 1) {
                for (i = 0; i < tempImage.getWidth() * tempImage.getHeight(); ++i) {
                    int argb;
                    int b = sourcePixels[i] & 0xFF;
                    boolean transparent = b == 255;
                    int a = transparent ? 0 : 255;
                    targetPixels[i] = argb = a << 24 | b << 16 | b << 8 | b;
                }
            } else {
                for (i = 0; i < tempImage.getWidth() * tempImage.getHeight(); ++i) {
                    int argb;
                    int b = sourcePixels[i * 3] & 0xFF;
                    int g = sourcePixels[i * 3 + 1] & 0xFF;
                    int r = sourcePixels[i * 3 + 2] & 0xFF;
                    boolean transparent = r == 255 && g == 255 && b == 255;
                    int a = transparent ? 0 : 255;
                    targetPixels[i] = argb = a << 24 | r << 16 | g << 8 | b;
                }
            }
            g2d.dispose();
            boolean successDelete = tmpFile.delete();
            if (!successDelete) {
                this.log.error("\u4e34\u65f6\u74e6\u7247" + tmpFileName + "\u5c1d\u8bd5\u5220\u9664\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            this.log.error("\u51fa\u56fe\u5931\u8d25\uff01" + e.getMessage(), (Throwable)e);
            this.msgCallBack.accept("\u51fa\u56fe\u5931\u8d25\uff01" + e.getMessage());
            return null;
        }
        return image;
    }

    private void stretchMinMax(Band srcBand, double[] pixels) {
        srcBand.SetColorInterpretation(gdalconstConstants.GCI_GrayIndex);
        double[] minValueArr = new double[1];
        double[] maxValueArr = new double[1];
        double[] meanArr = new double[1];
        double[] stddevArr = new double[1];
        srcBand.GetStatistics(false, false, minValueArr, maxValueArr, meanArr, stddevArr);
        double minValue = minValueArr[0];
        double maxValue = maxValueArr[0];
        double cF = minValue - maxValue == 0.0 ? 1.0 : 255.0 / (maxValue - minValue);
        Double[] noData = new Double[1];
        srcBand.GetNoDataValue(noData);
        double limMin = 0.0;
        double limMax = 254.0;
        for (int i = 0; i < pixels.length; ++i) {
            pixels[i] = noData[0] != null && noData[0] == pixels[i] ? 255.0 : this.calcMinMax(pixels[i], cF, minValue, limMin, limMax);
        }
    }

    private double calcMinMax(double pixel, double cF, double min, double limMin, double limMax) {
        double vPixel = cF * (pixel - min);
        if (vPixel < limMin) {
            vPixel = limMin;
        } else if (vPixel > limMax) {
            vPixel = limMax;
        }
        return vPixel;
    }
}

