/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.tile.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class BitConverter {
    public static short toInt16(byte[] data) {
        return ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN).getShort();
    }

    public static double toDouble(byte[] data) {
        return ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN).getDouble();
    }

    public static float toSingle(byte[] data) {
        return ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN).getFloat();
    }

    public static byte[] short2bytes(short s) {
        byte[] convert = new byte[2];
        int[] offset = new int[]{0, 8};
        convert[0] = (byte)(s >>> offset[0] & 0xFF);
        convert[1] = (byte)(s >>> offset[1] & 0xFF);
        return convert;
    }

    public static byte[] double2bytes(double d) {
        byte[] convert = new byte[8];
        long dBit = Double.doubleToLongBits(d);
        for (int i = 0; i < 8; ++i) {
            convert[i] = (byte)(dBit >> i * 8 & 0xFFL);
        }
        return convert;
    }

    public static byte[] float2bytes(float f) {
        byte[] convert = new byte[4];
        int fBit = Float.floatToIntBits(f);
        convert[0] = (byte)fBit;
        convert[1] = (byte)(fBit >> 8);
        convert[2] = (byte)(fBit >> 16);
        convert[3] = (byte)(fBit >> 24);
        return convert;
    }
}

