/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.tile.util;

import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.adf.gis.tile.ITileDataset;
import com.geoway.adf.gis.tile.TileMeta;
import com.geoway.adf.gis.tile.TileType;
import com.geoway.adf.gis.tile.meta.TileSchema;
import com.geoway.adf.gis.tile.mongo.MongoTileDataSource;
import com.geoway.dgt.tile.dto.TileStorageInfo;
import com.geoway.dgt.tile.param.TileSliceParam;
import java.util.ArrayList;

public class TileMetaUtil {
    private static final DataSourceService dataSourceService = (DataSourceService)SpringContextUtil.getBean(DataSourceService.class);

    public static void updateTileMeta(TileSchema tileSchema, TileSliceParam tileSliceParam, TileType tileType, String dataFormat) {
        TileMeta tileMeta;
        TileStorageInfo tileStorageInfo = tileSliceParam.getStorageInfo();
        MongoTileDataSource dataSource = null;
        ITileDataset tileReader = null;
        switch (tileStorageInfo.getStorageTypeEnum()) {
            case MongoDB: {
                DataSourceDTO dataSourceDTO = dataSourceService.getDataSourceDetail(tileStorageInfo.getDbKey());
                dataSource = new MongoTileDataSource(dataSourceDTO.getUrl(), dataSourceDTO.getUserName(), dataSourceDTO.getPassword());
                dataSource.connect();
                tileReader = dataSource.getDataset(tileStorageInfo.getDatasetName());
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u5b58\u50a8\u683c\u5f0f\uff01");
            }
        }
        TileMeta tileMeta2 = tileMeta = tileReader == null ? null : tileReader.getTileMeta();
        if (tileMeta == null) {
            tileMeta = new TileMeta();
            tileMeta.setName(tileStorageInfo.getDatasetName());
            tileMeta.setAliasName(tileStorageInfo.getDatasetName());
            tileMeta.setTileSchema(tileSchema);
            tileMeta.setTileType(tileType);
            tileMeta.setDataFormat(dataFormat);
            tileMeta.setStartLevel(tileSliceParam.getFromLevel());
            tileMeta.setEndLevel(tileSliceParam.getToLevel());
            ArrayList<Integer> levelList = new ArrayList<Integer>();
            for (int level = tileSliceParam.getFromLevel().intValue(); level <= tileSliceParam.getToLevel(); ++level) {
                levelList.add(level);
            }
            tileMeta.setLevels(levelList);
            tileMeta.setXmax(Double.valueOf(tileSliceParam.getSliceExtent().getMaxX().doubleValue()));
            tileMeta.setXmin(Double.valueOf(tileSliceParam.getSliceExtent().getMinX().doubleValue()));
            tileMeta.setYmax(Double.valueOf(tileSliceParam.getSliceExtent().getMaxY().doubleValue()));
            tileMeta.setYmin(Double.valueOf(tileSliceParam.getSliceExtent().getMinY().doubleValue()));
            dataSource.createDataset(tileMeta);
        } else {
            tileMeta.setStartLevel(Integer.valueOf(Math.min(tileMeta.getStartLevel(), tileSliceParam.getFromLevel())));
            tileMeta.setEndLevel(Integer.valueOf(Math.max(tileMeta.getEndLevel(), tileSliceParam.getToLevel())));
            ArrayList<Integer> levelList = new ArrayList<Integer>();
            for (int level = tileMeta.getStartLevel().intValue(); level <= tileMeta.getEndLevel(); ++level) {
                levelList.add(level);
            }
            tileMeta.setLevels(levelList);
            tileMeta.setXmax(Double.valueOf(Math.max(tileMeta.getXmax(), tileSliceParam.getSliceExtent().getMaxX().doubleValue())));
            tileMeta.setXmin(Double.valueOf(Math.min(tileMeta.getXmin(), tileSliceParam.getSliceExtent().getMinX().doubleValue())));
            tileMeta.setYmax(Double.valueOf(Math.max(tileMeta.getYmax(), tileSliceParam.getSliceExtent().getMaxY().doubleValue())));
            tileMeta.setYmin(Double.valueOf(Math.min(tileMeta.getYmin(), tileSliceParam.getSliceExtent().getMinY().doubleValue())));
            tileReader.updateTileMeta(tileMeta);
        }
        dataSource.close();
    }
}

