/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.tile.util;

import com.geoway.adf.dms.common.gis.WorkspaceUtil;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.IEnvelope;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.raster.IRasterDataset;
import com.geoway.adf.gis.raster.RasterFileWorkspace;
import com.geoway.adf.gis.tile.meta.MapExtent;
import com.geoway.adf.gis.tile.meta.SpatialReference;
import com.geoway.adf.gis.tile.meta.TileSchema;
import com.geoway.dgt.tile.image.document.DxDocument;
import com.geoway.dgt.tile.image.document.DxLayer;
import java.math.BigDecimal;
import java.util.List;

public class GDALSpatialOperator {
    public static MapExtent project(MapExtent extent, ISpatialReferenceSystem srcSystem, ISpatialReferenceSystem tarSystem) {
        IEnvelope envelope = GeometryFunc.createEnvelope((double)extent.getMinX().doubleValue(), (double)extent.getMinY().doubleValue(), (double)extent.getMaxX().doubleValue(), (double)extent.getMaxY().doubleValue());
        IGeometry geometry = envelope.projectToCopy(srcSystem, tarSystem);
        IEnvelope envelopeCopy = geometry.getEnvelope();
        MapExtent result = new MapExtent();
        result.setMinX(BigDecimal.valueOf(envelopeCopy.getXMin()));
        result.setMaxX(BigDecimal.valueOf(envelopeCopy.getXMax()));
        result.setMinY(BigDecimal.valueOf(envelopeCopy.getYMin()));
        result.setMaxY(BigDecimal.valueOf(envelopeCopy.getYMax()));
        return result;
    }

    public static MapExtent project(MapExtent extent, SpatialReference sourceSpatialReference, SpatialReference targetSpatialReference) {
        String targetWkt = targetSpatialReference.getWkt();
        ISpatialReferenceSystem srcSystem = SpatialReferenceSystemFunc.createSpatialReference((String)sourceSpatialReference.getWkt());
        ISpatialReferenceSystem tarSystem = SpatialReferenceSystemFunc.createSpatialReference((String)targetWkt);
        return GDALSpatialOperator.project(extent, srcSystem, tarSystem);
    }

    public static MapExtent getRasterEnvelope(List<String> rasterPaths, TileSchema tileSchema) {
        MapExtent mapExtent = new MapExtent();
        mapExtent.setMinX(BigDecimal.valueOf(Double.MAX_VALUE));
        mapExtent.setMaxX(BigDecimal.valueOf(Double.MIN_VALUE));
        mapExtent.setMinY(BigDecimal.valueOf(Double.MAX_VALUE));
        mapExtent.setMaxY(BigDecimal.valueOf(Double.MIN_VALUE));
        for (String rasterPath : rasterPaths) {
            RasterFileWorkspace workspace = new RasterFileWorkspace(rasterPath);
            IRasterDataset rasterDataset = workspace.openRasterDataset(rasterPath);
            IEnvelope envelope = rasterDataset.getRasterInfo().getExtent();
            mapExtent.setMinX(BigDecimal.valueOf(Math.min(envelope.getXMin(), mapExtent.getMinX().doubleValue())));
            mapExtent.setMaxX(BigDecimal.valueOf(Math.max(envelope.getXMax(), mapExtent.getMaxX().doubleValue())));
            mapExtent.setMinY(BigDecimal.valueOf(Math.min(envelope.getYMin(), mapExtent.getMinY().doubleValue())));
            mapExtent.setMaxY(BigDecimal.valueOf(Math.max(envelope.getYMax(), mapExtent.getMaxY().doubleValue())));
            ISpatialReferenceSystem tarSystem = SpatialReferenceSystemFunc.createSpatialReference((String)tileSchema.getSpatialReference().getWkt());
            mapExtent = GDALSpatialOperator.project(mapExtent, rasterDataset.getRasterInfo().getSpatialReferenceSystem(), tarSystem);
            rasterDataset.closeRaster();
        }
        return mapExtent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MapExtent getShpMapExtent(String shpPath, TileSchema tileSchema) {
        IGeometry shpGeometry;
        ISpatialReferenceSystem srcSystem;
        try (IFeatureWorkspace srcWorkspace = null;){
            String name = FileUtil.getFileNameWithoutExtension((String)shpPath);
            srcWorkspace = WorkspaceUtil.openLocalFileGeodatabase((String)shpPath);
            IFeatureClass featureClass = srcWorkspace.openFeatureClass(name);
            if (featureClass == null) {
                throw new RuntimeException(name + "\u56fe\u5c42\u6253\u5f00\u5931\u8d25");
            }
            srcSystem = featureClass.getSpatialReferenceSystem();
            IGeometry geometry = null;
            IFeatureCursor cursor = featureClass.searchFeature((IQueryFilter)null);
            IFeature feature = cursor.nextFeature();
            while (feature != null) {
                geometry = geometry == null ? feature.getGeometry() : geometry.union(feature.getGeometry());
                feature = cursor.nextFeature();
            }
            cursor.release();
            shpGeometry = geometry;
        }
        MapExtent mapExtent = new MapExtent();
        ISpatialReferenceSystem tarSystem = SpatialReferenceSystemFunc.createSpatialReference((String)tileSchema.getSpatialReference().getWkt());
        IGeometry geometryCopy = shpGeometry.projectToCopy(srcSystem, tarSystem);
        IEnvelope envelope = geometryCopy.getEnvelope();
        mapExtent.setMinX(BigDecimal.valueOf(envelope.getXMin()));
        mapExtent.setMaxX(BigDecimal.valueOf(envelope.getXMax()));
        mapExtent.setMinY(BigDecimal.valueOf(envelope.getYMin()));
        mapExtent.setMaxY(BigDecimal.valueOf(envelope.getYMax()));
        return mapExtent;
    }

    public static DxDocument createMapDocument(List<String> imagePaths, SpatialReference sr) {
        DxDocument document = new DxDocument();
        MapExtent mapExtent = new MapExtent();
        mapExtent.setMinX(BigDecimal.valueOf(Double.MAX_VALUE));
        mapExtent.setMaxX(BigDecimal.valueOf(Double.MIN_VALUE));
        mapExtent.setMinY(BigDecimal.valueOf(Double.MAX_VALUE));
        mapExtent.setMaxY(BigDecimal.valueOf(Double.MIN_VALUE));
        for (String imagePath : imagePaths) {
            DxLayer dxLayer = new DxLayer();
            dxLayer.setPath(imagePath);
            RasterFileWorkspace workspace = new RasterFileWorkspace(imagePath);
            IRasterDataset rasterDataset = workspace.openRasterDataset(imagePath);
            IEnvelope envelope = rasterDataset.getRasterInfo().getExtent();
            MapExtent dataExtent = new MapExtent();
            dataExtent.setMinX(BigDecimal.valueOf(envelope.getXMin()));
            dataExtent.setMaxX(BigDecimal.valueOf(envelope.getXMax()));
            dataExtent.setMinY(BigDecimal.valueOf(envelope.getYMin()));
            dataExtent.setMaxY(BigDecimal.valueOf(envelope.getYMax()));
            SpatialReference sourceSp = new SpatialReference();
            sourceSp.setWkt(rasterDataset.getRasterInfo().getSpatialReferenceSystem().getWkt());
            dxLayer.setExtent(GDALSpatialOperator.project(dataExtent, sourceSp, sr));
            document.addLayer(dxLayer);
            mapExtent.setMinX(BigDecimal.valueOf(Math.min(dxLayer.getExtent().getMinX().doubleValue(), mapExtent.getMinX().doubleValue())));
            mapExtent.setMaxX(BigDecimal.valueOf(Math.max(dxLayer.getExtent().getMaxX().doubleValue(), mapExtent.getMaxX().doubleValue())));
            mapExtent.setMinY(BigDecimal.valueOf(Math.min(dxLayer.getExtent().getMinY().doubleValue(), mapExtent.getMinY().doubleValue())));
            mapExtent.setMaxY(BigDecimal.valueOf(Math.max(dxLayer.getExtent().getMaxY().doubleValue(), mapExtent.getMaxY().doubleValue())));
        }
        document.setMapExtent(mapExtent);
        return document;
    }
}

