/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.tile.image;

import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.gis.tile.TileType;
import com.geoway.adf.gis.tile.meta.MapExtent;
import com.geoway.adf.gis.tile.meta.TileSchema;
import com.geoway.dgt.frame.constants.TaskLogLevelEnum;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.ToolBase;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.DataStripingResult;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.tile.constant.SliceSchemeEnum;
import com.geoway.dgt.tile.constant.TileTypeEnum;
import com.geoway.dgt.tile.image.ImageSliceParam;
import com.geoway.dgt.tile.image.document.DxDocument;
import com.geoway.dgt.tile.image.generator.GDALImageTileGenerator;
import com.geoway.dgt.tile.util.GDALSpatialOperator;
import com.geoway.dgt.tile.util.TileMetaUtil;
import com.geoway.dgt.tile.util.TileTaskHelper;
import java.util.List;
import java.util.function.Consumer;

public class ImageSliceTool
extends ToolBase {
    public void batchDataStriping(DataParam batchInputData, DataParam batchOutputData, IToolParam toolParam, Consumer<DataStripingResult> oneDataCallback) {
        ImageSliceParam imageSliceParam = (ImageSliceParam)toolParam;
        TileSchema tileSchema = TileSchema.Tianditu;
        SliceSchemeEnum sliceSchemeEnum = SliceSchemeEnum.getByValue(imageSliceParam.getSliceScheme());
        if (sliceSchemeEnum != null) {
            switch (sliceSchemeEnum) {
                case GuoBiao: {
                    tileSchema = TileSchema.Tianditu;
                    break;
                }
                case ArcGIS: {
                    tileSchema = TileSchema.ArcGIS;
                    break;
                }
                case WebMercator: {
                    tileSchema = TileSchema.WebMercator;
                    break;
                }
            }
        }
        if (!StringUtil.isEmptyOrWhiteSpace((String)imageSliceParam.getTileSchemaPath())) {
            tileSchema = new TileSchema();
        }
        DxDocument document = GDALSpatialOperator.createMapDocument(imageSliceParam.getRasterList(), tileSchema.getSpatialReference());
        imageSliceParam.setMapDocument(document);
        switch (imageSliceParam.getTileExtentTypeEnum()) {
            case Full: {
                imageSliceParam.setSliceExtent(document.getMapExtent());
                break;
            }
            case Custom: {
                imageSliceParam.setSliceExtent(GDALSpatialOperator.getShpMapExtent(imageSliceParam.getMaskFilePath(), tileSchema));
                break;
            }
        }
        TileMetaUtil.updateTileMeta(tileSchema, imageSliceParam, TileType.RasterTile, imageSliceParam.getTileFormatEnum().getDesc());
        for (int level = imageSliceParam.getToLevel().intValue(); level >= imageSliceParam.getFromLevel(); --level) {
            List<MapExtent> tileExtents = TileTaskHelper.parseToBundleMultiPartExtent(tileSchema, level, imageSliceParam.getSliceExtent());
            int extentId = 1;
            for (MapExtent updateExtent : tileExtents) {
                DataStripingResult item = new DataStripingResult();
                item.setName(String.format("\u7b2c%d\u7ea7-\u533a\u57df%d", level, extentId));
                item.setPriority(100);
                ImageSliceParam executeParam = new ImageSliceParam();
                executeParam.setMapDocument(document);
                executeParam.setSliceScheme(imageSliceParam.getSliceScheme());
                executeParam.setTileFormat(imageSliceParam.getTileFormatEnum().getValue());
                executeParam.setSliceExtent(updateExtent);
                executeParam.setFromLevel(level);
                executeParam.setToLevel(level);
                executeParam.setStorageInfo(imageSliceParam.getStorageInfo());
                executeParam.setExtentType(imageSliceParam.getExtentType());
                executeParam.setMaskFilePath(imageSliceParam.getMaskFilePath());
                executeParam.setTileSchemaPath(imageSliceParam.getTileSchemaPath());
                executeParam.setRasterList(imageSliceParam.getRasterList());
                executeParam.setSliceType(TileTypeEnum.Update.getValue());
                item.setToolExecuteParam((IToolParam)executeParam);
                oneDataCallback.accept(item);
                ++extentId;
            }
        }
    }

    public ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputDataPath, IToolParam toolParam) {
        ExecuteParam executeParam = new ExecuteParam();
        executeParam.setToolExecuteParam(toolParam);
        return executeParam;
    }

    public ExecuteResult execute(DataParam inputDataParam, DataParam outputDataParam, IToolParam executeParam) {
        ExecuteResult executeResult = new ExecuteResult();
        try {
            ImageSliceParam imageSliceParam = (ImageSliceParam)executeParam;
            GDALImageTileGenerator tileGenerator = new GDALImageTileGenerator();
            tileGenerator.setTileParameter(imageSliceParam);
            boolean success = tileGenerator.updateTile(imageSliceParam.getFromLevel(), imageSliceParam.getSliceExtent(), arg_0 -> ((ImageSliceTool)this).invokeExcuteLog(arg_0), () -> ((ImageSliceTool)this).isAborted());
            if (!success) {
                executeResult.setSuccess(Boolean.valueOf(false));
                executeResult.setErrorMessage("\u5207\u7247\u5931\u8d25");
            }
        }
        catch (Exception e) {
            executeResult.setSuccess(Boolean.valueOf(false));
            executeResult.setErrorMessage(e.getMessage());
            this.log.error(e.getMessage(), (Throwable)e);
            this.invokeExcuteLog(e.getMessage(), TaskLogLevelEnum.Error);
        }
        return executeResult;
    }
}

