/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.tile.util;

import com.geoway.adf.gis.tile.meta.MapExtent;
import com.geoway.adf.gis.tile.meta.TileRange;
import com.geoway.adf.gis.tile.meta.TileSchema;
import com.geoway.adf.gis.tile.meta.TileTransform;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class TileTaskHelper {
    public static List<MapExtent> parseToBundleMultiPartExtent(TileSchema tileSchema, int level, MapExtent totalExtent) {
        TileRange tileRange = TileTransform.worldToTile((MapExtent)totalExtent, (int)level, (TileSchema)tileSchema);
        int startRow = tileRange.getFirstRow();
        int endRow = tileRange.getFirstRow() + tileRange.getRowCount() - 1;
        int startCol = tileRange.getFirstCol();
        int endCol = tileRange.getFirstCol() + tileRange.getColCount() - 1;
        int tilePreCount = TileTaskHelper.getTilePreCount(tileRange);
        int bundleStartCol = startCol / tilePreCount;
        int bundleEndCol = endCol / tilePreCount;
        int bundleStartRow = startRow / tilePreCount;
        int bundleEndRow = endRow / tilePreCount;
        ArrayList<MapExtent> tileExtents = new ArrayList<MapExtent>();
        for (int col = bundleStartCol; col <= bundleEndCol; ++col) {
            for (int row = bundleStartRow; row <= bundleEndRow; ++row) {
                TileRange range = new TileRange(col * tilePreCount, row * tilePreCount, tilePreCount, tilePreCount);
                MapExtent subExtent = TileTransform.tileToWorld((TileRange)range, (int)level, (TileSchema)tileSchema);
                double minX = Math.max(subExtent.getMinX().doubleValue(), totalExtent.getMinX().doubleValue());
                double minY = Math.max(subExtent.getMinY().doubleValue(), totalExtent.getMinY().doubleValue());
                double maxX = Math.min(subExtent.getMaxX().doubleValue(), totalExtent.getMaxX().doubleValue());
                double maxY = Math.min(subExtent.getMaxY().doubleValue(), totalExtent.getMaxY().doubleValue());
                MapExtent rangeExtent = new MapExtent();
                rangeExtent.setMinX(new BigDecimal(minX));
                rangeExtent.setMinY(new BigDecimal(minY));
                rangeExtent.setMaxX(new BigDecimal(maxX));
                rangeExtent.setMaxY(new BigDecimal(maxY));
                if (rangeExtent.getMinX().doubleValue() >= rangeExtent.getMaxX().doubleValue() || rangeExtent.getMinY().doubleValue() >= rangeExtent.getMaxY().doubleValue()) {
                    throw new RuntimeException(String.format("\u7ea7\u522b%d\u7684\u8303\u56f4%s\u5904\u7406\u51fa\u9519\u3002", level, totalExtent.toString()));
                }
                tileExtents.add(rangeExtent);
            }
        }
        return tileExtents;
    }

    public static MapExtent getTileExtent(TileSchema tileSchema, int level, int startRow, int startCol) {
        TileRange tileRange = new TileRange(startCol, startRow, 1, 1);
        return TileTransform.tileToWorld((TileRange)tileRange, (int)level, (TileSchema)tileSchema);
    }

    public static int getTilePreCount(TileRange tileRange) {
        int[] tilePreCountArray = new int[]{1024, 512, 256, 128, 64};
        int tilePreCount = tilePreCountArray[0];
        int threadCount = 4;
        int[] nArray = tilePreCountArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int item;
            tilePreCount = item = nArray[i];
            if ((tileRange.getRowCount() + tileRange.getColCount()) / tilePreCount > threadCount) break;
        }
        return tilePreCount;
    }
}

