/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sample.common.util;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.dji.sample.common.model.CustomClaim;
import com.dji.sample.manage.model.enums.UserTypeEnum;
import com.geoway.tenant.data.LoginUser;
import com.geoway.tenant.thirdapi.UisRestService;
import com.geoway.ue.common.data.response.OpRes;
import com.geoway.ue.common.util.SpringTool;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class JwtUtil {
    private static final Logger log = LoggerFactory.getLogger(JwtUtil.class);
    private static String issuer;
    private static String subject;
    private static long age;
    private static String secret;
    public static Algorithm algorithm;

    @Value(value="${jwt.issuer: DJI}")
    private void setIssuer(String issuer) {
        JwtUtil.issuer = issuer;
    }

    @Value(value="${jwt.subject: CloudApiSample}")
    private void setSubject(String subject) {
        JwtUtil.subject = subject;
    }

    @Value(value="${jwt.age: 86400}")
    private void setAge(long age) {
        JwtUtil.age = age * 1000L;
    }

    @Value(value="${jwt.secret: CloudApiSample}")
    private void setSecret(String secret) {
        JwtUtil.secret = secret;
        this.setAlgorithm();
    }

    private void setAlgorithm() {
        algorithm = Algorithm.HMAC256((String)secret);
    }

    private JwtUtil() {
    }

    public static String createToken(Map<String, ?> claims) {
        return JwtUtil.createToken(claims, (Long)age, (Algorithm)algorithm, (String)subject, (String)issuer);
    }

    public static String createToken(Map<String, ?> claims, Long age, Algorithm algorithm, String subject, String issuer) {
        if (Objects.isNull(algorithm)) {
            throw new IllegalArgumentException();
        }
        Date now = new Date();
        JWTCreator.Builder builder = JWT.create();
        claims.forEach((k, v) -> {
            if (Objects.nonNull(v.getClass().getClassLoader())) {
                log.error("claim can't be set to a custom object.");
                return;
            }
            if (v instanceof Map) {
                builder.withClaim(k, (Map)v);
            } else if (v instanceof List) {
                builder.withClaim(k, (List)v);
            } else {
                builder.withClaim(k, String.valueOf(v));
            }
        });
        if (StringUtils.hasText((String)subject)) {
            builder.withSubject(subject);
        }
        if (StringUtils.hasText((String)issuer)) {
            builder.withIssuer(issuer);
        }
        if (Objects.nonNull(age)) {
            builder.withExpiresAt(new Date(now.getTime() + age));
        }
        String token = builder.withIssuedAt(now).withNotBefore(now).sign(algorithm);
        log.debug("token created. " + token);
        return token;
    }

    public static DecodedJWT verifyToken(String token) {
        return JWT.require((Algorithm)algorithm).build().verify(token);
    }

    public static Optional<CustomClaim> parseToken(String token) {
        UisRestService uisRestService = (UisRestService)SpringTool.getBean(UisRestService.class);
        try {
            OpRes res = uisRestService.getCurrentTenants(token);
            if (res.isOpRes() && res.getData() != null) {
                LoginUser tenant = (LoginUser)res.getData();
                String username = tenant.getUsername();
                return Optional.of(new CustomClaim(username, username, Integer.valueOf(UserTypeEnum.WEB.getVal()), tenant.getCurrentTenantId()));
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38{}{}", (Object)token, (Object)e.getMessage());
        }
        return Optional.empty();
    }
}

