/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sample.component;

import cn.dev33.satoken.stp.SaTokenInfo;
import cn.dev33.satoken.stp.StpUtil;
import cn.hutool.core.util.ObjectUtil;
import com.dji.sample.common.model.CustomClaim;
import com.dji.sample.manage.model.enums.UserTypeEnum;
import com.geoway.tenant.data.MultiTenantProperties;
import com.geoway.tenant.util.TenantUtil;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
@EnableConfigurationProperties(value={MultiTenantProperties.class})
public class AuthInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AuthInterceptor.class);
    public static String PARAM_TOKEN;
    public static String TOKEN_CLAIM;
    @Resource
    private MultiTenantProperties tenantProperties;

    @PostConstruct
    public void init() {
        PARAM_TOKEN = this.tenantProperties.getHeaderTokenKey();
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String tenantId = TenantUtil.getTenantId();
        if (ObjectUtil.isNotEmpty((Object)tenantId)) {
            SaTokenInfo token = StpUtil.getTokenInfo();
            String username = (String)token.getLoginId();
            CustomClaim claim = new CustomClaim(username, username, Integer.valueOf(UserTypeEnum.WEB.getVal()), tenantId);
            request.setAttribute(TOKEN_CLAIM, (Object)claim);
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        request.removeAttribute(TOKEN_CLAIM);
    }

    static {
        TOKEN_CLAIM = "customClaim";
    }
}

