/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sample.manage.controller;

import com.dji.sample.common.model.CustomClaim;
import com.dji.sample.component.AuthInterceptor;
import com.dji.sample.manage.model.dto.WorkspaceDTO;
import com.dji.sample.manage.service.IWorkspaceService;
import com.dji.sdk.common.HttpResultResponse;
import com.geoway.tenant.data.MultiTenantProperties;
import com.geoway.tenant.util.TenantUtil;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"${url.manage.prefix}${url.manage.version}/workspaces"})
public class WorkspaceController {
    @Autowired
    private IWorkspaceService workspaceService;
    @Resource
    private MultiTenantProperties tenantProperties;

    @GetMapping(value={"/current"})
    public HttpResultResponse getCurrentWorkspace(HttpServletRequest request) {
        CustomClaim customClaim = (CustomClaim)request.getAttribute(AuthInterceptor.TOKEN_CLAIM);
        Optional workspaceOpt = this.workspaceService.getWorkspaceByWorkspaceId(customClaim.getWorkspaceId());
        if (workspaceOpt.isEmpty()) {
            return HttpResultResponse.error();
        }
        WorkspaceDTO dto = (WorkspaceDTO)workspaceOpt.get();
        if (this.tenantProperties.getChangeWorkspaceId().booleanValue()) {
            dto.setWorkspaceId(TenantUtil.uuidFmt((String)dto.getWorkspaceId()));
        }
        return HttpResultResponse.success((Object)dto);
    }
}

