/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sample.manage.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.dji.sample.common.error.CommonErrorEnum;
import com.dji.sample.manage.model.dto.DeviceDTO;
import com.dji.sample.manage.model.dto.WorkspaceDTO;
import com.dji.sample.manage.service.IDeviceDictionaryService;
import com.dji.sample.manage.service.IDeviceService;
import com.dji.sample.manage.service.IWorkspaceService;
import com.dji.sdk.cloudapi.device.DeviceDomainEnum;
import com.dji.sdk.cloudapi.device.DeviceEnum;
import com.dji.sdk.cloudapi.organization.AirportBindStatusRequest;
import com.dji.sdk.cloudapi.organization.AirportBindStatusResponse;
import com.dji.sdk.cloudapi.organization.AirportOrganizationBindRequest;
import com.dji.sdk.cloudapi.organization.AirportOrganizationBindResponse;
import com.dji.sdk.cloudapi.organization.AirportOrganizationGetRequest;
import com.dji.sdk.cloudapi.organization.AirportOrganizationGetResponse;
import com.dji.sdk.cloudapi.organization.BindStatusRequestDevice;
import com.dji.sdk.cloudapi.organization.BindStatusResponseDevice;
import com.dji.sdk.cloudapi.organization.OrganizationBindDevice;
import com.dji.sdk.cloudapi.organization.OrganizationBindInfo;
import com.dji.sdk.cloudapi.organization.api.AbstractOrganizationService;
import com.dji.sdk.cloudapi.tsa.DeviceIconUrl;
import com.dji.sdk.cloudapi.tsa.IconUrlEnum;
import com.dji.sdk.common.IErrorInfo;
import com.dji.sdk.mqtt.MqttReply;
import com.dji.sdk.mqtt.requests.TopicRequestsRequest;
import com.dji.sdk.mqtt.requests.TopicRequestsResponse;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.MessageHeaders;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SDKOrganizationService
extends AbstractOrganizationService {
    @Autowired
    private IDeviceService deviceService;
    @Autowired
    private IDeviceDictionaryService dictionaryService;
    @Autowired
    private IWorkspaceService workspaceService;

    public TopicRequestsResponse<MqttReply<AirportBindStatusResponse>> airportBindStatus(TopicRequestsRequest<AirportBindStatusRequest> request, MessageHeaders headers) {
        List data = ((AirportBindStatusRequest)request.getData()).getDevices();
        ArrayList<BindStatusRequestDevice> bindStatusResult = new ArrayList<BindStatusRequestDevice>();
        for (BindStatusResponseDevice bindStatus : data) {
            Optional deviceOpt = this.deviceService.getDeviceBySn(bindStatus.getSn());
            bindStatusResult.add(deviceOpt.isPresent() ? this.dto2BindStatus((DeviceDTO)deviceOpt.get()) : new BindStatusRequestDevice().setSn(bindStatus.getSn()).setDeviceBindOrganization(Boolean.valueOf(false)));
        }
        return new TopicRequestsResponse().setData((Object)MqttReply.success((Object)new AirportBindStatusResponse().setBindStatus(bindStatusResult)));
    }

    public TopicRequestsResponse<MqttReply<AirportOrganizationGetResponse>> airportOrganizationGet(TopicRequestsRequest<AirportOrganizationGetRequest> request, MessageHeaders headers) {
        AirportOrganizationGetRequest organizationGet = (AirportOrganizationGetRequest)request.getData();
        if (!StringUtils.hasText((String)organizationGet.getDeviceBindingCode())) {
            return new TopicRequestsResponse().setData((Object)MqttReply.error((IErrorInfo)CommonErrorEnum.ILLEGAL_ARGUMENT));
        }
        Optional workspace = this.workspaceService.getWorkspaceNameByBindCode(organizationGet.getDeviceBindingCode());
        if (workspace.isEmpty()) {
            return new TopicRequestsResponse().setData((Object)MqttReply.error((IErrorInfo)CommonErrorEnum.GET_ORGANIZATION_FAILED));
        }
        return new TopicRequestsResponse().setData((Object)MqttReply.success((Object)new AirportOrganizationGetResponse().setOrganizationName(((WorkspaceDTO)workspace.get()).getWorkspaceName())));
    }

    public TopicRequestsResponse<MqttReply<AirportOrganizationBindResponse>> airportOrganizationBind(TopicRequestsRequest<AirportOrganizationBindRequest> request, MessageHeaders headers) {
        Optional deviceOpt;
        List devices = ((AirportOrganizationBindRequest)request.getData()).getBindDevices();
        OrganizationBindDevice dock = null;
        OrganizationBindDevice drone = null;
        for (OrganizationBindDevice device : devices) {
            DeviceDomainEnum val = device.getDeviceModelKey().getDomain();
            if (val == DeviceDomainEnum.DOCK) {
                dock = device;
            }
            if (val != DeviceDomainEnum.DRONE) continue;
            drone = device;
        }
        if (dock != null && ObjectUtil.isNotEmpty((Object)dock.getSn()) && (deviceOpt = this.deviceService.getDeviceBySn(dock.getSn())).isPresent() && ObjectUtil.notEqual((Object)((DeviceDTO)deviceOpt.get()).getWorkspaceId(), (Object)dock.getOrganizationId())) {
            return new TopicRequestsResponse().setData((Object)MqttReply.success((Object)new AirportOrganizationBindResponse().setErrInfos(Collections.singletonList(new OrganizationBindInfo(dock.getSn(), CommonErrorEnum.NON_REPEATABLE_BINDING.getCode())))));
        }
        Optional dockOpt = this.bindDevice2Dto(dock);
        Optional droneOpt = this.bindDevice2Dto(drone);
        ArrayList<OrganizationBindInfo> bindResult = new ArrayList<OrganizationBindInfo>();
        droneOpt.ifPresent(droneDto -> {
            ((DeviceDTO)dockOpt.get()).setChildDeviceSn(droneDto.getDeviceSn());
            boolean success = this.deviceService.saveOrUpdateDevice(droneDto);
            bindResult.add(success ? OrganizationBindInfo.success((String)droneDto.getDeviceSn()) : new OrganizationBindInfo(droneDto.getDeviceSn(), CommonErrorEnum.DEVICE_BINDING_FAILED.getCode()));
        });
        boolean success = this.deviceService.saveOrUpdateDevice((DeviceDTO)dockOpt.get());
        bindResult.add(success ? OrganizationBindInfo.success((String)dock.getSn()) : new OrganizationBindInfo(dock.getSn(), CommonErrorEnum.DEVICE_BINDING_FAILED.getCode()));
        return new TopicRequestsResponse().setData((Object)MqttReply.success((Object)new AirportOrganizationBindResponse().setErrInfos(bindResult)));
    }

    public Optional<DeviceDTO> bindDevice2Dto(OrganizationBindDevice receiver) {
        if (receiver == null) {
            return Optional.empty();
        }
        DeviceEnum deviceModelKey = receiver.getDeviceModelKey();
        Optional dictionaryOpt = this.dictionaryService.getOneDictionaryInfoByTypeSubType(Integer.valueOf(deviceModelKey.getDomain().getDomain()), Integer.valueOf(deviceModelKey.getType().getType()), Integer.valueOf(deviceModelKey.getSubType().getSubType()));
        DeviceDTO.DeviceDTOBuilder builder = DeviceDTO.builder();
        dictionaryOpt.ifPresent(entity -> builder.deviceName(entity.getDeviceName()).nickname(entity.getDeviceName()).deviceDesc(entity.getDeviceDesc()));
        Optional workspace = this.workspaceService.getWorkspaceNameByBindCode(receiver.getDeviceBindingCode());
        DeviceDTO dto = builder.workspaceId(workspace.map(WorkspaceDTO::getWorkspaceId).orElse(receiver.getOrganizationId())).domain(deviceModelKey.getDomain()).type(deviceModelKey.getType()).subType(deviceModelKey.getSubType()).deviceSn(receiver.getSn()).boundStatus(Boolean.valueOf(true)).loginTime(LocalDateTime.now()).boundTime(LocalDateTime.now()).iconUrl(new DeviceIconUrl().setSelectIconUrl(IconUrlEnum.SELECT_EQUIPMENT.getUrl()).setNormalIconUrl(IconUrlEnum.NORMAL_EQUIPMENT.getUrl())).build();
        if (StringUtils.hasText((String)receiver.getDeviceCallsign())) {
            dto.setNickname(receiver.getDeviceCallsign());
        } else {
            Optional deviceOpt = this.deviceService.getDeviceBySn(receiver.getSn());
            dto.setNickname(deviceOpt.map(DeviceDTO::getNickname).orElse(dto.getNickname()));
        }
        return Optional.of(dto);
    }

    private BindStatusRequestDevice dto2BindStatus(DeviceDTO device) {
        if (device == null) {
            return null;
        }
        return new BindStatusRequestDevice().setSn(device.getDeviceSn()).setDeviceCallsign(device.getNickname()).setDeviceBindOrganization(device.getBoundStatus()).setOrganizationId(device.getWorkspaceId()).setOrganizationName(device.getWorkspaceName());
    }
}

