/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dji.tenant.config;

import com.geoway.tenant.data.MultiTenantProperties;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.security.SecurityScheme;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.GroupedOpenApi;
import org.springdoc.core.SpringDocConfigProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@OpenAPIDefinition(security={@SecurityRequirement(name="default")})
public class DjiSwaggerConfig {
    private static final Logger log = LoggerFactory.getLogger(DjiSwaggerConfig.class);
    private static final String VERSION = "1.0";
    private static final String TITLE = "dji-tenant-api";
    private static final String GROUP = "dji-tenant-api";
    private static final String NAME = "liaoyongxiang";
    public static final String PKG = "com.dji";
    public static final String DJI_TENANT_PKG = "com.geoway.dji";
    public static final String PKG_DAO = "com.dji.sample.*.dao";
    private static final String URL = "http://geoway.com.cn/";
    private static final String DESCRIPTION = "\u4e0a\u4e91API SAAS\u670d\u52a1\u63a5\u53e3";
    private static final String EMAIL = "liaoyongxiang@geoway.com.cn";
    @Resource
    private MultiTenantProperties tenantProperties;

    @Bean
    public OpenAPI openAPI() {
        return new OpenAPI().info(new Info().title("dji-tenant-api").description(DESCRIPTION).version(VERSION)).components(this.components());
    }

    @Bean
    public SecurityScheme securityScheme() {
        return new SecurityScheme().type(SecurityScheme.Type.APIKEY).in(SecurityScheme.In.HEADER).name(this.tenantProperties.getHeaderTokenKey());
    }

    @Bean
    public Components components() {
        return new Components().addSecuritySchemes("default", this.securityScheme());
    }

    @Bean
    public GroupedOpenApi sdkOpenApi() {
        return GroupedOpenApi.builder().group("dji-tenant-api").packagesToScan(new String[]{PKG, DJI_TENANT_PKG}).build();
    }

    @Bean
    public SpringDocConfigProperties springDocConfigProperties(SpringDocConfigProperties properties) {
        properties.setDefaultFlatParamObject(false);
        properties.setDefaultSupportFormData(true);
        properties.setDefaultProducesMediaType("application/json");
        return properties;
    }
}

