/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dji.tenant.controller;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import com.dji.sample.component.websocket.service.IWebSocketManageService;
import com.dji.sample.component.websocket.service.IWebSocketMessageService;
import com.geoway.dji.tenant.hander.DjiTenantService;
import com.geoway.tenant.data.TenantUserPWd;
import com.geoway.ue.common.data.response.BaseResponse;
import com.geoway.ue.common.data.response.ObjectResponse;
import com.geoway.ue.common.data.response.OpRes;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u79df\u6237\u7ba1\u7406\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/api/tenant/v1"})
public class TenantController {
    @Resource
    private DjiTenantService tenantService;
    @Resource
    private IWebSocketManageService websocketService;
    @Resource
    private IWebSocketMessageService wsMessageService;

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u79df\u6237")
    @ApiOperationSupport(order=1)
    @GetMapping(value={"/current"})
    public ResponseEntity<BaseResponse> getTenant() {
        TenantUserPWd data = this.tenantService.getTenantInfo();
        return ObjectResponse.ok((Object)data);
    }

    @ApiOperation(value="\u83b7\u53d6\u79df\u6237\u5217\u8868")
    @ApiOperationSupport(order=2)
    @GetMapping(value={"/list"})
    public ResponseEntity<BaseResponse> getCurrentTenants() {
        OpRes data = this.tenantService.getCurrentTenants();
        return data.isOpRes() ? ObjectResponse.ok((Object)data) : BaseResponse.error((String)data.getErrorDesc());
    }

    @ApiOperation(value="\u5207\u6362\u5e94\u7528\u79df\u6237")
    @ApiImplicitParam(name="tenantId", value="\u79df\u6237\u6807\u8bc6", paramType="query", required=true)
    @ApiOperationSupport(order=3)
    @PostMapping(value={"/switch"})
    public ResponseEntity<BaseResponse> switchTenant(@RequestParam(value="tenantId") String tenantId) {
        boolean flag = this.tenantService.switchTenant(tenantId);
        return flag ? BaseResponse.ok() : BaseResponse.error((String)"\u5207\u6362\u5e94\u7528\u79df\u6237\u5931\u8d25");
    }

    @ApiIgnore
    @ApiOperation(value="\u83b7\u53d6WS\u4fe1\u606f")
    @ApiImplicitParam(name="workspaceId", value="\u79df\u6237\u6807\u8bc6", paramType="query", required=true)
    @ApiOperationSupport(order=4)
    @GetMapping(value={"/websocket"})
    public ResponseEntity<BaseResponse> obtainWs(String workspaceId, Integer userType) {
        Collection data = null;
        if (ObjectUtil.isNotEmpty((Object)workspaceId)) {
            data = this.websocketService.getValueWithWorkspace(workspaceId);
        } else if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{workspaceId, userType})) {
            data = this.websocketService.getValueWithWorkspaceAndUserType(workspaceId, userType);
        }
        if (data != null) {
            ArrayList list = new ArrayList();
            data.forEach(item -> {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", item.getId());
                map.put("open", item.isOpen());
                if (item.getPrincipal() != null) {
                    map.put("name", item.getPrincipal().getName());
                }
                list.add(map);
            });
            return ObjectResponse.ok(list);
        }
        return BaseResponse.error((String)"\u83b7\u53d6WS\u4fe1\u606f\u5931\u8d25");
    }

    @ApiIgnore
    @ApiOperation(value="\u53d1\u9001WS\u4fe1\u606f")
    @ApiOperationSupport(order=5)
    @PostMapping(value={"/websocket"})
    public ResponseEntity<BaseResponse> sendWs(String workspaceId, Integer userType, String message) {
        this.wsMessageService.sendBatch(workspaceId, userType, IdUtil.fastSimpleUUID(), (Object)message);
        return BaseResponse.ok();
    }

    @ApiOperation(value="\u8f6c\u53d1UIS\u8bf7\u6c42")
    @ApiOperationSupport(order=6)
    @RequestMapping(value={"/uis3/**"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseEntity<BaseResponse> forwardTenant(HttpServletRequest request, @RequestParam(required=false) Map<String, Object> params, @RequestBody(required=false) Map<String, Object> body) {
        Object data = this.tenantService.forwardTenant(request, params, body);
        return ObjectResponse.ok((Object)data);
    }
}

