/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dji.tenant.controller;

import cn.hutool.core.util.ObjectUtil;
import com.dji.sample.manage.model.dto.WorkspaceDTO;
import com.dji.sample.manage.service.IWorkspaceService;
import com.dji.sdk.common.HttpResultResponse;
import com.geoway.dji.tenant.data.RegistryDto;
import com.geoway.dji.tenant.hander.TenantDeviceService;
import com.geoway.tenant.data.MultiTenantProperties;
import com.geoway.tenant.util.TenantUtil;
import com.geoway.ue.common.data.response.OpRes;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8bbe\u5907\u7ba1\u7406\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/api/devices/v1"})
public class TenantDeviceController {
    @Resource
    private TenantDeviceService deviceService;
    @Resource
    private IWorkspaceService workspaceService;
    @Resource
    private MultiTenantProperties tenantProperties;

    @ApiOperation(value="\u65b0\u589e\u8bbe\u5907\u4fe1\u606f")
    @ApiOperationSupport(order=1)
    @PutMapping(value={"/{workspaceId}/{deviceSn}"})
    public HttpResultResponse saveDevice(@PathVariable(value="workspaceId") String workspaceId, @PathVariable(value="deviceSn") String deviceSn, @RequestBody RegistryDto param) {
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{workspaceId, deviceSn})) {
            param.setDeviceSn(deviceSn);
            param.setWorkspaceId(workspaceId);
            OpRes data = this.deviceService.saveDevice(param);
            return !data.isOpRes() ? HttpResultResponse.error((String)data.getErrorDesc()) : HttpResultResponse.success();
        }
        return HttpResultResponse.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @ApiOperation(value="\u65b0\u589e\u8bbe\u5907\u4fe1\u606f")
    @ApiOperationSupport(order=1)
    @PostMapping(value={"/{workspaceId}/{deviceSn}/put"})
    public HttpResultResponse saveDevice2(@PathVariable(value="workspaceId") String workspaceId, @PathVariable(value="deviceSn") String deviceSn, @RequestBody RegistryDto param) {
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{workspaceId, deviceSn})) {
            param.setDeviceSn(deviceSn);
            param.setWorkspaceId(workspaceId);
            OpRes data = this.deviceService.saveDevice(param);
            return !data.isOpRes() ? HttpResultResponse.error((String)data.getErrorDesc()) : HttpResultResponse.success();
        }
        return HttpResultResponse.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @ApiOperation(value="\u79fb\u9664\u8bbe\u5907\u4fe1\u606f", hidden=true)
    @ApiOperationSupport(order=2)
    @DeleteMapping(value={"/{deviceSn}"})
    public HttpResultResponse removeDevice(@PathVariable(value="deviceSn") String deviceSn) {
        if (ObjectUtil.isNotEmpty((Object)deviceSn)) {
            boolean data = this.deviceService.removeDevice(deviceSn);
            return data ? HttpResultResponse.success() : HttpResultResponse.error((String)"\u79fb\u9664\u8bbe\u5907\u4fe1\u606f\u5931\u8d25");
        }
        return HttpResultResponse.error((String)"\u8bbe\u5907SN\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @ApiOperation(value="\u79fb\u9664\u8bbe\u5907\u4fe1\u606f", hidden=true)
    @ApiOperationSupport(order=2)
    @PostMapping(value={"/{deviceSn}/delete"})
    public HttpResultResponse removeDevice2(@PathVariable(value="deviceSn") String deviceSn) {
        if (ObjectUtil.isNotEmpty((Object)deviceSn)) {
            boolean data = this.deviceService.removeDevice(deviceSn);
            return data ? HttpResultResponse.success() : HttpResultResponse.error((String)"\u79fb\u9664\u8bbe\u5907\u4fe1\u606f\u5931\u8d25");
        }
        return HttpResultResponse.error((String)"\u8bbe\u5907SN\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @ApiOperation(value="\u79df\u6237\u63a5\u5165\u4fe1\u606f")
    @ApiOperationSupport(order=3)
    @GetMapping(value={"/{workspaceId}/access"})
    public HttpResultResponse accessTenant(@PathVariable String workspaceId) {
        if (ObjectUtil.isNotEmpty((Object)workspaceId)) {
            Object data = this.deviceService.accessTenant(workspaceId);
            if (data == null) {
                return HttpResultResponse.error((String)"\u79df\u6237\u63a5\u5165\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
            }
            return HttpResultResponse.success((Object)data);
        }
        return HttpResultResponse.error((String)"workspaceId\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @ApiOperation(value="\u8bbe\u5907\u63a5\u5165\u4fe1\u606f")
    @ApiOperationSupport(order=4)
    @GetMapping(value={"/tenant/{gatewaySn}"})
    public HttpResultResponse accessDevice(@PathVariable String gatewaySn, @RequestParam(name="device_sn", required=false) String deviceSn) {
        if (ObjectUtil.isNotEmpty((Object)gatewaySn)) {
            String data = this.deviceService.accessDevice(gatewaySn, deviceSn);
            if (data == null) {
                return HttpResultResponse.success();
            }
            Optional workspaceOpt = this.workspaceService.getWorkspaceByWorkspaceId(data);
            if (workspaceOpt.isEmpty()) {
                return HttpResultResponse.error((String)"\u8bbe\u5907\u63a5\u5165\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
            }
            WorkspaceDTO dto = (WorkspaceDTO)workspaceOpt.get();
            if (this.tenantProperties.getChangeWorkspaceId().booleanValue()) {
                dto.setWorkspaceId(TenantUtil.uuidFmt((String)dto.getWorkspaceId()));
            }
            return HttpResultResponse.success((Object)dto);
        }
        return HttpResultResponse.error((String)"gatewaySn\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @ApiOperation(value="\u8bbe\u5907\u5207\u6362\u79df\u6237")
    @ApiOperationSupport(order=5)
    @PostMapping(value={"/switch/{gatewaySn}"})
    public HttpResultResponse switchTenant(@PathVariable String gatewaySn, @RequestParam(name="workspace_id") String workspaceId, @RequestParam(name="device_sn") String deviceSn) {
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{workspaceId, gatewaySn, deviceSn})) {
            boolean flag;
            if (this.tenantProperties.getChangeWorkspaceId().booleanValue()) {
                workspaceId = workspaceId.replaceAll("-", "");
            }
            return (flag = this.deviceService.switchTenant(gatewaySn, deviceSn, workspaceId)) ? HttpResultResponse.success() : HttpResultResponse.error((String)"\u8bbe\u5907\u5207\u6362\u79df\u6237\u5931\u8d25");
        }
        return HttpResultResponse.error((String)"workspaceId/gatewaySn/deviceSn\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @ApiOperation(value="\u8bbe\u5907\u5b57\u5178\u4fe1\u606f")
    @ApiOperationSupport(order=6)
    @GetMapping(value={"/dictionary"})
    public HttpResultResponse deviceDict() {
        Object data = this.deviceService.getDeviceDict();
        return HttpResultResponse.success((Object)data);
    }
}

