/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dji.tenant.hander;

import com.geoway.dji.tenant.enmus.ScheduleJob;
import com.geoway.dji.tenant.schedule.AbstractJobTenantHandler;
import com.geoway.tenant.util.TenantUtil;
import com.geoway.ue.common.util.SpringTool;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Order(value=3)
@Component
public class ScheduleTenantIdHandler {
    private static final Logger log = LoggerFactory.getLogger(ScheduleTenantIdHandler.class);

    @Pointcut(value="@annotation(org.springframework.scheduling.annotation.Scheduled)")
    public void scheduleTenantIdAspect() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="scheduleTenantIdAspect()")
    public void aroundJobAspect(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        ScheduleJob job = ScheduleJob.findHandlerByMethod((String)method.getName());
        AbstractJobTenantHandler handler = (AbstractJobTenantHandler)SpringTool.getBean((Class)job.getHandler());
        String tenantId = handler.doGetTenant();
        TenantUtil.setTenantId((String)tenantId);
        try {
            handler.doHandleJob(joinPoint, method.getName());
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u5b9a\u65f6\u4efb\u52a1\u5f02\u5e38,\u5f53\u524d\u79df\u6237{}", (Object)tenantId, (Object)e);
        }
        finally {
            log.debug("\u4efb\u52a1{}\u6267\u884c\u5b8c\u6210", (Object)method.getName());
            TenantUtil.setTenantId(null);
        }
    }
}

