/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dji.tenant.hander;

import cn.dev33.satoken.stp.StpUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.dji.sample.manage.dao.IDeviceDictionaryMapper;
import com.dji.sample.manage.dao.IDeviceMapper;
import com.dji.sample.manage.model.dto.DeviceDTO;
import com.dji.sample.manage.model.dto.DeviceDictionaryDTO;
import com.dji.sample.manage.model.dto.WorkspaceDTO;
import com.dji.sample.manage.model.entity.DeviceEntity;
import com.dji.sample.manage.service.IDeviceDictionaryService;
import com.dji.sample.manage.service.IDeviceService;
import com.dji.sample.manage.service.IWorkspaceService;
import com.dji.sdk.cloudapi.device.DeviceDomainEnum;
import com.dji.sdk.cloudapi.device.DeviceSubTypeEnum;
import com.dji.sdk.cloudapi.device.DeviceTypeEnum;
import com.geoway.dji.tenant.data.RegistryDto;
import com.geoway.tenant.handler.TenantRedisHander;
import com.geoway.tenant.util.TenantUtil;
import com.geoway.ue.common.data.response.OpRes;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.Resource;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.springframework.stereotype.Service;

@Service
public class TenantDeviceService {
    @Resource
    private IDeviceMapper deviceMapper;
    @Resource
    private IDeviceDictionaryMapper dictionaryMapper;
    @Resource
    private IDeviceService deviceService;
    @Resource
    private TenantRedisHander redisHander;
    @Resource
    private IWorkspaceService workspaceService;
    @Resource
    private MqttConnectOptions mqttConnectOptions;
    @Resource
    private IDeviceDictionaryService dictionaryService;

    public OpRes<DeviceDTO> saveDevice(RegistryDto data) {
        boolean flag;
        if (this.redisHander.checkExist("tenant_device:" + data.getDeviceSn())) {
            return new OpRes("\u8bbe\u5907\u4fe1\u606f\u5df2\u5b58\u5728\uff0c\u8bf7\u5148\u89e3\u7ed1", null, false);
        }
        DeviceTypeEnum deviceType = DeviceTypeEnum.find((int)data.getDeviceType());
        Optional dict = this.dictionaryService.getOneDictionaryInfoByTypeSubType(data.getDomain(), data.getDeviceType(), data.getSubType());
        if (dict.isEmpty()) {
            return new OpRes("\u8bbe\u5907\u7c7b\u578b\u672a\u77e5", null, false);
        }
        DeviceDTO deviceDTO = DeviceDTO.builder().flyStatus(Boolean.valueOf(false)).boundStatus(Boolean.valueOf(true)).type(deviceType).nickname(deviceType.name()).deviceSn(data.getDeviceSn()).deviceName(((DeviceDictionaryDTO)dict.get()).getDeviceName()).subType(DeviceSubTypeEnum.find((int)data.getSubType())).domain(DeviceDomainEnum.DOCK).boundTime(LocalDateTime.now()).workspaceId(data.getWorkspaceId()).build();
        boolean bl = flag = this.deviceService.saveDevice(deviceDTO) > 0;
        if (flag) {
            this.redisHander.set("tenant_device:" + data.getDeviceSn(), data.getWorkspaceId());
            return new OpRes(null, (Object)deviceDTO, true);
        }
        return new OpRes("\u4fdd\u5b58\u8bbe\u5907\u4fe1\u606f\u5931\u8d25", null, false);
    }

    public boolean removeDevice(String deviceSn) {
        this.deviceService.unbindDevice(deviceSn);
        this.deviceMapper.delete((Wrapper)new LambdaUpdateWrapper().eq(DeviceEntity::getDeviceSn, (Object)deviceSn));
        this.redisHander.del("tenant_device:" + deviceSn);
        this.redisHander.del("online:" + deviceSn);
        return true;
    }

    public Object accessTenant(String workspaceId) {
        Optional data = this.workspaceService.getWorkspaceByWorkspaceId(workspaceId);
        if (data.isPresent()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("serverUrl", this.mqttConnectOptions.getServerURIs());
            map.put("username", this.mqttConnectOptions.getUserName());
            map.put("password", this.mqttConnectOptions.getPassword());
            map.put("bindCode", ((WorkspaceDTO)data.get()).getBindCode());
            map.put("orgId", "W");
            return map;
        }
        return null;
    }

    public Object getDeviceDict() {
        return this.dictionaryMapper.selectMaps(null);
    }

    public String accessDevice(String gatewaySn, String deviceSn) {
        String deviceId;
        String gatewayId = this.redisHander.get("tenant_device:" + gatewaySn);
        if (ObjectUtil.notEqual((Object)gatewayId, (Object)(deviceId = this.redisHander.get("tenant_device:" + deviceSn)))) {
            if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{deviceId, deviceSn})) {
                TenantUtil.setTenantId((String)deviceId);
                this.deviceService.unbindDevice(deviceSn);
            }
            if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{gatewayId, deviceSn})) {
                this.redisHander.set("tenant_device:" + deviceSn, gatewayId);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)gatewayId)) {
            this.redisHander.setWithExpire("token:" + StpUtil.getTokenValue(), gatewayId, StpUtil.getTokenTimeout());
        }
        return gatewayId;
    }

    public boolean switchTenant(String gatewaySn, String deviceSn, String workspaceId) {
        String tenantId = this.accessDevice(gatewaySn, deviceSn);
        if (ObjectUtil.notEqual((Object)workspaceId, (Object)tenantId)) {
            if (ObjectUtil.isNotEmpty((Object)tenantId)) {
                TenantUtil.setTenantId((String)tenantId);
                Optional gateway = this.deviceService.getDeviceBySn(gatewaySn);
                Optional device = this.deviceService.getDeviceBySn(deviceSn);
                if (gateway.isPresent() && ObjectUtil.isNotEmpty((Object)((DeviceDTO)gateway.get()).getWorkspaceId())) {
                    this.deviceService.unbindDevice(gatewaySn);
                }
                if (device.isPresent() && ObjectUtil.isNotEmpty((Object)((DeviceDTO)device.get()).getWorkspaceId())) {
                    this.deviceService.unbindDevice(deviceSn);
                }
            }
            if (ObjectUtil.isNotEmpty((Object)workspaceId)) {
                this.redisHander.set("tenant_device:" + gatewaySn, workspaceId);
                this.redisHander.set("tenant_device:" + deviceSn, workspaceId);
            }
            this.redisHander.setWithExpire("token:" + StpUtil.getTokenValue(), workspaceId, StpUtil.getTokenTimeout());
        }
        return true;
    }
}

