/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dji.tenant.schedule;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.dji.sample.component.redis.RedisOpsUtils;
import com.dji.sample.enhance.model.data.EnhanceProperties;
import com.dji.sample.enhance.service.IAddJobService;
import com.dji.sample.manage.service.IDeviceRedisService;
import com.dji.sdk.cloudapi.device.OsdDock;
import com.geoway.dji.tenant.schedule.AbstractJobTenantHandler;
import com.geoway.tenant.util.TenantUtil;
import java.util.Optional;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class LowPowerJobListenJob
extends AbstractJobTenantHandler {
    private static final Logger log = LoggerFactory.getLogger(LowPowerJobListenJob.class);
    @Resource
    private IDeviceRedisService deviceRedisService;
    @Resource
    private EnhanceProperties enhanceProperties;
    @Resource
    private IAddJobService addJobService;

    public void doHandleJob(ProceedingJoinPoint point, String method) throws Throwable {
        RedisOpsUtils.getAllKeys((String)"wayline_job_low_power:*").forEach(key -> {
            JSONObject json;
            Object breakpoint = RedisOpsUtils.get((String)key);
            if (ObjectUtil.isNotEmpty((Object)breakpoint) && (json = JSONUtil.parseObj((Object)breakpoint)).containsKey((Object)"workspace_id")) {
                Optional osd;
                TenantUtil.setTenantId((String)json.getStr((Object)"workspace_id"));
                if (json.containsKey((Object)"device_sn") && (osd = this.deviceRedisService.getDeviceOsd(json.getStr((Object)"device_sn"), OsdDock.class)).isPresent() && ((OsdDock)osd.get()).getDroneChargeState().getCapacityPercent() > this.enhanceProperties.getLowPowerContinueCapacity()) {
                    this.addJobService.continueLowPowerTask(json);
                }
            }
        });
    }
}

