/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dji.tenant.schedule;

import com.dji.sample.component.redis.RedisOpsUtils;
import com.dji.sample.enhance.model.dto.YxChannelInfo;
import com.dji.sample.manage.model.dto.DeviceDTO;
import com.dji.sample.manage.service.ILiveStreamService;
import com.geoway.dji.tenant.schedule.AbstractJobTenantHandler;
import com.geoway.tenant.util.TenantUtil;
import java.util.Optional;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class StreamStatusListenJob
extends AbstractJobTenantHandler {
    private static final Logger log = LoggerFactory.getLogger(StreamStatusListenJob.class);
    @Resource
    private ILiveStreamService liveStreamService;

    public void doHandleJob(ProceedingJoinPoint point, String method) throws Throwable {
        RedisOpsUtils.getAllKeys((String)"rtmp:*").forEach(key -> {
            String deviceSn;
            Optional<DeviceDTO> dto;
            long expire = RedisOpsUtils.getExpire((String)key);
            if (expire <= 30L && (dto = Optional.ofNullable((DeviceDTO)RedisOpsUtils.get((String)("online:" + (deviceSn = key.replace("rtmp:", "")))))).isPresent()) {
                TenantUtil.setTenantId((String)dto.get().getWorkspaceId());
                YxChannelInfo channel = (YxChannelInfo)RedisOpsUtils.get((String)key);
                this.liveStreamService.liveStop(channel.getVideoId());
            }
        });
    }
}

