/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.dawn.controller;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import com.geoway.fczx.dawn.DawnTransmitApp;
import com.geoway.fczx.dawn.data.CallDataDto;
import com.geoway.fczx.dawn.data.DjiTerrainFile;
import com.geoway.fczx.dawn.data.DjiTerrainJob;
import com.geoway.fczx.dawn.data.DjiTerrainJobRes;
import com.geoway.fczx.dawn.data.DjiTerrainJobState;
import com.geoway.fczx.dawn.data.DjiTerrainToken;
import com.geoway.fczx.dawn.data.ImageUploadDto;
import com.geoway.fczx.dawn.enmus.ModelSrvType;
import com.geoway.fczx.dawn.enmus.ProcessState;
import com.geoway.fczx.dawn.handler.ModelRebuildAsyncHandler;
import com.geoway.fczx.dawn.service.ImageService;
import com.geoway.fczx.dawn.thirdapi.dji.DjiTerrainRestService;
import com.geoway.fczx.dawn.thirdapi.fczx.FczxRestService;
import com.geoway.ue.common.data.response.BaseResponse;
import com.geoway.ue.common.data.response.ObjectResponse;
import com.geoway.ue.common.data.response.OpRes;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5927\u7586\u667a\u56fe\u63a5\u53e3"})
@RestController
@ConditionalOnBean(value={DawnTransmitApp.class})
@RequestMapping(value={"/api/terrain/v1"})
public class DjiTerrainController {
    @Autowired(required=false)
    private ModelRebuildAsyncHandler modelRebuildAsyncHandler;
    @Resource
    private DjiTerrainRestService terrainService;
    @Resource
    private FczxRestService fczxRestService;
    @Resource
    private ImageService imageService;

    @ApiOperation(value="\u83b7\u53d6\u4f5c\u4e1a\u5217\u8868")
    @ApiOperationSupport(order=1)
    @GetMapping(value={"/jobs"})
    public ResponseEntity<BaseResponse> listJobs(Integer rows, Integer page, String search, String uuids, Integer type, Integer status, String origin, String output) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", type);
        map.put("uuids", uuids);
        map.put("search", search);
        map.put("status", status);
        map.put("originResourceUuid", origin);
        map.put("outputResourceUuid", output);
        map.put("page", ObjectUtil.isEmpty((Object)page) ? 1 : page);
        map.put("rows", ObjectUtil.isEmpty((Object)rows) ? 10 : rows);
        JSONArray res = this.terrainService.listJobs(map);
        return ObjectResponse.ok((Object)res);
    }

    @ApiOperation(value="\u83b7\u53d6\u4f5c\u4e1a\u8be6\u60c5")
    @ApiOperationSupport(order=2)
    @GetMapping(value={"/jobs/{jobId}"})
    public ResponseEntity<BaseResponse> queryJobStatus(@PathVariable String jobId) {
        DjiTerrainJobState res = this.terrainService.queryJobStatus(jobId);
        return ObjectResponse.ok((Object)res);
    }

    @ApiOperation(value="\u83b7\u53d6\u63a5\u53e3\u51ed\u8bc1")
    @ApiOperationSupport(order=3)
    @PostMapping(value={"/obtain/token"})
    public ResponseEntity<BaseResponse> obtainToken() {
        DjiTerrainToken res = this.terrainService.obtainToken();
        return ObjectResponse.ok((Object)res);
    }

    @ApiOperation(value="\u521b\u5efa\u4f5c\u4e1a\u4efb\u52a1")
    @ApiOperationSupport(order=4)
    @PostMapping(value={"/jobs/info"})
    public ResponseEntity<BaseResponse> createJob(String name) {
        DjiTerrainJob res = this.terrainService.createJob(name);
        return ObjectResponse.ok((Object)res);
    }

    @ApiOperation(value="\u5220\u9664\u4f5c\u4e1a\u4efb\u52a1")
    @ApiOperationSupport(order=5)
    @PostMapping(value={"/jobs/{jobId}"})
    public ResponseEntity<BaseResponse> removeJob(@PathVariable String jobId) {
        JSONObject res = this.terrainService.removeJob(jobId);
        return ObjectResponse.ok((Object)res);
    }

    @ApiOperation(value="\u5f00\u59cb\u4f5c\u4e1a\u4efb\u52a1")
    @ApiOperationSupport(order=6)
    @PostMapping(value={"/jobs/{jobId}/start"})
    public ResponseEntity<BaseResponse> startJob(@PathVariable String jobId, String resId, Integer type, String parameters) {
        Boolean res = this.terrainService.startJob(jobId, resId, type, parameters);
        return ObjectResponse.ok((Object)res);
    }

    @ApiOperation(value="\u505c\u6b62\u4f5c\u4e1a\u4efb\u52a1", notes="\u505c\u6b62\u6307\u5b9a uuid \u7684\u4f5c\u4e1a, \u9700\u8981 job \u7684 status < 4")
    @ApiOperationSupport(order=7)
    @PostMapping(value={"/jobs/{jobId}/stop"})
    public ResponseEntity<BaseResponse> stopJob(@PathVariable String jobId) {
        Boolean res = this.terrainService.stopJob(jobId);
        return ObjectResponse.ok((Object)res);
    }

    @ApiOperation(value="\u521b\u5efa\u91cd\u5efa\u4efb\u52a1", produces="application/json;charset=UTF-8", consumes="application/json")
    @ApiOperationSupport(order=8)
    @PostMapping(value={"/rebuild/task"})
    public ResponseEntity<BaseResponse> rebuildTask(@RequestBody ImageUploadDto param) {
        if (param == null || ObjectUtil.isEmpty(param.getList()) || ObjectUtil.isEmpty((Object)param.getBizId())) {
            return BaseResponse.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String processId = "";
        if (ObjectUtil.equal((Object)ModelSrvType.DJI.getType(), (Object)param.getModelSrvType())) {
            DjiTerrainJob job = this.terrainService.createJob(param.getBizId());
            if (job == null || ObjectUtil.isEmpty((Object)job.getUuid())) {
                return BaseResponse.error((String)"\u521b\u5efa\u5927\u7586\u667a\u56fe\u5efa\u6a21\u4efb\u52a1\u5931\u8d25");
            }
            processId = job.getUuid();
        }
        if (BooleanUtil.isTrue((Boolean)param.getAsync())) {
            this.modelRebuildAsyncHandler.createModelRebuildAsync(param, processId);
            return ObjectResponse.ok((Object)processId);
        }
        OpRes<String> res = this.imageService.createRebuildTask(param, processId);
        return res.isOpRes() ? ObjectResponse.ok((Object)res.getData()) : BaseResponse.error((String)res.getErrorDesc());
    }

    @ApiOperation(value="\u83b7\u53d6\u6267\u884c\u5217\u8868")
    @ApiOperationSupport(order=9)
    @GetMapping(value={"/doing/tasks"})
    public ResponseEntity<BaseResponse> doingTasks() {
        Map<String, String> res = this.imageService.getJobStatusTimer();
        return ObjectResponse.ok(res);
    }

    @ApiOperation(value="\u67e5\u8be2\u4efb\u52a1\u6210\u679c")
    @ApiOperationSupport(order=10)
    @GetMapping(value={"/res/{resId}"})
    public ResponseEntity<BaseResponse> queryJobResult(@PathVariable String resId) {
        DjiTerrainJobRes res = this.terrainService.queryJobResult(resId);
        return ObjectResponse.ok((Object)res);
    }

    @ApiOperation(value="\u67e5\u8be2\u6587\u4ef6\u5217\u8868")
    @ApiOperationSupport(order=11)
    @GetMapping(value={"/files"})
    public ResponseEntity<BaseResponse> queryFiles(Integer rows, Integer page, String search, String uuids, Boolean needURL) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("uuids", uuids);
        map.put("search", search);
        map.put("needURL", needURL);
        map.put("page", ObjectUtil.isEmpty((Object)page) ? 1 : page);
        map.put("rows", ObjectUtil.isEmpty((Object)rows) ? 10 : rows);
        List<DjiTerrainFile> res = this.terrainService.listFiles(map);
        return ObjectResponse.ok(res);
    }

    @ApiOperation(value="\u4e0b\u8f7d\u91cd\u5efa\u6210\u679c")
    @ApiOperationSupport(order=12)
    @GetMapping(value={"/rebuild/result"})
    public void downloadRebuild(String processId, String bizId, Integer modelSrvType, HttpServletResponse response) {
        this.imageService.downloadRebuild(bizId, processId, modelSrvType, response);
    }

    @ApiOperation(value="\u540c\u6b65\u4efb\u52a1\u6210\u679c")
    @ApiOperationSupport(order=10)
    @PostMapping(value={"/sync/rebuild"})
    public ResponseEntity<BaseResponse> syncRebuild(@RequestBody ImageUploadDto param) {
        boolean res = this.imageService.syncRebuild(param);
        return res ? BaseResponse.ok() : BaseResponse.error((String)"\u540c\u6b65\u4efb\u52a1\u6210\u679c\u5931\u8d25");
    }

    @ApiOperation(value="\u540c\u6b65\u6a21\u578b\u91cd\u5efa")
    @ApiOperationSupport(order=11)
    @PostMapping(value={"/model/resync"})
    public ResponseEntity<BaseResponse> modelResync(String workspaceId, String processId) {
        boolean res = this.fczxRestService.modelResync(workspaceId, processId);
        return res ? BaseResponse.ok() : BaseResponse.error((String)"\u540c\u6b65\u6a21\u578b\u91cd\u5efa\u5931\u8d25");
    }

    @ApiOperation(value="\u901a\u77e5\u91cd\u5efa\u5b8c\u6210")
    @ApiOperationSupport(order=13)
    @PostMapping(value={"/notice/finish"})
    public ResponseEntity<BaseResponse> noticeRebuild(@RequestBody ImageUploadDto data) {
        boolean res = this.fczxRestService.downOutputCall(new CallDataDto("rebuild", data.getProcessId(), ProcessState.COMPLETE.name(), data));
        return res ? BaseResponse.ok() : BaseResponse.error((String)"\u91cd\u53d1\u91cd\u5efa\u6d88\u606f\u5931\u8d25");
    }
}

