/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.dawn.enmus;

import cn.hutool.core.util.ObjectUtil;
import com.geoway.fczx.dawn.data.DjiTerrainJobState;
import com.geoway.fczx.dawn.data.ProcessTask;
import com.geoway.fczx.dawn.data.RsmseJobStatus;
import java.util.Arrays;

public enum ProcessState {
    DONE("-99", -99, -99, "\u5b8c\u6210"),
    DTAIL_ERROR("-2", -2, -2, "\u53d1\u5e03\u5f71\u50cf\u5931\u8d25"),
    DOWN_ERROR("-1", -1, -1, "\u4e0b\u8f7d\u5931\u8d25"),
    UN_RUNNING("0", 10, 1, "\u7b49\u5f85\u4e2d"),
    RUNNING("1", 30, 3, "\u6267\u884c\u4e2d"),
    COMPLETE("2", 40, 6, "\u5b8c\u6210"),
    ERROR("3", 50, 7, "\u51fa\u9519"),
    PAUSE("4", 60, 1, "\u6682\u505c"),
    BE_KILLED("5", 70, 5, "\u88ab\u7ec8\u6b62"),
    COUNTDOWN("6", 10, 2, "\u5012\u8ba1\u65f6");

    final String rsdawn;
    final Integer rsmse;
    final Integer dji;
    final String desc;

    public static String findDji(DjiTerrainJobState state) {
        return Arrays.stream(ProcessState.values()).filter(n -> ObjectUtil.equal((Object)n.dji, (Object)state.getStatus())).findFirst().orElse(RUNNING).name();
    }

    public static Integer findStatus(String state) {
        return Arrays.stream(ProcessState.values()).filter(n -> ObjectUtil.equal((Object)n.name(), (Object)state)).findFirst().orElse(ERROR).getDji();
    }

    public static String findRsdawn(ProcessTask state) {
        return Arrays.stream(ProcessState.values()).filter(n -> ObjectUtil.equal((Object)n.name(), (Object)state.getState())).findFirst().orElse(RUNNING).name();
    }

    public static String findRsmse(RsmseJobStatus state) {
        return Arrays.stream(ProcessState.values()).filter(n -> ObjectUtil.equal((Object)n.rsmse, (Object)state.getStatus())).findFirst().orElse(RUNNING).name();
    }

    public String getRsdawn() {
        return this.rsdawn;
    }

    public Integer getRsmse() {
        return this.rsmse;
    }

    public Integer getDji() {
        return this.dji;
    }

    public String getDesc() {
        return this.desc;
    }

    private ProcessState(String rsdawn, Integer rsmse, Integer dji, String desc) {
        this.rsdawn = rsdawn;
        this.rsmse = rsmse;
        this.dji = dji;
        this.desc = desc;
    }
}

