/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.dawn.handler;

import com.geoway.fczx.dawn.annotation.IgnoreLoad;
import com.geoway.fczx.dawn.data.CallDataDto;
import com.geoway.fczx.dawn.data.ImageUploadDto;
import com.geoway.fczx.dawn.enmus.ProcessState;
import com.geoway.fczx.dawn.service.ImageService;
import com.geoway.fczx.dawn.thirdapi.fczx.FczxRestService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@IgnoreLoad
@Component
public class PackDownAsyncHandler {
    private static final Logger log = LoggerFactory.getLogger(PackDownAsyncHandler.class);
    @Resource
    private ImageService imageService;
    @Resource
    private FczxRestService fczxRestService;

    @Async(value="videoSpliceExecutor")
    public void createPackDownAsync(ImageUploadDto data) {
        try {
            boolean flag = this.imageService.createPackageTask(data);
            if (!flag) {
                this.fczxRestService.downErrorCall(new CallDataDto("package", null, ProcessState.ERROR.name(), data));
            } else {
                this.fczxRestService.downErrorCall(new CallDataDto("package", null, ProcessState.COMPLETE.name(), data));
            }
        }
        catch (Exception e) {
            log.error("\u5f02\u6b65\u4efb\u52a1\u6267\u884c\u5f02\u5e38", (Throwable)e);
            this.fczxRestService.downErrorCall(new CallDataDto("package", null, ProcessState.ERROR.name(), data));
        }
    }
}

