/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.dawn.handler;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ObjectUtil;
import com.geoway.fczx.dawn.data.ImageUploadRes;
import com.geoway.fczx.dawn.service.DownloadProgressService;
import com.geoway.fczx.dawn.util.TransmitTool;
import java.net.URLEncoder;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadThreadHandler
implements Callable<ImageUploadRes> {
    private static final Logger log = LoggerFactory.getLogger(UploadThreadHandler.class);
    private static final int RETRY_COUNT = 3;
    private DownloadProgressService progress;
    private String objectKey;
    private String path;
    private String server;

    @Override
    public ImageUploadRes call() throws Exception {
        int count = 0;
        String fileName = FileUtil.getName((String)this.objectKey);
        log.debug("\u5f00\u59cb\u4e0b\u8f7d\u6587\u4ef6{}\uff0c\u662f\u5426\u56de\u8c03{}", (Object)fileName, (Object)ObjectUtil.isNotEmpty((Object)this.progress));
        ImageUploadRes res = new ImageUploadRes(this.objectKey, this.path);
        int len = this.objectKey.indexOf(fileName);
        String encoder = this.objectKey.substring(0, len) + URLEncoder.encode(fileName, "UTF-8");
        String href = this.server + "/api/files/v1/original?objectKey=" + encoder;
        if (fileName.endsWith(".mp4")) {
            String url = this.server + "/api/files/v1/redirect?objectKey=" + encoder;
            href = TransmitTool.getRedirectUrl(url);
        }
        if (ObjectUtil.isEmpty((Object)href)) {
            log.error("\u4e0b\u8f7d\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
            res.setSuccess(false);
            return res;
        }
        boolean flag = TransmitTool.downloadImage(href, this.path);
        while (!flag && count < 3) {
            log.error("{}\u91cd\u8bd5{}\u6b21\u4e0b\u8f7d", (Object)fileName, (Object)(++count));
            flag = TransmitTool.downloadImage(href, this.path);
        }
        res.setSuccess(flag);
        if (this.progress != null) {
            try {
                this.progress.handleProgress(fileName, flag);
            }
            catch (Exception e) {
                log.error("\u5904\u7406\u8fdb\u5ea6\u5f02\u5e38", (Throwable)e);
            }
        }
        log.debug("\u5f00\u59cb\u4e0b\u8f7d\u6587\u4ef6{}\uff0c\u5b8c\u6210{}", (Object)fileName, (Object)flag);
        return res;
    }

    public DownloadProgressService getProgress() {
        return this.progress;
    }

    public String getObjectKey() {
        return this.objectKey;
    }

    public String getPath() {
        return this.path;
    }

    public String getServer() {
        return this.server;
    }

    public void setProgress(DownloadProgressService progress) {
        this.progress = progress;
    }

    public void setObjectKey(String objectKey) {
        this.objectKey = objectKey;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UploadThreadHandler)) {
            return false;
        }
        UploadThreadHandler other = (UploadThreadHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DownloadProgressService this$progress = this.getProgress();
        DownloadProgressService other$progress = other.getProgress();
        if (this$progress == null ? other$progress != null : !this$progress.equals(other$progress)) {
            return false;
        }
        String this$objectKey = this.getObjectKey();
        String other$objectKey = other.getObjectKey();
        if (this$objectKey == null ? other$objectKey != null : !this$objectKey.equals(other$objectKey)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$server = this.getServer();
        String other$server = other.getServer();
        return !(this$server == null ? other$server != null : !this$server.equals(other$server));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UploadThreadHandler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DownloadProgressService $progress = this.getProgress();
        result = result * 59 + ($progress == null ? 43 : $progress.hashCode());
        String $objectKey = this.getObjectKey();
        result = result * 59 + ($objectKey == null ? 43 : $objectKey.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : $server.hashCode());
        return result;
    }

    public String toString() {
        return "UploadThreadHandler(progress=" + this.getProgress() + ", objectKey=" + this.getObjectKey() + ", path=" + this.getPath() + ", server=" + this.getServer() + ")";
    }

    public UploadThreadHandler(DownloadProgressService progress, String objectKey, String path, String server) {
        this.progress = progress;
        this.objectKey = objectKey;
        this.path = path;
        this.server = server;
    }
}

