/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.dawn.thirdapi.dawn;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.geoway.fczx.dawn.data.ProcessModel;
import com.geoway.fczx.dawn.data.ProcessResult;
import com.geoway.fczx.dawn.data.ProcessTask;
import com.geoway.fczx.dawn.data.ProcessTaskStat;
import com.geoway.fczx.dawn.data.property.DawnTransmitProperties;
import com.geoway.ue.common.data.response.OpRes;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class DawnRestService {
    private static final Logger log = LoggerFactory.getLogger(DawnRestService.class);
    @Resource
    private RestTemplate dawnApiRest;
    @Resource
    private DawnTransmitProperties transmitProperties;
    private static final String createTaskUrl = "/rs-dawn-admin/outerProcess/createByOrderThenStart";
    private static final String queryTaskUrl = "/rs-dawn-admin/processEntity/getStateAndProgress?processId={processId}";
    private static final String queryTaskStatUrl = "/rs-dawn-admin/processEntity/getProcessNodeTaskStatInfo?processId={processId}&nodeId={nodeId}";
    private static final String queryMetadataUrl = "/rs-dawn-admin/flowModelEntity/getMetadata?flowModelId={flowModelId}";
    private static final String queryResultUrl = "/rs-dawn-admin/dataItemEntity/page?size=500&src=PRODUCE_OUT&processExecNum=1&page=0&processId={processId}";

    @PostConstruct
    public void initDawnService() {
        if (ObjectUtil.isEmpty((Object)this.transmitProperties.getVideoSpliceServer())) {
            log.error("\u5f71\u50cf\u5feb\u62fc\u670d\u52a1\u5730\u5740\u4e3anull\uff0c\u8fd9\u5c06\u4f1a\u5bfc\u81f4\u5f71\u50cf\u5feb\u62fc\u670d\u52a1\u4e0d\u53ef\u7528");
        }
    }

    public OpRes<ProcessModel> queryMetadata(String flowModelId) {
        String url = this.transmitProperties.getVideoSpliceServer().concat(queryMetadataUrl);
        ResponseEntity res = this.dawnApiRest.getForEntity(url, String.class, new Object[]{flowModelId});
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u83b7\u53d6\u6a21\u578b\u5143\u6570\u636e\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)res);
            return new OpRes(JSONUtil.parseObj((String)((String)res.getBody())).getStr((Object)"msg"), null, false);
        }
        return new OpRes(null, (Object)((ProcessModel)JSONUtil.parseObj((String)((String)res.getBody())).get((Object)"data", ProcessModel.class)), true);
    }

    public OpRes<String> createTask(Map<String, Object> param) {
        String url = this.transmitProperties.getVideoSpliceServer().concat(createTaskUrl);
        ResponseEntity res = this.dawnApiRest.postForEntity(url, (Object)new HttpEntity(param), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u521b\u5efa\u4efb\u52a1\u5e76\u7acb\u5373\u6267\u884c\u5931\u8d25\uff1a{}", (Object)res);
            return new OpRes(JSONUtil.parseObj((String)((String)res.getBody())).getStr((Object)"msg"), null, false);
        }
        return new OpRes(null, (Object)JSONUtil.parseObj((String)((String)res.getBody())).getStr((Object)"data"), true);
    }

    public OpRes<ProcessTask> queryTask(String processId) {
        String url = this.transmitProperties.getVideoSpliceServer().concat(queryTaskUrl);
        ResponseEntity res = this.dawnApiRest.getForEntity(url, String.class, new Object[]{processId});
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u67e5\u8be2\u4efb\u52a1\u72b6\u6001\u53ca\u8fdb\u5ea6\u5931\u8d25\uff1a{}", (Object)res);
            return new OpRes(JSONUtil.parseObj((String)((String)res.getBody())).getStr((Object)"msg"), null, false);
        }
        return new OpRes(null, (Object)((ProcessTask)JSONUtil.parseObj((String)((String)res.getBody())).get((Object)"data", ProcessTask.class)), true);
    }

    public OpRes<ProcessTaskStat> queryTaskStat(String processId) {
        String url = this.transmitProperties.getVideoSpliceServer().concat(queryTaskStatUrl);
        ResponseEntity res = this.dawnApiRest.getForEntity(url, String.class, new Object[]{processId, this.transmitProperties.getNodeId()});
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u67e5\u8be2\u4efb\u52a1\u72b6\u6001\u53ca\u8fdb\u5ea6\u5931\u8d25\uff1a{}", (Object)res);
            return new OpRes(JSONUtil.parseObj((String)((String)res.getBody())).getStr((Object)"msg"), null, false);
        }
        return new OpRes(null, (Object)((ProcessTaskStat)JSONUtil.parseObj((String)((String)res.getBody())).get((Object)"data", ProcessTaskStat.class)), true);
    }

    public OpRes<List<ProcessResult>> queryResult(String processId) {
        String url = this.transmitProperties.getVideoSpliceServer().concat(queryResultUrl);
        ResponseEntity res = this.dawnApiRest.getForEntity(url, String.class, new Object[]{processId});
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u67e5\u8be2\u4efb\u52a1\u6210\u679c\u5931\u8d25\uff1a{}", (Object)res);
            return new OpRes(JSONUtil.parseObj((String)((String)res.getBody())).getStr((Object)"msg"), null, false);
        }
        return new OpRes(null, (Object)JSONUtil.parseObj((String)((String)res.getBody())).getJSONObject((Object)"data").getBeanList((Object)"records", ProcessResult.class), true);
    }

    private boolean resolveResultBool(ResponseEntity<String> res) {
        if (ObjectUtil.equal((Object)res.getStatusCode(), (Object)HttpStatus.OK) && ObjectUtil.isNotEmpty((Object)res.getBody())) {
            int code = JSONUtil.parseObj((String)((String)res.getBody())).getInt((Object)"code");
            return code == 200;
        }
        return false;
    }
}

