/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.dawn.thirdapi.dji;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.geoway.fczx.dawn.data.DjiTerrainFile;
import com.geoway.fczx.dawn.data.DjiTerrainJob;
import com.geoway.fczx.dawn.data.DjiTerrainJobRes;
import com.geoway.fczx.dawn.data.DjiTerrainJobState;
import com.geoway.fczx.dawn.data.DjiTerrainRes;
import com.geoway.fczx.dawn.data.DjiTerrainToken;
import com.geoway.fczx.dawn.data.property.DjiTerrainProperties;
import com.geoway.fczx.dawn.util.TransmitTool;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Resource;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class DjiTerrainRestService {
    private static final Logger log = LoggerFactory.getLogger(DjiTerrainRestService.class);
    @Resource
    private RestTemplate terrainApiRest;
    @Resource
    private DjiTerrainProperties terrainProperties;
    private static final String getTokenUrl = "/terra-rescon-be/v2/store/obtain_token";
    private static final String createResUrl = "/terra-rescon-be/v2/resources";
    private static final String queryResFmt = "/terra-rescon-be/v2/resources/%s";
    private static final String linkFileResUrl = "/terra-rescon-be/v2/store/upload_callback";
    private static final String startJobFmt = "/terra-rescon-be/v2/jobs/%s/start";
    private static final String stopJobFmt = "/terra-rescon-be/v2/jobs/%s/stop";
    private static final String queryJobFmt = "/terra-rescon-be/v2/jobs/%s";
    private static final String listJobsUrl = "/terra-rescon-be/v2/jobs";
    private static final String listFilesUrl = "/terra-rescon-be/v2/files";
    private DjiTerrainToken token;

    public DjiTerrainToken obtainToken() {
        HttpEntity params;
        String url = this.terrainProperties.getServerUrl().concat(getTokenUrl);
        ResponseEntity res = this.terrainApiRest.postForEntity(url, (Object)(params = new HttpEntity((Object)MapUtil.empty(), (MultiValueMap)this.buildHttpHeaders(getTokenUrl, HttpMethod.POST, ""))), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u83b7\u53d6 Token\u5931\u8d25{}", (Object)res);
            return null;
        }
        return (DjiTerrainToken)JSONUtil.parseObj((String)((String)res.getBody())).get((Object)"data", DjiTerrainToken.class);
    }

    public DjiTerrainToken getDjiTerrainToken() {
        if (this.token == null || new Date().after(this.token.getExpireDate())) {
            this.token = this.obtainToken();
        }
        return this.token;
    }

    public JSONArray listJobs(Map<String, Object> map) {
        HttpEntity params;
        String parameters = TransmitTool.buildUrlParameters(map);
        String href = listJobsUrl.concat("?").concat(parameters);
        String url = this.terrainProperties.getServerUrl().concat(href);
        ResponseEntity res = this.terrainApiRest.exchange(url, HttpMethod.GET, params = new HttpEntity((Object)MapUtil.empty(), (MultiValueMap)this.buildHttpHeaders(href, HttpMethod.GET, "")), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u83b7\u53d6\u4f5c\u4e1a\u5217\u8868\u5931\u8d25{}", (Object)res);
            return null;
        }
        return (JSONArray)JSONUtil.parseObj((String)((String)res.getBody())).getByPath("data.list", JSONArray.class);
    }

    public List<DjiTerrainFile> listFiles(Map<String, Object> map) {
        HttpEntity params;
        String parameters = TransmitTool.buildUrlParameters(map);
        String href = listFilesUrl.concat("?").concat(parameters);
        String url = this.terrainProperties.getServerUrl().concat(href);
        ResponseEntity res = this.terrainApiRest.exchange(url, HttpMethod.GET, params = new HttpEntity((Object)MapUtil.empty(), (MultiValueMap)this.buildHttpHeaders(href, HttpMethod.GET, "")), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u83b7\u53d6\u6587\u4ef6\u5217\u8868\u5931\u8d25{}", (Object)res);
            return null;
        }
        return ((JSONArray)JSONUtil.parseObj((String)((String)res.getBody())).getByPath("data.list", JSONArray.class)).toList(DjiTerrainFile.class);
    }

    public DjiTerrainRes creatResource(String name, List<String> files) {
        HttpEntity params;
        String url;
        ResponseEntity res;
        boolean flag;
        log.debug("\u521b\u5efa\u5927\u7586\u667a\u56fe\u5efa\u6a21\u8d44\u6e90");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", name);
        map.put("type", "map");
        if (ObjectUtil.isNotEmpty(files)) {
            map.put("files", files);
        }
        if (!(flag = this.resolveResultBool((ResponseEntity<String>)(res = this.terrainApiRest.postForEntity(url = this.terrainProperties.getServerUrl().concat(createResUrl), (Object)(params = new HttpEntity(map, (MultiValueMap)this.buildHttpHeaders(createResUrl, HttpMethod.POST, JSONUtil.toJsonStr(map)))), String.class, new Object[0]))))) {
            log.error("\u521b\u5efa resource\u5931\u8d25{}", (Object)res);
            return null;
        }
        return (DjiTerrainRes)JSONUtil.parseObj((String)((String)res.getBody())).get((Object)"data", DjiTerrainRes.class);
    }

    public JSONArray linkResFiles(String resId, String callback, Collection<?> files) {
        log.debug("\u521b\u5efa\u5927\u7586\u667a\u56fe\u5efa\u6a21\u5173\u8054\u8d44\u6e90");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resourceUUID", resId);
        map.put("callbackParam", callback);
        map.put("files", files);
        String url = this.terrainProperties.getServerUrl().concat(linkFileResUrl);
        HttpEntity params = new HttpEntity(map, (MultiValueMap)this.buildHttpHeaders(linkFileResUrl, HttpMethod.POST, JSONUtil.toJsonStr(map)));
        ResponseEntity res = this.terrainApiRest.postForEntity(url, (Object)params, String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u5173\u8054\u8d44\u6e90\u6587\u4ef6\u5931\u8d25{}", (Object)res);
            return null;
        }
        return JSONUtil.parseObj((String)((String)res.getBody())).getJSONArray((Object)"data");
    }

    public DjiTerrainJob createJob(String name) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", name);
        String url = this.terrainProperties.getServerUrl().concat(listJobsUrl);
        HttpEntity params = new HttpEntity(map, (MultiValueMap)this.buildHttpHeaders(listJobsUrl, HttpMethod.POST, JSONUtil.toJsonStr(map)));
        ResponseEntity res = this.terrainApiRest.postForEntity(url, (Object)params, String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u521b\u5efa\u91cd\u5efa\u4efb\u52a1\u5931\u8d25{}", (Object)res);
            return null;
        }
        return (DjiTerrainJob)JSONUtil.parseObj((String)((String)res.getBody())).get((Object)"data", DjiTerrainJob.class);
    }

    public boolean startJob(String jobId, String resId, int type, String parameters) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", type);
        map.put("resourceUUID", resId);
        map.put("parameters", parameters);
        String startJobUrl = String.format(startJobFmt, jobId);
        String url = this.terrainProperties.getServerUrl().concat(startJobUrl);
        HttpEntity params = new HttpEntity(map, (MultiValueMap)this.buildHttpHeaders(startJobUrl, HttpMethod.POST, JSONUtil.toJsonStr(map)));
        ResponseEntity res = this.terrainApiRest.postForEntity(url, (Object)params, String.class, new Object[]{jobId});
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u5f00\u59cb\u91cd\u5efa\u4efb\u52a1\u5931\u8d25{}", (Object)res);
            return false;
        }
        return true;
    }

    public boolean stopJob(String jobId) {
        String stopJobUrl = String.format(stopJobFmt, jobId);
        String url = this.terrainProperties.getServerUrl().concat(stopJobUrl);
        HttpEntity params = new HttpEntity((Object)MapUtil.empty(), (MultiValueMap)this.buildHttpHeaders(stopJobUrl, HttpMethod.POST, ""));
        ResponseEntity res = this.terrainApiRest.postForEntity(url, (Object)params, String.class, new Object[]{jobId});
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u505c\u6b62\u91cd\u5efa\u4efb\u52a1\u5931\u8d25{}", (Object)res);
            return false;
        }
        return true;
    }

    public JSONObject removeJob(String jobId) {
        String queryJobUrl = String.format(queryJobFmt, jobId);
        String url = this.terrainProperties.getServerUrl().concat(queryJobUrl);
        HttpEntity params = new HttpEntity((Object)MapUtil.empty(), (MultiValueMap)this.buildHttpHeaders(queryJobUrl, HttpMethod.DELETE, ""));
        ResponseEntity res = this.terrainApiRest.exchange(url, HttpMethod.DELETE, params, String.class, new Object[]{jobId});
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u5220\u9664\u91cd\u5efa\u4efb\u52a1\u5931\u8d25{}", (Object)res);
            return null;
        }
        return JSONUtil.parseObj((String)((String)res.getBody())).getJSONObject((Object)"data");
    }

    public DjiTerrainJobState queryJobStatus(String jobId) {
        String queryJobUrl = String.format(queryJobFmt, jobId);
        String url = this.terrainProperties.getServerUrl().concat(queryJobUrl);
        HttpEntity params = new HttpEntity((Object)MapUtil.empty(), (MultiValueMap)this.buildHttpHeaders(queryJobUrl, HttpMethod.GET, ""));
        ResponseEntity res = this.terrainApiRest.exchange(url, HttpMethod.GET, params, String.class, new Object[]{jobId});
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u67e5\u8be2\u4efb\u52a1\u72b6\u6001\u5931\u8d25{}", (Object)res);
            return null;
        }
        return (DjiTerrainJobState)JSONUtil.parseObj((String)((String)res.getBody())).get((Object)"data", DjiTerrainJobState.class);
    }

    public DjiTerrainJobRes queryJobResult(String resId) {
        String queryResUrl = String.format(queryResFmt, resId);
        String url = this.terrainProperties.getServerUrl().concat(queryResUrl);
        HttpEntity params = new HttpEntity((Object)MapUtil.empty(), (MultiValueMap)this.buildHttpHeaders(queryResUrl, HttpMethod.GET, ""));
        ResponseEntity res = this.terrainApiRest.exchange(url, HttpMethod.GET, params, String.class, new Object[]{resId});
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u67e5\u8be2\u4efb\u52a1\u6210\u679c\u5931\u8d25{}", (Object)res);
            return null;
        }
        return (DjiTerrainJobRes)JSONUtil.parseObj((String)((String)res.getBody())).get((Object)"data", DjiTerrainJobRes.class);
    }

    private boolean resolveResultBool(ResponseEntity<String> res) {
        if (ObjectUtil.equal((Object)res.getStatusCode(), (Object)HttpStatus.OK) && ObjectUtil.isNotEmpty((Object)res.getBody())) {
            int code = (Integer)JSONUtil.parseObj((String)((String)res.getBody())).getByPath("result.code", Integer.class);
            return code == 0;
        }
        return false;
    }

    private HttpHeaders buildHttpHeaders(String uri, HttpMethod method, String payload) {
        String date = this.getFormattedDate();
        String digest = this.getDigest(payload);
        HttpHeaders headers = new HttpHeaders();
        headers.set("Date", date);
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set("Digest", "SHA-256=".concat(digest));
        String signature = this.buildSignature(uri, date, method.name().toLowerCase(), digest);
        headers.set("Authorization", String.format("hmac username=\"%s\", algorithm=\"hmac-sha256\", headers=\"date @request-target digest\", signature=\"%s\"", this.terrainProperties.getAppKey(), signature));
        return headers;
    }

    private String getFormattedDate() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US).withZone(ZoneId.of("GMT"));
        return formatter.format(ZonedDateTime.now(ZoneId.of("GMT")));
    }

    private String getDigest(String payload) {
        try {
            return Base64.getEncoder().encodeToString(MessageDigest.getInstance("SHA-256").digest(payload.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            log.error("\u53c2\u6570\u52a0\u7b7e\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u53c2\u6570\u52a0\u7b7e\u5931\u8d25");
        }
    }

    private String buildSignature(String uri, String date, String method, String digest) {
        try {
            String content = String.format("date: %s\n@request-target: %s %s\ndigest: SHA-256=%s", date, method, uri, digest);
            Mac hmacSha256 = Mac.getInstance("HmacSHA256");
            hmacSha256.init(new SecretKeySpec(this.terrainProperties.getSecretKey().getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
            return Base64.getEncoder().encodeToString(hmacSha256.doFinal(content.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            log.error("\u6784\u5efa\u7b7e\u540d\u5b57\u7b26\u4e32\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u6784\u5efa\u7b7e\u540d\u5b57\u7b26\u4e32\u5931\u8d25");
        }
    }
}

