/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.dawn.thirdapi.fczx;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.geoway.fczx.dawn.annotation.IgnoreLoad;
import com.geoway.fczx.dawn.data.CallDataDto;
import com.geoway.fczx.dawn.data.ProcessInfo;
import com.geoway.fczx.dawn.data.SpliceCallData;
import com.geoway.fczx.dawn.data.property.DawnTransmitProperties;
import java.util.HashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@IgnoreLoad
@Component
public class FczxRestService {
    private static final Logger log = LoggerFactory.getLogger(FczxRestService.class);
    @Resource
    private RestTemplate fczxApiRest;
    @Resource
    private DawnTransmitProperties transmitProperties;
    private static final String X_TENANT_ID = "x-tenant-id";

    public boolean downErrorCall(CallDataDto callDataDto) {
        return this.downOutputCall(callDataDto);
    }

    public boolean downOutputCall(CallDataDto call) {
        SpliceCallData callData = new SpliceCallData();
        ProcessInfo process = new ProcessInfo();
        HashMap<String, String> bizInfo = new HashMap<String, String>();
        bizInfo.put("bizId", call.getBizId());
        if (ObjectUtil.isNotEmpty((Object)call.getProcessId())) {
            process.setId(call.getProcessId());
        }
        process.setState(call.getState());
        process.setBizInfo(bizInfo);
        callData.setProcessInfo(process);
        callData.setNoProcess(call.getNoProcess());
        callData.setOutputResult(call.getOutput());
        callData.setWorkspaceId(call.getWorkspaceId());
        HttpHeaders headers = new HttpHeaders();
        if (ObjectUtil.isNotEmpty((Object)call.getWorkspaceId())) {
            headers.set(X_TENANT_ID, call.getWorkspaceId());
        } else if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{call.getTokenName(), call.getToken()})) {
            headers.set(call.getTokenName(), call.getToken());
        }
        String url = this.transmitProperties.getDroneServerUrl();
        ResponseEntity res = null;
        try {
            if (ObjectUtil.equal((Object)"rebuild", (Object)call.getType())) {
                url = url.concat("/api/transmit/v1/rebuild/call");
                log.debug("\u8bbe\u7f6e{}\uff1a{}\n\u53c2\u6570{}", new Object[]{call.getTokenName(), call.getToken(), call});
                res = this.fczxApiRest.postForEntity(url, (Object)new HttpEntity((Object)call, (MultiValueMap)headers), String.class, new Object[0]);
            } else if (ObjectUtil.equal((Object)"package", (Object)call.getType())) {
                url = url.concat("/api/transmit/v1/package/call");
                log.debug("\u53c2\u6570{}", (Object)JSONUtil.toJsonStr((Object)call));
                res = this.fczxApiRest.postForEntity(url, (Object)new HttpEntity((Object)call, (MultiValueMap)headers), String.class, new Object[0]);
            } else {
                url = url.concat("/api/transmit/v1/splice/call");
                log.debug("\u8bbe\u7f6e{}\uff1a{}\n\u53c2\u6570{}", new Object[]{call.getTokenName(), call.getToken(), callData});
                res = this.fczxApiRest.postForEntity(url, (Object)new HttpEntity((Object)callData, (MultiValueMap)headers), String.class, new Object[0]);
            }
        }
        catch (Exception e) {
            log.error("\u56de\u62a5\u5efa\u6a21/\u5feb\u62fc/\u6253\u5305\u7ed3\u679c{}\u5f02\u5e38", (Object)JSONUtil.toJsonStr((Object)callData), (Object)e);
            return false;
        }
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u5efa\u6a21/\u5feb\u62fc/\u6253\u5305\u9519\u8bef\u56de\u8c03\u5931\u8d25\uff1a{}", (Object)res);
            return false;
        }
        return true;
    }

    public boolean modelResync(String workspaceId, String processId) {
        log.debug("\u6a21\u578b\u91cd\u5efa\u540c\u6b65{},{}", (Object)workspaceId, (Object)processId);
        HttpHeaders headers = new HttpHeaders();
        if (ObjectUtil.isNotEmpty((Object)workspaceId)) {
            headers.set(X_TENANT_ID, workspaceId);
        }
        String url = this.transmitProperties.getDroneServerUrl();
        url = url.concat("/api/model/v1/resync/rebuild");
        if (ObjectUtil.isNotEmpty((Object)processId)) {
            url = url.concat("?id=").concat(processId);
        }
        log.debug("\u8bf7\u6c42{}", (Object)url);
        ResponseEntity res = this.fczxApiRest.postForEntity(url, (Object)new HttpEntity((MultiValueMap)headers), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u6a21\u578b\u91cd\u5efa\u540c\u6b65\u5931\u8d25\uff1a{}", (Object)res);
            return false;
        }
        return true;
    }

    public boolean packageResync(String workspaceId, String bizId) {
        log.debug("\u6253\u5305\u4e0b\u8f7d\u540c\u6b65{}{}", (Object)workspaceId, (Object)bizId);
        HttpHeaders headers = new HttpHeaders();
        if (ObjectUtil.isNotEmpty((Object)workspaceId)) {
            headers.set(X_TENANT_ID, workspaceId);
        }
        String url = this.transmitProperties.getDroneServerUrl();
        url = url.concat("/api/package/v1/interrupt");
        if (ObjectUtil.isNotEmpty((Object)bizId)) {
            url = url.concat("?id=").concat(bizId);
        }
        log.debug("\u8bf7\u6c42{}", (Object)url);
        ResponseEntity res = this.fczxApiRest.postForEntity(url, (Object)new HttpEntity((MultiValueMap)headers), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u6253\u5305\u4e0b\u8f7d\u540c\u6b65\u5931\u8d25\uff1a{}", (Object)res);
            return false;
        }
        return true;
    }

    public JSONArray getPackageSpots(String workspaceId, String bizId) {
        log.debug("\u83b7\u53d6\u6253\u5305\u56fe\u6591{}{}", (Object)workspaceId, (Object)bizId);
        HttpHeaders headers = new HttpHeaders();
        if (ObjectUtil.isNotEmpty((Object)workspaceId)) {
            headers.set(X_TENANT_ID, workspaceId);
        }
        String url = this.transmitProperties.getDroneServerUrl();
        url = url.concat("/api/package/v1/spots");
        if (ObjectUtil.isNotEmpty((Object)bizId)) {
            url = url.concat("?id=").concat(bizId);
        }
        log.debug("\u8bf7\u6c42{}", (Object)url);
        ResponseEntity res = this.fczxApiRest.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u83b7\u53d6\u6253\u5305\u56fe\u6591\u5931\u8d25\uff1a{}", (Object)res);
            return null;
        }
        if (ObjectUtil.isNotEmpty((Object)res.getBody())) {
            return JSONUtil.parseArray((String)((String)res.getBody()));
        }
        return null;
    }

    private boolean resolveResultBool(ResponseEntity<String> res) {
        return ObjectUtil.equal((Object)res.getStatusCode(), (Object)HttpStatus.OK);
    }
}

