/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.live.config;

import cn.hutool.core.util.ObjectUtil;
import com.geoway.fczx.live.analysis.GwAiServiceHandler;
import com.geoway.fczx.live.analysis.ZyAiServiceHandler;
import com.geoway.fczx.live.data.property.AnalysisApiProperties;
import com.geoway.fczx.live.data.property.HuaweiObsProperties;
import com.geoway.fczx.live.data.property.LiveApiProperties;
import com.geoway.fczx.live.enmus.AnalysisProvider;
import com.geoway.fczx.live.enmus.LiveProvider;
import com.geoway.fczx.live.enmus.StorageProvider;
import com.geoway.fczx.live.handler.AbstractAnalysisHandler;
import com.geoway.fczx.live.handler.AbstractLiveHandler;
import com.geoway.fczx.live.handler.AbstractStoreHandler;
import com.geoway.fczx.live.handler.RestErrorHandler;
import com.geoway.fczx.live.storage.EosServiceHandler;
import com.geoway.fczx.live.storage.MinioServiceHandler;
import com.geoway.fczx.live.storage.ObsServiceHandler;
import com.geoway.fczx.live.stream.AgoraLiveServiceHandler;
import com.geoway.fczx.live.stream.SrsLiveServiceHandler;
import com.geoway.fczx.live.stream.YdLiveServiceHandler;
import com.geoway.fczx.live.stream.YxLiveServiceHandler;
import com.geoway.ue.common.util.SpringTool;
import javax.annotation.Resource;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@Configuration
public class LiveRecordConfig {
    private static final Logger log = LoggerFactory.getLogger(LiveRecordConfig.class);
    @Resource
    private LiveApiProperties liveProperties;
    @Resource
    private HuaweiObsProperties obsProperties;
    @Resource
    private AnalysisApiProperties analysisProperties;

    @Bean
    public SpringTool springTool() {
        return new SpringTool();
    }

    @Bean
    public RestTemplate liveRecordApiRest() {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setErrorHandler((ResponseErrorHandler)new RestErrorHandler());
        restTemplate.setRequestFactory((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory());
        return restTemplate;
    }

    @Bean
    public AbstractLiveHandler liveRecordService() {
        if (ObjectUtil.equal((Object)((Object)this.liveProperties.getProvider()), (Object)((Object)LiveProvider.srs))) {
            return new SrsLiveServiceHandler(this.storeService());
        }
        if (ObjectUtil.equal((Object)((Object)this.liveProperties.getProvider()), (Object)((Object)LiveProvider.yunxin))) {
            return new YxLiveServiceHandler(this.storeService());
        }
        if (ObjectUtil.equal((Object)((Object)this.liveProperties.getProvider()), (Object)((Object)LiveProvider.yidong))) {
            return new YdLiveServiceHandler(this.storeService());
        }
        if (ObjectUtil.equal((Object)((Object)this.liveProperties.getProvider()), (Object)((Object)LiveProvider.agora))) {
            return new AgoraLiveServiceHandler(this.storeService());
        }
        throw new RuntimeException("\u672a\u77e5\u6d41\u5a92\u4f53\u670d\u52a1\u7c7b\u578b");
    }

    @Bean
    public AbstractStoreHandler storeService() {
        if (ObjectUtil.equal((Object)((Object)this.obsProperties.getProvider()), (Object)((Object)StorageProvider.huawei))) {
            return new ObsServiceHandler(this.obsProperties);
        }
        if (ObjectUtil.equal((Object)((Object)this.obsProperties.getProvider()), (Object)((Object)StorageProvider.aws))) {
            return new EosServiceHandler(this.obsProperties);
        }
        return new MinioServiceHandler(this.obsProperties);
    }

    @Bean
    public AbstractAnalysisHandler analysisService() {
        if (ObjectUtil.equal((Object)((Object)this.analysisProperties.getProvider()), (Object)((Object)AnalysisProvider.cmlc))) {
            return new ZyAiServiceHandler();
        }
        if (ObjectUtil.equal((Object)((Object)this.liveProperties.getProvider()), (Object)((Object)LiveProvider.yunxin))) {
            return new GwAiServiceHandler();
        }
        log.error("\u672a\u77e5AI\u670d\u52a1\u7c7b\u578b");
        return new GwAiServiceHandler();
    }

    @Bean
    public FilterRegistrationBean corsFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(Boolean.valueOf(true));
        config.addAllowedOriginPattern("*");
        config.addAllowedHeader("*");
        config.setMaxAge(Long.valueOf(18000L));
        config.addAllowedMethod("OPTIONS");
        config.addAllowedMethod("HEAD");
        config.addAllowedMethod("GET");
        config.addAllowedMethod("PUT");
        config.addAllowedMethod("POST");
        config.addAllowedMethod("DELETE");
        config.addAllowedMethod("PATCH");
        source.registerCorsConfiguration("/**", config);
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)new CorsFilter((CorsConfigurationSource)source), new ServletRegistrationBean[0]);
        bean.setOrder(0);
        return bean;
    }
}

