/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.live.config;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.geoway.fczx.live.data.property.LiveApiProperties;
import com.geoway.fczx.live.enmus.LiveProvider;
import io.swagger.annotations.ApiOperation;
import java.util.function.Predicate;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.ApiSelectorBuilder;
import springfox.documentation.spring.web.plugins.Docket;

@Component
public class LiveSwaggerConfig {
    private static final Logger log = LoggerFactory.getLogger(LiveSwaggerConfig.class);
    public static final String VERSION = "1.0";
    public static final String TITLE = "live-record-api";
    public static final String GROUP = "live-record-api";
    public static final String PKG = "com.geoway.fczx.live";
    public static final String NAME = "liaoyongxiang";
    public static final String URL = "http://geoway.com.cn/";
    public static final String DESCRIPTION = "\u89c6\u9891\u5f55\u5236\u670d\u52a1\u63a5\u53e3";
    public static final String EMAIL = "liaoyongxiang@geoway.com.cn";
    @Resource
    private LiveApiProperties liveProperties;

    @Bean(value={"live-record-api"})
    public Docket api() {
        Docket docket = new Docket(DocumentationType.OAS_30);
        docket.groupName("live-record-api");
        docket.apiInfo(this.apiInfo()).enable(true);
        ApiSelectorBuilder builder = new ApiSelectorBuilder(docket);
        builder.apis(RequestHandlerSelectors.withMethodAnnotation(ApiOperation.class));
        return LiveSwaggerConfig.buildPath(builder, this.liveProperties).build();
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title("live-record-api").description(DESCRIPTION).contact(new Contact(NAME, URL, EMAIL)).version(VERSION).build();
    }

    public static ApiSelectorBuilder buildPath(ApiSelectorBuilder builder, LiveApiProperties liveProperties) {
        Predicate<String> selector = PathSelectors.any();
        if (!BooleanUtil.isTrue((Boolean)liveProperties.getEnableRecordCallback())) {
            if (ObjectUtil.equal((Object)((Object)liveProperties.getProvider()), (Object)((Object)LiveProvider.yunxin))) {
                selector = selector.and(url -> !url.endsWith("/agora/record/callback") && !url.endsWith("/srs/record/callback"));
            } else if (ObjectUtil.equal((Object)((Object)liveProperties.getProvider()), (Object)((Object)LiveProvider.srs))) {
                selector = selector.and(url -> !url.endsWith("/agora/record/callback") && !url.endsWith("/yx/record/callback"));
            } else if (ObjectUtil.equal((Object)((Object)liveProperties.getProvider()), (Object)((Object)LiveProvider.agora))) {
                selector = selector.and(url -> !url.endsWith("/yx/record/callback") && !url.endsWith("/srs/record/callback"));
            }
        }
        return builder.paths((Predicate)selector);
    }
}

