/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.live.controller;

import com.geoway.fczx.live.data.mqtt.FlowRule;
import com.geoway.fczx.live.data.mqtt.LogTrace;
import com.geoway.fczx.live.data.property.EmqxProperties;
import com.geoway.fczx.live.thirdapi.emqx.EmqxRestService;
import com.geoway.ue.common.data.response.BaseResponse;
import com.geoway.ue.common.data.response.ObjectResponse;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@ApiIgnore
@Api(tags={"emqx\u6d4b\u8bd5\u63a5\u53e3"}, hidden=true)
@RestController
@RequestMapping(value={"/api/emqx/v1"})
public class EmqxTestController {
    @Resource
    private EmqxRestService emqxRestService;

    @ApiOperation(value="\u83b7\u53d6\u63a5\u53e3\u51ed\u8bc1")
    @ApiOperationSupport(order=1)
    @GetMapping(value={"/token"})
    public ResponseEntity<BaseResponse> getToken(String server) {
        String res = this.emqxRestService.getToken(new EmqxProperties(server));
        return ObjectResponse.ok((Object)res);
    }

    @ApiOperation(value="\u65e5\u5fd7\u8ffd\u8e2a\u5217\u8868")
    @ApiOperationSupport(order=2)
    @GetMapping(value={"/log/trace"})
    public ResponseEntity<BaseResponse> logTrace(String server) {
        Object res = this.emqxRestService.logTrace(new EmqxProperties(server));
        return ObjectResponse.ok((Object)res);
    }

    @ApiOperation(value="\u4e0b\u8f7d\u8ffd\u8e2a\u65e5\u5fd7")
    @ApiOperationSupport(order=3)
    @GetMapping(value={"/download/{name}"})
    public void downloadTrace(@PathVariable String name, String server, HttpServletResponse response) throws IOException {
        response.setContentType("application/force-download");
        response.setHeader("Content-Disposition", "attachment;Filename=" + name + ".zip");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        this.emqxRestService.downloadTrace(new EmqxProperties(server), name, (OutputStream)response.getOutputStream());
    }

    @ApiOperation(value="\u521b\u5efa\u65e5\u5fd7\u8ffd\u8e2a")
    @ApiOperationSupport(order=4)
    @PostMapping(value={"/log/trace"})
    public ResponseEntity<BaseResponse> createTrace(@RequestBody LogTrace trace, String server) {
        Object res = this.emqxRestService.createTrace(new EmqxProperties(server), trace);
        return ObjectResponse.ok((Object)res);
    }

    @ApiOperation(value="\u505c\u6b62\u65e5\u5fd7\u8ffd\u8e2a")
    @ApiOperationSupport(order=5)
    @PutMapping(value={"/log/trace"})
    public ResponseEntity<BaseResponse> stopTrace(@RequestParam String trace, String server) {
        Object res = this.emqxRestService.stopTrace(new EmqxProperties(server), trace);
        return ObjectResponse.ok((Object)res);
    }

    @ApiOperation(value="\u5220\u9664\u65e5\u5fd7\u8ffd\u8e2a")
    @ApiOperationSupport(order=5)
    @DeleteMapping(value={"/log/trace"})
    public ResponseEntity<BaseResponse> removeTrace(@RequestParam String trace, String server) {
        this.emqxRestService.removeTrace(new EmqxProperties(server), trace);
        return BaseResponse.ok();
    }

    @ApiOperation(value="\u6d41\u7a0b\u89c4\u5219\u5217\u8868", notes="\u521b\u5efa\u8bbe\u5907\u4f4d\u7f6e\u5b9e\u65f6\u89c4\u5219")
    @ApiOperationSupport(order=6)
    @GetMapping(value={"/flow/rule"})
    public ResponseEntity<BaseResponse> getFlowRules(String ruleId, String server) {
        List<FlowRule> res = this.emqxRestService.existRuleById(new EmqxProperties(server), ruleId);
        return ObjectResponse.ok(res);
    }

    @ApiOperation(value="\u521b\u5efa\u6d41\u7a0b\u89c4\u5219", notes="\u521b\u5efa\u8bbe\u5907\u4f4d\u7f6e\u5b9e\u65f6\u89c4\u5219")
    @ApiOperationSupport(order=7)
    @PostMapping(value={"/flow/rule"})
    public ResponseEntity<BaseResponse> createFlowRule(@RequestBody FlowRule rule, String server) {
        Object res = this.emqxRestService.createRealRule(new EmqxProperties(server), rule);
        return ObjectResponse.ok((Object)res);
    }

    @ApiOperation(value="\u79fb\u9664\u6d41\u7a0b\u89c4\u5219", notes="\u521b\u5efa\u8bbe\u5907\u4f4d\u7f6e\u5b9e\u65f6\u89c4\u5219")
    @ApiOperationSupport(order=8)
    @DeleteMapping(value={"/flow/rule"})
    public ResponseEntity<BaseResponse> removeFlowRule(@RequestParam String rule, String server) {
        this.emqxRestService.removeFlowRule(new EmqxProperties(server), rule);
        return BaseResponse.ok();
    }
}

