/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.live.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.geoway.fczx.live.constant.LiveConstant;
import com.geoway.fczx.live.data.AssignSegmentVo;
import com.geoway.fczx.live.data.LiveRecordVo;
import com.geoway.fczx.live.data.RecordVideo;
import com.geoway.fczx.live.data.VideoAnalysis;
import com.geoway.fczx.live.data.agora.AgoraCallback;
import com.geoway.fczx.live.data.property.EmqxProperties;
import com.geoway.fczx.live.data.srs.SrsRecordCallDto;
import com.geoway.fczx.live.data.yunxin.YxRecordCallDto;
import com.geoway.fczx.live.data.yunxin.YxRecordDto;
import com.geoway.fczx.live.service.LiveRecordVideoService;
import com.geoway.ue.common.data.response.BaseResponse;
import com.geoway.ue.common.data.response.ObjectResponse;
import com.geoway.ue.common.data.response.OpRes;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u89c6\u9891\u670d\u52a1\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/api/video/v1"})
public class VideoController {
    @Resource
    private LiveRecordVideoService liveRecordVideoService;

    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u89c6\u9891")
    @ApiImplicitParam(name="jobId", value="\u4efb\u52a1\u6807\u8bc6", paramType="query", required=true)
    @ApiOperationSupport(order=1)
    @GetMapping(value={"/flight/record"})
    public ResponseEntity<BaseResponse> flightRecord(String jobId) {
        if (ObjectUtil.isEmpty((Object)jobId)) {
            return BaseResponse.error((String)"\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<RecordVideo> res = this.liveRecordVideoService.flightRecord(jobId);
        return ObjectResponse.ok(res);
    }

    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u8f68\u8ff9", notes="<h2>\u7528\u4e8e\u89c6\u9891\u4e0e\u8f68\u8ff9\u8054\u52a8</h2>")
    @ApiImplicitParams(value={@ApiImplicitParam(name="jobId", value="\u4efb\u52a1\u6807\u8bc6", paramType="query", required=true), @ApiImplicitParam(name="jobId", value="\u4efb\u52a1\u6807\u8bc6", paramType="query")})
    @ApiOperationSupport(order=2)
    @GetMapping(value={"/flight/track"})
    public ResponseEntity<BaseResponse> flightTrack(String jobId, String objectKey) {
        if (ObjectUtil.isEmpty((Object)jobId)) {
            return BaseResponse.error((String)"\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<?> res = this.liveRecordVideoService.flightTrack(jobId, objectKey);
        return ObjectResponse.ok(res);
    }

    @ApiOperation(value="\u6b63\u5728\u5f55\u5236\u5217\u8868", hidden=true)
    @ApiOperationSupport(order=3)
    @GetMapping(value={"/recording/list"})
    public ResponseEntity<BaseResponse> getRecordingList() {
        List<LiveRecordVo> list = this.liveRecordVideoService.getRecordingList();
        return ObjectResponse.ok(list);
    }

    @ApiOperation(value="\u5f00\u59cb\u89c6\u9891\u5f55\u5236")
    @ApiOperationSupport(order=4, ignoreParameters={"ifsaddress", "target"})
    @PostMapping(value={"/record/start"})
    public ResponseEntity<BaseResponse> startVideoRecord(@RequestBody YxRecordDto data) {
        if (data == null || ObjectUtil.isEmpty((Object)data.getDeviceSn())) {
            return BaseResponse.error((String)"\u8bbe\u5907SN\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OpRes<LiveRecordVo> res = this.liveRecordVideoService.startVideoRecord(data);
        return res.isOpRes() ? ObjectResponse.ok((Object)res.getData()) : BaseResponse.error((String)res.getErrorDesc());
    }

    @ApiOperation(value="\u7ed3\u675f\u89c6\u9891\u5f55\u5236")
    @ApiOperationSupport(order=5, ignoreParameters={"duration", "format", "filename", "tsNameTemplate"})
    @PostMapping(value={"/record/stop"})
    public ResponseEntity<BaseResponse> stopVideoRecord(@RequestBody YxRecordDto data) {
        if (data == null || ObjectUtil.isEmpty((Object)data.getDeviceSn())) {
            return BaseResponse.error((String)"\u8bbe\u5907SN\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OpRes<Object> res = this.liveRecordVideoService.stopVideoRecord(data);
        return res.isOpRes() ? ObjectResponse.ok((Object)res.getData()) : BaseResponse.error((String)res.getErrorDesc());
    }

    @ApiOperation(value="\u4e91\u4fe1\u5f55\u5236\u56de\u8c03", notes="<h2>\u8be5\u63a5\u53e3\u4ec5\u4f5c\u4e3a\u4e91\u4fe1\u5f55\u5236\u56de\u8c03\u4f7f\u7528</h2>")
    @ApiOperationSupport(order=6)
    @PostMapping(value={"/yx/record/callback"})
    public ResponseEntity<BaseResponse> yxDvrCall(@RequestBody YxRecordCallDto data) {
        if (!ObjectUtil.isAllNotEmpty((Object[])new Object[]{data, data.getVideo_name(), data.getNId(), data.getCid(), data.getOrigUrl()})) {
            return BaseResponse.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OpRes<Object> res = this.liveRecordVideoService.videoRecordCall(data);
        return res.isOpRes() ? BaseResponse.ok() : BaseResponse.error((String)res.getErrorDesc());
    }

    @ApiOperation(value="SRS\u5f55\u5236\u56de\u8c03", notes="<h2>\u8be5\u63a5\u53e3\u4ec5\u4f5c\u4e3aSRS\u5f55\u5236\u56de\u8c03\u4f7f\u7528</h2>")
    @ApiOperationSupport(order=7)
    @PostMapping(value={"/srs/record/callback"})
    public ResponseEntity<BaseResponse> srsDvrCall(@RequestBody SrsRecordCallDto data) {
        System.out.println("\u53c2\u6570\u4fe1\u606f" + JSONUtil.toJsonStr((Object)data));
        OpRes<Object> res = this.liveRecordVideoService.videoRecordCall(data);
        return BaseResponse.ok();
    }

    @ApiOperation(value="\u58f0\u7f51\u5f55\u5236\u56de\u8c03", notes="<h2>\u8be5\u63a5\u53e3\u4ec5\u4f5c\u4e3a\u58f0\u7f51\u5f55\u5236\u56de\u8c03\u4f7f\u7528</h2>")
    @ApiOperationSupport(order=8)
    @PostMapping(value={"/agora/record/callback"})
    public ResponseEntity<BaseResponse> agoraDvrCall(@RequestBody AgoraCallback data) {
        System.out.println("\u58f0\u7f51\u53c2\u6570\u4fe1\u606f" + JSONUtil.toJsonStr((Object)data));
        if (ObjectUtil.equal((Object)data.getEventType(), (Object)LiveConstant.AGORA_CALL_ACTION)) {
            OpRes<Object> opRes = this.liveRecordVideoService.videoRecordCall(data);
        }
        return BaseResponse.ok();
    }

    @ApiOperation(value="\u6b63\u5728\u89e3\u6790\u5217\u8868", hidden=true)
    @ApiOperationSupport(order=8)
    @GetMapping(value={"/analysis/list"})
    public ResponseEntity<BaseResponse> getAnalysisList() {
        List<?> list = this.liveRecordVideoService.getAnalysisList();
        return ObjectResponse.ok(list);
    }

    @ApiOperation(value="\u5f00\u59cb\u89e3\u6790\u89c6\u9891", notes="AI\u89e3\u8bd1")
    @ApiOperationSupport(order=9)
    @PostMapping(value={"/analysis/start"})
    public ResponseEntity<BaseResponse> analysisStart(@RequestBody VideoAnalysis data) {
        if (data == null || ObjectUtil.isEmpty((Object)data.getDockSn())) {
            return BaseResponse.error((String)"\u8bbe\u5907SN\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty(data.getTarget())) {
            return BaseResponse.error((String)"\u76ee\u6807\u8bc6\u522b\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OpRes<Object> res = this.liveRecordVideoService.analysisStart(data);
        return res.isOpRes() ? ObjectResponse.ok((Object)res.getData()) : BaseResponse.error((String)res.getErrorDesc());
    }

    @ApiOperation(value="\u7ed3\u675f\u89e3\u6790\u89c6\u9891", notes="AI\u89e3\u8bd1")
    @ApiOperationSupport(order=10)
    @PostMapping(value={"/analysis/stop"})
    public ResponseEntity<BaseResponse> analysisStop(@RequestBody VideoAnalysis data) {
        if (data == null || ObjectUtil.isEmpty((Object)data.getDockSn())) {
            return BaseResponse.error((String)"\u8bbe\u5907SN\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OpRes<Object> res = this.liveRecordVideoService.analysisStop(data);
        return res.isOpRes() ? BaseResponse.ok() : BaseResponse.error((String)res.getErrorDesc());
    }

    @ApiOperation(value="\u5f00\u59cb\u8f68\u8ff9\u91c7\u96c6")
    @ApiOperationSupport(order=11)
    @PostMapping(value={"/track/start"})
    public ResponseEntity<BaseResponse> startTrackGather(@RequestBody EmqxProperties config, String jobId, String videoId, String droneSn) {
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{jobId, droneSn})) {
            boolean flag = this.liveRecordVideoService.startRealLocRecord(config, videoId, jobId, droneSn);
            return ObjectResponse.ok((Object)flag);
        }
        return BaseResponse.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @ApiOperation(value="\u7ed3\u675f\u8f68\u8ff9\u91c7\u96c6")
    @ApiOperationSupport(order=12)
    @PostMapping(value={"/track/stop"})
    public ResponseEntity<BaseResponse> stopTrackGather(@RequestBody EmqxProperties config, @RequestParam String droneSn) {
        if (ObjectUtil.isEmpty((Object)droneSn)) {
            return BaseResponse.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.liveRecordVideoService.stopRealLocRecord(config, droneSn, null);
        return BaseResponse.ok();
    }

    @ApiOperation(value="\u89c6\u9891\u6307\u5b9a\u622a\u53d6")
    @ApiOperationSupport(order=13)
    @PostMapping(value={"/assign/segment"})
    public void assignSegment(@RequestBody AssignSegmentVo param, HttpServletResponse response) {
        this.liveRecordVideoService.assignSegment(param, response);
    }
}

