/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.live.data;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.geoway.fczx.live.enmus.AnalysisModelType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@ApiModel(value="\u89c6\u9891\u5206\u6790\u53c2\u6570\u5b9e\u4f53\u7c7b")
public class VideoAnalysis {
    @ApiModelProperty(value="\u673a\u573a\u8bbe\u5907SN", required=true)
    private String dockSn;
    @ApiModelProperty(value="\u98de\u673a\u8bbe\u5907SN", hidden=true)
    private String droneSn;
    @ApiModelProperty(value="\u4efb\u52a1\u6807\u8bc6", hidden=true)
    private String jobId;
    @ApiModelProperty(value="\u89c6\u9891\u6d41\u5730\u5740", notes="\u53ef\u4ee5\u662f\u5728\u7ebf\u89c6\u9891\u6d41\u548c\u79bb\u7ebfmp4", hidden=true)
    private String ifsaddress;
    @ApiModelProperty(value="\u6d41\u5a92\u4f53\u670d\u52a1", hidden=true)
    private String ofsaddress;
    @ApiModelProperty(value="\u8bc6\u522b\u9608\u503c", hidden=true)
    private Float thresthod;
    @ApiModelProperty(value="\u76ee\u6807\u8bc6\u522b\u7c7b\u578b,\u76ee\u524d\u6709 water,gongchengche,tuiduitu\u4e09\u7c7b", notes="\u5fc5\u987b\u8ddfffmpeg\\bin\\config\\ Interpret_param.json\u4e2d\u7684\u4fdd\u6301\u4e00\u81f4", required=true)
    private List<String> target;

    public VideoAnalysis(String dockSn, String jobId, List<String> target) {
        this.dockSn = dockSn;
        this.jobId = jobId;
        this.target = target;
    }

    public VideoAnalysis(String dockSn) {
        this.dockSn = dockSn;
    }

    public Map<String, Object> convertMap() {
        this.checkAiType();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", this.droneSn);
        map.put("ifsaddress", this.ifsaddress);
        map.put("ofsaddress", this.ofsaddress);
        ArrayList list = new ArrayList();
        this.target.forEach(type -> {
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("target", AnalysisModelType.byName(type).getGeoway());
            list.add(item);
        });
        map.put("Interpret_param", list);
        return map;
    }

    public Map<String, Object> converCmlcMap() {
        this.checkAiType();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Map> request = new HashMap<String, Map>();
        HashMap<String, Object> reference = new HashMap<String, Object>();
        map.put("plugin_task_id", this.droneSn);
        map.put("plugin_args", "116");
        map.put("request", request);
        request.put("input", MapUtil.builder().put((Object)"rtmp", (Object)this.ifsaddress).build());
        request.put("output", MapUtil.builder().put((Object)"rtmp", (Object)this.ofsaddress).build());
        request.put("reference", reference);
        reference.put("model", AnalysisModelType.byName(this.target.get(0)).getCmlc());
        reference.put("promt", AnalysisModelType.byName(this.target.get(0)).getCmlc());
        reference.put("thresthod", this.thresthod);
        reference.put("pixel_w", 1920);
        reference.put("pixel_h", 1440);
        reference.put("ai_type", Collections.singletonList("vehicle"));
        reference.put("plugin_args", 116);
        return map;
    }

    private void checkAiType() {
        this.target.forEach(type -> {
            AnalysisModelType model = AnalysisModelType.byName(type);
            if (ObjectUtil.isEmpty((Object)model.getGeoway())) {
                throw new RuntimeException("\u672a\u77e5AI\u8bc6\u522b\u7c7b\u578b");
            }
        });
    }

    public String getDockSn() {
        return this.dockSn;
    }

    public String getDroneSn() {
        return this.droneSn;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getIfsaddress() {
        return this.ifsaddress;
    }

    public String getOfsaddress() {
        return this.ofsaddress;
    }

    public Float getThresthod() {
        return this.thresthod;
    }

    public List<String> getTarget() {
        return this.target;
    }

    public void setDockSn(String dockSn) {
        this.dockSn = dockSn;
    }

    public void setDroneSn(String droneSn) {
        this.droneSn = droneSn;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public void setIfsaddress(String ifsaddress) {
        this.ifsaddress = ifsaddress;
    }

    public void setOfsaddress(String ofsaddress) {
        this.ofsaddress = ofsaddress;
    }

    public void setThresthod(Float thresthod) {
        this.thresthod = thresthod;
    }

    public void setTarget(List<String> target) {
        this.target = target;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VideoAnalysis)) {
            return false;
        }
        VideoAnalysis other = (VideoAnalysis)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Float this$thresthod = this.getThresthod();
        Float other$thresthod = other.getThresthod();
        if (this$thresthod == null ? other$thresthod != null : !((Object)this$thresthod).equals(other$thresthod)) {
            return false;
        }
        String this$dockSn = this.getDockSn();
        String other$dockSn = other.getDockSn();
        if (this$dockSn == null ? other$dockSn != null : !this$dockSn.equals(other$dockSn)) {
            return false;
        }
        String this$droneSn = this.getDroneSn();
        String other$droneSn = other.getDroneSn();
        if (this$droneSn == null ? other$droneSn != null : !this$droneSn.equals(other$droneSn)) {
            return false;
        }
        String this$jobId = this.getJobId();
        String other$jobId = other.getJobId();
        if (this$jobId == null ? other$jobId != null : !this$jobId.equals(other$jobId)) {
            return false;
        }
        String this$ifsaddress = this.getIfsaddress();
        String other$ifsaddress = other.getIfsaddress();
        if (this$ifsaddress == null ? other$ifsaddress != null : !this$ifsaddress.equals(other$ifsaddress)) {
            return false;
        }
        String this$ofsaddress = this.getOfsaddress();
        String other$ofsaddress = other.getOfsaddress();
        if (this$ofsaddress == null ? other$ofsaddress != null : !this$ofsaddress.equals(other$ofsaddress)) {
            return false;
        }
        List<String> this$target = this.getTarget();
        List<String> other$target = other.getTarget();
        return !(this$target == null ? other$target != null : !((Object)this$target).equals(other$target));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VideoAnalysis;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Float $thresthod = this.getThresthod();
        result = result * 59 + ($thresthod == null ? 43 : ((Object)$thresthod).hashCode());
        String $dockSn = this.getDockSn();
        result = result * 59 + ($dockSn == null ? 43 : $dockSn.hashCode());
        String $droneSn = this.getDroneSn();
        result = result * 59 + ($droneSn == null ? 43 : $droneSn.hashCode());
        String $jobId = this.getJobId();
        result = result * 59 + ($jobId == null ? 43 : $jobId.hashCode());
        String $ifsaddress = this.getIfsaddress();
        result = result * 59 + ($ifsaddress == null ? 43 : $ifsaddress.hashCode());
        String $ofsaddress = this.getOfsaddress();
        result = result * 59 + ($ofsaddress == null ? 43 : $ofsaddress.hashCode());
        List<String> $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : ((Object)$target).hashCode());
        return result;
    }

    public String toString() {
        return "VideoAnalysis(dockSn=" + this.getDockSn() + ", droneSn=" + this.getDroneSn() + ", jobId=" + this.getJobId() + ", ifsaddress=" + this.getIfsaddress() + ", ofsaddress=" + this.getOfsaddress() + ", thresthod=" + this.getThresthod() + ", target=" + this.getTarget() + ")";
    }

    public VideoAnalysis() {
    }

    public VideoAnalysis(String dockSn, String droneSn, String jobId, String ifsaddress, String ofsaddress, Float thresthod, List<String> target) {
        this.dockSn = dockSn;
        this.droneSn = droneSn;
        this.jobId = jobId;
        this.ifsaddress = ifsaddress;
        this.ofsaddress = ofsaddress;
        this.thresthod = thresthod;
        this.target = target;
    }
}

