/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.live.handler;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.geoway.fczx.live.data.LiveRecordVo;
import com.geoway.fczx.live.data.property.LiveApiProperties;
import com.geoway.fczx.live.data.yunxin.YxChannel;
import com.geoway.fczx.live.enmus.LiveProvider;
import com.geoway.fczx.live.service.LiveRecordFileService;
import com.geoway.fczx.live.service.LiveRecordRedisService;
import com.geoway.fczx.live.thirdapi.agora.AgoraRestService;
import com.geoway.fczx.live.util.FczxLiveTool;
import com.geoway.fczx.live.util.FfmpegTool;
import com.geoway.ue.common.util.SpringTool;
import io.agora.recording.Recording;
import io.agora.recording.RecordingSDK;
import io.agora.recording.common.Common;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiveRecordThreadHandler
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(LiveRecordThreadHandler.class);
    private static LiveRecordFileService attachService = (LiveRecordFileService)SpringTool.getBean(LiveRecordFileService.class);
    private static LiveRecordRedisService redisService = (LiveRecordRedisService)SpringTool.getBean(LiveRecordRedisService.class);
    private static AgoraRestService agoraRestService = (AgoraRestService)SpringTool.getBean(AgoraRestService.class);
    private static LiveApiProperties liveApiProperties = (LiveApiProperties)SpringTool.getBean(LiveApiProperties.class);
    private String type = "ffmpeg";
    private String aircraftSn;
    private String flightId;
    private Integer expire;
    private String prefix;
    private String output;
    private String outputDir;
    private Date time;
    private Map<String, String> meta;
    private boolean finish = false;

    public LiveRecordThreadHandler(LiveRecordVo live, String prefix, Integer expire) {
        String name = live + "_" + live.getRecordTime().getTime() + ".mp4";
        this.outputDir = System.getProperty("user.dir").concat("/").concat("output");
        FileUtil.mkdir((String)this.outputDir);
        this.output = this.outputDir.concat("/").concat(name);
        this.aircraftSn = live.getAircraftSn();
        this.flightId = live.getBizId();
        this.time = live.getRecordTime();
        this.prefix = prefix;
        this.expire = expire;
        this.meta = new HashMap<String, String>();
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void run() {
        try {
            log.info("{} \u5f00\u59cb\u672c\u5730\u89c6\u9891\u5f55\u5236", (Object)this.aircraftSn);
            this.obtainLiveToMp4();
        }
        catch (Exception e) {
            log.error("{}\u89c6\u9891\u5f55\u5236\u5931\u8d25", (Object)this.aircraftSn, (Object)e);
            return;
        }
        try {
            this.uploadMp4ToStore();
        }
        catch (Exception e) {
            log.error("\u89c6\u9891{}\u63a8\u9001obs\u5931\u8d25", (Object)this.output, (Object)e);
        }
        finally {
            FileUtil.del((String)this.outputDir);
        }
    }

    private void obtainLiveToMp4() {
        YxChannel live = redisService.getBean("rtmp:" + this.aircraftSn, YxChannel.class);
        if (ObjectUtil.equal((Object)LiveProvider.agora.getType(), (Object)this.type)) {
            if (ObjectUtil.isEmpty((Object)live)) {
                log.error("\u672a\u627e\u5230{}\u8bbe\u5907\u63a8\u6d41\u4fe1\u606f", (Object)this.aircraftSn);
                return;
            }
        } else if (ObjectUtil.hasEmpty((Object[])new Object[]{live, live.getHttpPullUrl()})) {
            log.error("\u672a\u627e\u5230{}\u8bbe\u5907\u63a8\u6d41\u4fe1\u606f", (Object)this.aircraftSn);
            return;
        }
        ThreadUtil.safeSleep((long)1000L);
        if (!redisService.checkExist("record:" + this.aircraftSn)) {
            LiveRecordVo liveParam = new LiveRecordVo(this.flightId, this.aircraftSn, new Date());
            redisService.setWithExpire("record:" + this.aircraftSn, JSONUtil.toJsonStr((Object)liveParam), this.expire.intValue());
        }
        if (ObjectUtil.equal((Object)LiveProvider.agora.getType(), (Object)this.type)) {
            RecordingSDK RecordingSdk = new RecordingSDK();
            Recording ars = new Recording(RecordingSdk);
            try {
                String appId = liveApiProperties.getAppId();
                String name = this.aircraftSn;
                String uid = liveApiProperties.getUid();
                String appliteDir = liveApiProperties.getAppliteDir();
                String token = agoraRestService.makeToken(name, uid);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("--logLevel", "3");
                params.put("--appId", appId);
                params.put("--channelKey", token);
                params.put("--channel", name);
                params.put("--uid", uid);
                params.put("--channelProfile", String.valueOf(Common.CHANNEL_PROFILE_TYPE.CHANNEL_PROFILE_LIVE_BROADCASTING.getValue()));
                params.put("--appliteDir", appliteDir);
                params.put("--lowUdpPort", "40000");
                params.put("--highUdpPort", "40030");
                params.put("--recordFileRootDir", this.outputDir);
                params.put("--mixResolution", liveApiProperties.getMixResolution());
                params.put("--isMixingEnabled", "1");
                params.put("--mixedVideoAudio", String.valueOf(Common.MIXED_AV_CODEC_TYPE.AV_CODEC_MIXED_TS_AND_MP4.getValue()));
                String enableCloudProxy = String.valueOf(liveApiProperties.getEnableCloudProxy());
                params.put("--enableCloudProxy", enableCloudProxy);
                if ("1".equals(enableCloudProxy)) {
                    params.put("--proxyType", String.valueOf(liveApiProperties.getProxyType()));
                    params.put("--proxyServer", liveApiProperties.getProxyServer());
                }
                ThreadUtil.execute(() -> ars.createChannel(params));
                while (redisService.checkExist("record:" + this.aircraftSn)) {
                    ThreadUtil.sleep((long)500L);
                    if (!StrUtil.isNotEmpty((CharSequence)ars.errorMsg)) continue;
                    log.error("\u5f55\u5236\u5f02\u5e38!");
                    throw new RuntimeException(ars.errorMsg);
                }
                ars.finishRecordTime = System.currentTimeMillis();
                this.meta.put("startrecordtime", String.valueOf(ars.startRecordTime));
                this.meta.put("duration", String.valueOf(ars.finishRecordTime - ars.startRecordTime));
                this.outputDir = ars.storageDir;
                log.info("\u89c6\u9891\u5f55\u5236\u5b8c\u6210 : " + this.outputDir);
                ars.leaveChannel();
                ars.unRegister();
                for (int count = 0; !ars.finish && count <= 20; ++count) {
                    ThreadUtil.sleep((long)500L);
                }
            }
            catch (Error | Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    ars.leaveChannel();
                }
                catch (Exception exception) {}
                try {
                    ars.unRegister();
                }
                catch (Exception exception) {}
            }
        }
        FfmpegTool.obtainLiveToMp4(live.getHttpPullUrl(), this.output, () -> redisService.checkExist("record:" + this.aircraftSn));
    }

    private void uploadMp4ToStore() {
        log.info("\u7ed3\u675f\u89c6\u9891\u5f55\u5236");
        if (ObjectUtil.equal((Object)LiveProvider.agora.getType(), (Object)this.type)) {
            List files = FileUtil.loopFiles((String)this.outputDir, f -> FileUtil.getSuffix((File)f).equals("mp4"));
            if (files.isEmpty()) {
                throw new RuntimeException("\u76ee\u5f55[" + this.outputDir + "]\u672a\u627e\u5230\u5f55\u5236\u6587\u4ef6");
            }
            this.output = ((File)files.get(0)).getAbsolutePath();
        }
        log.info("\u5f00\u59cb\u4e0a\u4f20 : " + this.output);
        String objectKey = FczxLiveTool.buildLiveRecordRes(this.flightId, this.prefix, this.time);
        attachService.saveAttachToStore(this.output, objectKey, this.meta);
        log.info("MP4\u6587\u4ef6\u5df2\u4e0a\u4f20 : " + this.output);
        attachService.createScreenshot(objectKey);
        if (redisService.checkExist("record:" + this.aircraftSn)) {
            redisService.del("record:" + this.aircraftSn);
        }
    }

    public LiveRecordThreadHandler(String type, String aircraftSn, String flightId, Integer expire, String prefix, String output, String outputDir, Date time, Map<String, String> meta, boolean finish) {
        this.type = type;
        this.aircraftSn = aircraftSn;
        this.flightId = flightId;
        this.expire = expire;
        this.prefix = prefix;
        this.output = output;
        this.outputDir = outputDir;
        this.time = time;
        this.meta = meta;
        this.finish = finish;
    }
}

