/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.live.service;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ZipUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.geoway.fczx.live.data.AssignSegmentVo;
import com.geoway.fczx.live.data.BaseTrackInfo;
import com.geoway.fczx.live.data.LiveRecordVo;
import com.geoway.fczx.live.data.RecordVideo;
import com.geoway.fczx.live.data.VideoAnalysis;
import com.geoway.fczx.live.data.mqtt.FlowRule;
import com.geoway.fczx.live.data.mqtt.LogTrace;
import com.geoway.fczx.live.data.property.AnalysisApiProperties;
import com.geoway.fczx.live.data.property.EmqxProperties;
import com.geoway.fczx.live.data.property.HuaweiObsProperties;
import com.geoway.fczx.live.data.property.LiveApiProperties;
import com.geoway.fczx.live.data.yunxin.YxChannel;
import com.geoway.fczx.live.data.yunxin.YxRecordDto;
import com.geoway.fczx.live.handler.AbstractAnalysisHandler;
import com.geoway.fczx.live.handler.AbstractLiveHandler;
import com.geoway.fczx.live.handler.AbstractStoreHandler;
import com.geoway.fczx.live.handler.LiveRecordAfterHandler;
import com.geoway.fczx.live.service.LiveRecordRedisService;
import com.geoway.fczx.live.thirdapi.emqx.EmqxRestService;
import com.geoway.fczx.live.util.FczxLiveTool;
import com.geoway.fczx.live.util.FfmpegTool;
import com.geoway.ue.common.data.response.BaseResponse;
import com.geoway.ue.common.data.response.OpRes;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LiveRecordVideoService {
    private static final Logger log = LoggerFactory.getLogger(LiveRecordVideoService.class);
    @Resource
    private EmqxRestService emqxRestService;
    @Resource
    private AbstractLiveHandler liveService;
    @Resource
    private LiveApiProperties liveProperties;
    @Resource
    private HuaweiObsProperties obsProperties;
    @Resource
    private AbstractStoreHandler storeHandler;
    @Autowired(required=false)
    private LiveRecordAfterHandler afterHandler;
    @Resource
    private LiveRecordRedisService redisService;
    @Resource
    private AbstractAnalysisHandler analysisService;
    @Resource
    private AnalysisApiProperties analysisProperties;

    public List<LiveRecordVo> getRecordingList() {
        ArrayList<LiveRecordVo> list = new ArrayList<LiveRecordVo>();
        this.redisService.getAllKeys("record:".concat("*")).forEach(air -> list.add(this.redisService.getBean("record:".concat((String)air), LiveRecordVo.class)));
        return list;
    }

    private OpRes<String> checkDeviceLiveStatus(String dockSn) {
        if (!this.redisService.checkExist("online:" + dockSn)) {
            return new OpRes("\u673a\u573a\u79bb\u7ebf\u65e0\u6cd5\u8fdb\u884c\u89c6\u9891\u5f55\u5236", null, false);
        }
        JSONObject dock = this.redisService.getBean("online:" + dockSn, JSONObject.class);
        String droneSn = dock.getStr((Object)"child_device_sn");
        if (!this.redisService.checkExist("online:" + droneSn)) {
            return new OpRes("\u98de\u673a\u79bb\u7ebf\u65e0\u6cd5\u8fdb\u884c\u89c6\u9891\u5f55\u5236", (Object)droneSn, false);
        }
        Integer domain = (Integer)dock.getByPath("children.domain", Integer.class);
        if (ObjectUtil.notEqual((Object)domain, (Object)0)) {
            return new OpRes("\u975e\u98de\u884c\u8bbe\u5907\u4e0d\u8fdb\u884c\u89c6\u9891\u5f55\u5236", (Object)droneSn, false);
        }
        if (!this.redisService.checkExist("rtmp:" + droneSn)) {
            return new OpRes("\u8bbe\u5907\u672a\u5f00\u542f\u76f4\u64ad\u65e0\u6cd5\u8fdb\u884c\u89c6\u9891\u5f55\u5236", (Object)droneSn, false);
        }
        if (this.redisService.checkExist("record:" + droneSn)) {
            return new OpRes("\u8bbe\u5907\u6b63\u5728\u5f55\u5236\u4e2d", (Object)droneSn, false);
        }
        return new OpRes("", (Object)droneSn, true);
    }

    public OpRes<LiveRecordVo> startVideoRecord(YxRecordDto data) {
        List vid;
        log.info("\u8bbe\u5907\u5f00\u59cb\u5f55\u5236{}", (Object)data);
        OpRes<String> status = this.checkDeviceLiveStatus(data.getDeviceSn());
        if (!status.isOpRes()) {
            log.error(status.getErrorDesc());
            return new OpRes(status.getErrorDesc(), null, false);
        }
        data.setDroneSn((String)status.getData());
        JSONObject payload = this.redisService.getBean("rtmp:" + data.getDroneSn(), JSONObject.class);
        if (payload.containsKey((Object)"video_id") && (vid = payload.getBeanList((Object)"video_id", String.class)) != null && vid.size() == 2) {
            String vId = ((String)vid.get(1)).split("/")[1];
            this.startRealLocRecord(data.getProperties(), vId, data.getFilename(), data.getDroneSn());
        }
        return this.liveService.startVideoRecord(data);
    }

    public OpRes<Object> stopVideoRecord(YxRecordDto data) {
        log.debug("\u505c\u6b62\u5f55\u5236{}", (Object)data);
        String deviceSn = data.getDeviceSn();
        OpRes<String> status = this.checkDeviceLiveStatus(deviceSn);
        if (ObjectUtil.isEmpty((Object)status.getData())) {
            return new OpRes("\u672a\u627e\u5230\u8bbe\u5907\u4fe1\u606f", null, false);
        }
        this.afterHandler.stopDeviceAllLive(deviceSn);
        data.setDroneSn((String)status.getData());
        this.stopRealLocRecord(data.getProperties(), data.getDroneSn(), null);
        try {
            this.analysisStop(new VideoAnalysis(data.getDeviceSn()));
        }
        catch (Exception e) {
            log.error("\u5173\u95edAI\u5206\u6790\u5f02\u5e38", (Throwable)e);
        }
        return this.liveService.stopVideoRecord(data);
    }

    public boolean startRealLocRecord(EmqxProperties setting, String payloadIndex, String jobId, String droneSn) {
        log.debug("\u8bbe\u5907{}\u5b9e\u65f6\u4f4d\u7f6e\u4fe1\u606f\u91c7\u96c6{}", (Object)jobId, (Object)droneSn);
        if (this.redisService.checkExist("gather:" + droneSn)) {
            log.warn("\u5f53\u524d\u8bbe\u5907\u6b63\u5728\u91c7\u96c6\u8f68\u8ff9");
            return true;
        }
        String ruleId = "real_loc_" + droneSn;
        List<FlowRule> rules = this.emqxRestService.existRuleById(setting, ruleId);
        if (rules != null && !rules.isEmpty()) {
            if (ObjectUtil.notEqual((Object)jobId, (Object)rules.get(0).getDescription())) {
                this.stopRealLocRecord(setting, droneSn, rules.get(0).getDescription());
            } else {
                return true;
            }
        }
        LogTrace trace = LogTrace.simpleLogTrace(droneSn, jobId, this.liveProperties.getMaxPushDuration());
        FlowRule rule = FlowRule.simpleFlowRule(payloadIndex, droneSn, jobId, ruleId);
        boolean flag = ObjectUtil.isNotEmpty((Object)this.emqxRestService.createTrace(setting, trace));
        if (flag) {
            boolean res = ObjectUtil.isNotEmpty((Object)this.emqxRestService.createRealRule(setting, rule));
            if (res) {
                this.redisService.setWithExpire("gather:" + droneSn, jobId, this.liveProperties.getMaxPushDuration().intValue());
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRealLocRecord(EmqxProperties setting, String droneSn, String ruleJobId) {
        String jobId = null;
        if (ObjectUtil.isEmpty((Object)ruleJobId)) {
            if (!this.redisService.checkExist("gather:" + droneSn)) {
                log.warn("\u5f53\u524d\u8bbe\u5907\u672a\u91c7\u96c6\u8f68\u8ff9\uff0c\u65e0\u9700\u505c\u6b62");
                return;
            }
            jobId = this.redisService.get("gather:" + droneSn);
        } else {
            jobId = ruleJobId;
        }
        if (ObjectUtil.isEmpty((Object)jobId)) {
            log.error("\u4efb\u52a1{}\u4fe1\u606f\u672a\u627e\u5230{}", (Object)droneSn, (Object)jobId);
            return;
        }
        String trace = "trace" + jobId;
        String name = "track" + System.currentTimeMillis() + ".track";
        String base = System.getProperty("user.dir") + "/" + IdUtil.fastSimpleUUID() + ".zip";
        String newName = System.getProperty("user.dir") + "/" + IdUtil.fastSimpleUUID() + ".track";
        String objectKey = String.join((CharSequence)"/", this.obsProperties.getObjectDirPrefix(), jobId, name);
        try {
            String line;
            if (!FileUtil.exist((String)base)) {
                FileUtil.newFile((String)base);
            }
            if (!FileUtil.exist((String)newName)) {
                FileUtil.newFile((String)newName);
            }
            this.emqxRestService.removeFlowRule(setting, "real_loc_" + droneSn);
            this.emqxRestService.stopTrace(setting, trace);
            this.emqxRestService.downloadTrace(setting, trace, FileUtil.getOutputStream((String)base));
            File file = ZipUtil.unzip((String)base);
            BufferedReader reader = new BufferedReader(new FileReader(Objects.requireNonNull(file.listFiles())[0]));
            while ((line = reader.readLine()) != null) {
                String data;
                if (!line.contains("republish_message") || !ObjectUtil.isNotEmpty((Object)(data = line.substring(line.indexOf("payload:") + 8))) || data.contains("undefined")) continue;
                FileUtil.appendUtf8Lines(Collections.singletonList(data), (String)newName);
            }
            IoUtil.close((Closeable)reader);
            this.emqxRestService.removeTrace(setting, trace);
            this.storeHandler.putObject(this.obsProperties.getBucket(), objectKey, FileUtil.getInputStream((String)newName));
            this.redisService.del("gather:" + droneSn);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        finally {
            FileUtil.del((String)base.substring(0, base.length() - 4));
            FileUtil.del((String)newName);
            FileUtil.del((String)base);
        }
    }

    public OpRes<Object> videoRecordCall(Object data) {
        OpRes<JSONObject> flag = this.liveService.saveVideoRecord(data);
        if (flag.isOpRes() && this.afterHandler != null) {
            this.afterHandler.saveMediaFileInfo((JSONObject)flag.getData());
        }
        return new OpRes(flag.getErrorDesc(), (Object)flag.isOpRes(), flag.isOpRes());
    }

    private OpRes<String> checkDeviceAnalysisStatus(String dockSn) {
        if (!this.redisService.checkExist("online:" + dockSn)) {
            return new OpRes("\u673a\u573a\u79bb\u7ebf\u65e0\u6cd5\u8fdb\u884c\u89c6\u9891\u89e3\u6790", null, false);
        }
        JSONObject dock = this.redisService.getBean("online:" + dockSn, JSONObject.class);
        String droneSn = dock.getStr((Object)"child_device_sn");
        if (!this.redisService.checkExist("online:" + droneSn)) {
            return new OpRes("\u98de\u673a\u79bb\u7ebf\u65e0\u6cd5\u8fdb\u884c\u89c6\u9891\u89e3\u6790", (Object)droneSn, false);
        }
        Integer domain = (Integer)dock.getByPath("children.domain", Integer.class);
        if (ObjectUtil.notEqual((Object)domain, (Object)0)) {
            return new OpRes("\u975e\u98de\u884c\u8bbe\u5907\u4e0d\u8fdb\u884c\u89c6\u9891\u89e3\u6790", (Object)droneSn, false);
        }
        return new OpRes("", (Object)droneSn, true);
    }

    public List<?> getAnalysisList() {
        return this.analysisService.getTaskList(this.analysisProperties.getServerUrl(), MapUtil.empty());
    }

    public OpRes<Object> analysisStart(VideoAnalysis data) {
        OpRes<Boolean> flag;
        OpRes<String> status = this.checkDeviceAnalysisStatus(data.getDockSn());
        if (!status.isOpRes()) {
            return new OpRes(status.getErrorDesc(), null, false);
        }
        data.setDroneSn((String)status.getData());
        if (!this.redisService.checkExist("rtmp:" + data.getDroneSn())) {
            return new OpRes("\u8bbe\u5907\u672a\u5f00\u542f\u76f4\u64ad\u65e0\u6cd5\u8fdb\u884c\u89c6\u9891\u89e3\u6790", (Object)data.getDroneSn(), false);
        }
        String key = "rtmpai:" + data.getDroneSn();
        if (this.redisService.checkExist(key)) {
            log.error("\u5df2\u7ecf\u5f00\u59cbAI\u8bc6\u522b\u5206\u6790");
            YxChannel channel = this.redisService.getBean(key, YxChannel.class);
            return new OpRes("\u5df2\u7ecf\u5f00\u59cbAI\u8bc6\u522b\u5206\u6790", (Object)channel, true);
        }
        OpRes<String> pullUrl = this.liveService.getLivePullUrl(data.getDroneSn());
        if (!pullUrl.isOpRes()) {
            return new OpRes(pullUrl.getErrorDesc(), null, false);
        }
        data.setIfsaddress((String)pullUrl.getData());
        YxChannel analysis = this.liveService.openAiLiveStream(data.getDroneSn(), this.liveProperties.getMaxPushDuration(), null);
        if (analysis == null) {
            log.error("\u8bbe\u5907{}\u65e0\u6cd5\u6253\u5f00AI\u5206\u6790\u6d41\u5a92\u4f53\u670d\u52a1", (Object)data.getDroneSn());
            return new OpRes("\u8bbe\u5907\u65e0\u6cd5\u6253\u5f00AI\u5206\u6790\u6d41\u5a92\u4f53\u670d\u52a1", null, false);
        }
        data.setOfsaddress(analysis.getPushUrl());
        if (ObjectUtil.isEmpty((Object)data.getThresthod())) {
            data.setThresthod(this.analysisProperties.getThresthod());
        }
        if (!((Boolean)(flag = this.analysisService.analysisVideoStart(this.analysisProperties.getServerUrl(), data)).getData()).booleanValue()) {
            return new OpRes(flag.getErrorDesc(), null, false);
        }
        return new OpRes(null, (Object)analysis, true);
    }

    public OpRes<Object> analysisStop(VideoAnalysis data) {
        OpRes<String> status = this.checkDeviceAnalysisStatus(data.getDockSn());
        if (ObjectUtil.isEmpty((Object)status.getData())) {
            return new OpRes("\u672a\u627e\u5230\u8bbe\u5907\u4fe1\u606f", null, false);
        }
        data.setDroneSn((String)status.getData());
        String key = "rtmpai:" + data.getDroneSn();
        if (!this.redisService.checkExist(key)) {
            log.error("\u8bbe\u5907{}\u672a\u8fdb\u884cAI\u8bc6\u522b\u5206\u6790\uff0c\u65e0\u9700\u5173\u95ed", (Object)data.getDroneSn());
            this.analysisService.analysisVideoStop(this.analysisProperties.getServerUrl(), data);
            return new OpRes("\u8bbe\u5907\u672a\u8fdb\u884cAI\u8bc6\u522b\u5206\u6790", null, false);
        }
        OpRes<Boolean> flag = this.liveService.removeAiLiveStream(data.getDroneSn());
        if (!flag.isOpRes()) {
            log.error("\u7ed3\u675fAI\u8bc6\u522b\u5206\u6790\u65c1\u8def\u63a8\u6d41\u9519\u8bef\uff0c{}", (Object)flag.getErrorDesc());
            return new OpRes(flag.getErrorDesc(), null, false);
        }
        OpRes<Boolean> stop = this.analysisService.analysisVideoStop(this.analysisProperties.getServerUrl(), data);
        if (!stop.isOpRes()) {
            return new OpRes(stop.getErrorDesc(), (Object)false, false);
        }
        this.redisService.del(key);
        return new OpRes(null, (Object)true, true);
    }

    public List<RecordVideo> flightRecord(String jobId) {
        String relative = String.join((CharSequence)"/", this.obsProperties.getObjectDirPrefix(), jobId.replaceAll("-", ""));
        List<RecordVideo> result = this.storeHandler.listObjects(this.obsProperties.getBucket(), relative, Collections.singletonList("mp4"));
        return this.liveService.dealRecordTime(result);
    }

    public List<?> flightTrack(String jobId, String objectKey) {
        if (ObjectUtil.isNotEmpty((Object)objectKey)) {
            ArrayList<BaseTrackInfo> list = new ArrayList<BaseTrackInfo>();
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.storeHandler.getObjectStream(this.obsProperties.getBucket(), objectKey)));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (!ObjectUtil.isNotEmpty((Object)line) || line.contains("undefined")) continue;
                    list.add((BaseTrackInfo)JSONUtil.toBean((String)line, BaseTrackInfo.class));
                }
                IoUtil.close((Closeable)reader);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                throw new RuntimeException("\u8bfb\u53d6\u8f68\u8ff9\u6587\u4ef6\u5931\u8d25");
            }
            return list;
        }
        String relative = String.join((CharSequence)"/", this.obsProperties.getObjectDirPrefix(), jobId);
        return this.storeHandler.listObjects(this.obsProperties.getBucket(), relative, Collections.singletonList("track"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignSegment(AssignSegmentVo param, HttpServletResponse response) {
        block20: {
            if (ObjectUtil.isEmpty((Object)param.getJobId())) {
                FczxLiveTool.responseError(response, JSONUtil.toJsonStr((Object)BaseResponse.error((String)"jobId\u4e0d\u80fd\u4e3a\u7a7a").getBody()));
                return;
            }
            if (ObjectUtil.isEmpty((Object)param.getTime())) {
                FczxLiveTool.responseError(response, JSONUtil.toJsonStr((Object)BaseResponse.error((String)"time\u4e0d\u80fd\u4e3a\u7a7a").getBody()));
                return;
            }
            if (ObjectUtil.isEmpty((Object)param.getRange())) {
                FczxLiveTool.responseError(response, JSONUtil.toJsonStr((Object)BaseResponse.error((String)"range\u4e0d\u80fd\u4e3a\u7a7a").getBody()));
                return;
            }
            List<RecordVideo> records = this.flightRecord(param.getJobId());
            if (records == null || records.isEmpty()) {
                FczxLiveTool.responseError(response, JSONUtil.toJsonStr((Object)BaseResponse.error((String)"\u672a\u627e\u5230\u5f55\u5236\u89c6\u9891").getBody()));
                return;
            }
            Optional<RecordVideo> select = records.stream().filter(record -> record.calStartTime() <= param.getTime() && param.getTime() <= record.calcEndTime()).findFirst();
            if (!select.isPresent()) {
                FczxLiveTool.responseError(response, JSONUtil.toJsonStr((Object)BaseResponse.error((String)"\u672a\u627e\u5230\u53d1\u73b0\u65f6\u95f4\u5bf9\u5e94\u7684\u5f55\u5236\u89c6\u9891").getBody()));
                return;
            }
            param.setObjectKey(select.get().getObjectKey());
            String cutName = FczxLiveTool.buildVideoCutName(param);
            try {
                if (this.storeHandler.existObject(this.obsProperties.getBucket(), cutName).booleanValue()) {
                    FczxLiveTool.responseJsonData(response, cutName);
                    break block20;
                }
                int diff = 0;
                List<RecordVideo> list = this.flightRecord(param.getJobId());
                Optional<RecordVideo> video = list.stream().filter(item -> ObjectUtil.equal((Object)item.getObjectKey(), (Object)param.getObjectKey())).findFirst();
                if (!video.isPresent()) {
                    FczxLiveTool.responseError(response, JSONUtil.toJsonStr((Object)BaseResponse.error((String)"\u672a\u627e\u5230\u89c6\u9891\u76f8\u5173\u4fe1\u606f").getBody()));
                    return;
                }
                Float duration = Float.valueOf(Float.parseFloat(((Map)video.get().getMetadata()).get("duration").toString()));
                if ((float)(param.getRange() * 2) > duration.floatValue()) {
                    FczxLiveTool.responseError(response, JSONUtil.toJsonStr((Object)BaseResponse.error((String)"\u622a\u53d6\u65f6\u95f4\u8d85\u8fc7\u6574\u4e2a\u89c6\u9891").getBody()));
                    return;
                }
                long time = Long.parseLong(((Map)video.get().getMetadata()).get("startrecordtime").toString()) - param.getTime();
                diff = (int)Math.abs(time) / 1000;
                if (diff < 0 || (float)diff > duration.floatValue()) {
                    FczxLiveTool.responseError(response, JSONUtil.toJsonStr((Object)BaseResponse.error((String)"\u53c2\u6570\u4e0d\u5408\u6cd5").getBody()));
                    return;
                }
                int beginSecond = diff - param.getRange();
                int endSecond = diff + param.getRange();
                if (beginSecond < 0) {
                    beginSecond = 0;
                }
                if ((float)endSecond > duration.floatValue()) {
                    endSecond = duration.intValue();
                }
                String input = System.getProperty("user.dir") + "/" + IdUtil.fastSimpleUUID() + ".mp4";
                String out = System.getProperty("user.dir") + "/" + FileUtil.getName((String)cutName);
                try {
                    if (!FileUtil.exist((String)input)) {
                        FileUtil.newFile((String)input);
                    }
                    if (!FileUtil.exist((String)out)) {
                        FileUtil.newFile((String)out);
                    }
                    FileUtil.writeFromStream((InputStream)this.storeHandler.getObjectStream(this.obsProperties.getBucket(), param.getObjectKey()), (String)input);
                    FfmpegTool.cutVideoSegment(beginSecond, endSecond, input, out);
                    if (BooleanUtil.isTrue((Boolean)param.getCached())) {
                        this.storeHandler.putObjectWithMeta(this.obsProperties.getBucket(), cutName, FileUtil.getInputStream((String)out), MapUtil.empty());
                        FczxLiveTool.responseJsonData(response, cutName);
                    } else {
                        IoUtil.copy((InputStream)FileUtil.getInputStream((String)out), (OutputStream)response.getOutputStream());
                    }
                }
                finally {
                    FileUtil.del((String)input);
                    FileUtil.del((String)out);
                    System.gc();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

