/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.live.storage;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ZipUtil;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.HttpMethod;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.ResponseHeaderOverrides;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import com.amazonaws.services.s3.transfer.Upload;
import com.geoway.fczx.live.data.RecordVideo;
import com.geoway.fczx.live.data.ThumbnailVo;
import com.geoway.fczx.live.data.WatermarkVo;
import com.geoway.fczx.live.data.property.HuaweiObsProperties;
import com.geoway.fczx.live.handler.AbstractStoreHandler;
import com.geoway.ue.common.util.Path;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.coobird.thumbnailator.Thumbnails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EosServiceHandler
extends AbstractStoreHandler<S3Object> {
    private static final Logger log = LoggerFactory.getLogger(EosServiceHandler.class);
    private AmazonS3 client;
    private HuaweiObsProperties properties;

    public EosServiceHandler(HuaweiObsProperties properties) {
        this.properties = properties;
        this.client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withClientConfiguration(new ClientConfiguration().withMaxConnections(properties.getConnectNums().intValue()))).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(properties.getAccessKey(), properties.getSecretKey())))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(properties.getEndpoint(), properties.getRegion()))).build();
    }

    private AmazonS3 buildClient() {
        return (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.properties.getAccessKey(), this.properties.getSecretKey())))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.properties.getEndpoint(), this.properties.getRegion()))).build();
    }

    private AmazonS3 buildOutsideClient() {
        if (ObjectUtil.isNotEmpty((Object)this.properties.getOutside())) {
            return (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.properties.getAccessKey(), this.properties.getSecretKey())))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.properties.getOutside(), this.properties.getRegion()))).build();
        }
        return this.buildClient();
    }

    private void shutdownClient(AmazonS3 client) {
        if (client != null) {
            client.shutdown();
        }
    }

    @Override
    public String getBucketDomain(String bucket) {
        throw new RuntimeException("\u6682\u672a\u5b9e\u73b0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getObjectUrl(String bucket, String objectKey, Map<String, Object> params, String rename) {
        AmazonS3 buildClient = this.buildOutsideClient();
        try {
            GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(bucket, objectKey, HttpMethod.GET);
            request.setExpiration(new Date(System.currentTimeMillis() + this.properties.getExpire() * 1000L));
            for (Map.Entry<String, Object> param : params.entrySet()) {
                request.addRequestParameter(param.getKey(), (String)param.getValue());
            }
            if (ObjectUtil.isNotEmpty((Object)rename)) {
                ResponseHeaderOverrides headerOverrides = new ResponseHeaderOverrides();
                headerOverrides.setContentDisposition(String.format("attachment;filename=\"%s\"", rename));
                request.setResponseHeaders(headerOverrides);
            }
            URL uRL = buildClient.generatePresignedUrl(request);
            return uRL;
        }
        finally {
            this.shutdownClient(buildClient);
        }
    }

    @Override
    public Boolean existObject(String bucket, String objectKey) {
        return this.client.doesObjectExist(bucket, objectKey);
    }

    @Override
    public Boolean renameObject(String bucket, String objectKey, String newObjectKey) {
        try {
            this.client.copyObject(bucket, objectKey, bucket, newObjectKey);
            this.client.deleteObject(bucket, objectKey);
            return true;
        }
        catch (Exception e) {
            log.info("rename file [" + objectKey + "] failed : " + e.getMessage());
            return false;
        }
    }

    @Override
    public Boolean deleteObject(String bucket, String objectKey) {
        if (!this.client.doesObjectExist(bucket, objectKey)) {
            return true;
        }
        this.client.deleteObject(bucket, objectKey);
        return true;
    }

    @Override
    public InputStream getObjectStream(String bucket, String objectKey) {
        AmazonS3 buildClient = this.buildClient();
        try {
            GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(bucket, objectKey, HttpMethod.GET);
            request.setExpiration(new Date(System.currentTimeMillis() + this.properties.getExpire() * 1000L));
            InputStream inputStream = buildClient.generatePresignedUrl(request).openStream();
            return inputStream;
        }
        catch (Exception e) {
            log.error("{}", (Object)objectKey);
            throw new RuntimeException("The file request error.");
        }
        finally {
            this.shutdownClient(buildClient);
        }
    }

    @Override
    public S3Object getObject(String bucket, String objectKey) {
        return this.client.getObject(bucket, objectKey);
    }

    @Override
    public Map<String, Object> getObjectMeta(S3Object object) {
        Map data = object.getObjectMetadata().getUserMetadata();
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addObjectMeta(String bucket, String objectKey, Map<String, String> meta) {
        AmazonS3 buildClient = this.buildClient();
        try {
            if (!buildClient.doesObjectExist(bucket, objectKey)) {
                throw new RuntimeException("The file not found.");
            }
            S3Object s3Object = buildClient.getObject(bucket, objectKey);
            ObjectMetadata metadata = s3Object.getObjectMetadata();
            metadata.setUserMetadata(meta);
            PutObjectRequest request = new PutObjectRequest(bucket, objectKey, s3Object.getObjectContent().getDelegateStream(), metadata);
            request.getRequestClientOptions().setReadLimit(0x40000000);
            buildClient.putObject(request);
        }
        finally {
            this.shutdownClient(buildClient);
        }
    }

    @Override
    public Long getObjectLength(S3Object object) {
        return object.getObjectMetadata().getContentLength();
    }

    @Override
    public InputStream getObjectInStream(S3Object object) {
        return object.getObjectContent().getDelegateStream();
    }

    @Override
    public void putObject(String bucket, String objectKey, InputStream input) {
        this.putObjectWithMeta(bucket, objectKey, input, new HashMap<String, String>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putObjectBlock(String bucket, String objectKey, String localFile) {
        AmazonS3 buildClient = this.buildClient();
        TransferManager tm = TransferManagerBuilder.standard().withS3Client(buildClient).build();
        try {
            Upload upload = tm.upload(bucket, objectKey, new File(localFile));
            upload.waitForCompletion();
        }
        catch (Exception e) {
            log.error("put object block failed.", (Throwable)e);
        }
        finally {
            tm.shutdownNow();
            this.shutdownClient(buildClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Map<String, Object>> uploadDir(String bucket, String relative, String filePath) {
        List files = FileUtil.loopFiles((String)filePath);
        if (ObjectUtil.isEmpty((Object)files)) {
            log.error("\u8be5\u76ee\u5f55{}\u4e0b\u672a\u627e\u5230\u6587\u4ef6", (Object)filePath);
            return null;
        }
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
        AmazonS3 buildClient = this.buildClient();
        try {
            String filepath = filePath.replaceAll("\\\\", "/");
            for (File file : files) {
                HashMap<String, Object> fileMeta = new HashMap<String, Object>();
                String filename = file.getAbsolutePath().replaceAll("\\\\", "/");
                String relate = filename.replace(filepath + "/", "");
                String objectKey = Path.joinPath((String)"/", (String[])new String[]{relative, relate});
                if (file.length() > 0x40000000L) {
                    this.putObjectBlock(bucket, objectKey, file.getAbsolutePath());
                } else {
                    buildClient.putObject(bucket, objectKey, file);
                }
                fileMeta.put("objectKey", objectKey);
                fileMeta.put("fileSize", file.length());
                fileMeta.put("fileName", FileUtil.getName((String)objectKey));
                map.put(relate, fileMeta);
            }
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5939\u5f02\u5e38", (Throwable)e);
        }
        finally {
            this.shutdownClient(buildClient);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putObjectWithMeta(String bucket, String objectKey, InputStream input, Map<String, String> meta) {
        AmazonS3 buildClient = this.buildClient();
        try {
            if (buildClient.doesObjectExist(bucket, objectKey)) {
                throw new RuntimeException("The filename already exists.");
            }
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setUserMetadata(meta);
            PutObjectRequest request = new PutObjectRequest(bucket, objectKey, input, metadata);
            request.getRequestClientOptions().setReadLimit(0x40000000);
            PutObjectResult putObjectResult = buildClient.putObject(request);
        }
        finally {
            this.shutdownClient(buildClient);
        }
    }

    @Override
    public void getAttachThumb(String bucket, String objectKey, ThumbnailVo data, HttpServletResponse response) {
        int width = 400;
        int height = 300;
        if (ObjectUtil.isNotEmpty((Object)data.getWidth())) {
            width = Integer.parseInt(data.getWidth());
        }
        if (ObjectUtil.isNotEmpty((Object)data.getHeight())) {
            height = Integer.parseInt(data.getHeight());
        }
        try {
            Thumbnails.of((InputStream[])new InputStream[]{this.getObjectStream(bucket, objectKey)}).size(width, height).toOutputStream((OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7f29\u7565\u56fe\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("\u83b7\u53d6\u7f29\u7565\u56fe\u5f02\u5e38");
        }
    }

    @Override
    public void getWatermark(String bucket, String objectKey, WatermarkVo data, HttpServletResponse response) {
        try {
            Thumbnails.of((InputStream[])new InputStream[]{this.getObjectStream(bucket, objectKey)}).watermark(data.convertParams()).toOutputStream((OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6c34\u5370\u56fe\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("\u83b7\u53d6\u6c34\u5370\u56fe\u5f02\u5e38");
        }
    }

    @Override
    public InputStream getAttachThumb(String bucket, String objectKey, ThumbnailVo data) {
        log.error("\u79fb\u52a8\u4e91eos\u6ca1\u6709\u5185\u7f6e\u7f29\u7565\u56fe\u65b9\u6cd5");
        return null;
    }

    @Override
    public InputStream getWatermark(String bucket, String objectKey, WatermarkVo data) {
        log.error("\u79fb\u52a8\u4e91eos\u6ca1\u6709\u5185\u7f6e\u6c34\u5370\u56fe\u65b9\u6cd5");
        return null;
    }

    @Override
    public Long getBucketStorage(String bucket) {
        List list = this.client.listBuckets();
        return null;
    }

    @Override
    public Boolean createVideoShot(String bucket, String objectKey) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean createImageThumb(String bucket, String objectKey, String thumbName, Integer width, Integer height, Map<String, String> meta) {
        AmazonS3 buildClient = this.buildClient();
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setUserMetadata(meta);
            Thumbnails.of((InputStream[])new InputStream[]{buildClient.getObject(bucket, objectKey).getObjectContent().getDelegateStream()}).size(width.intValue(), height.intValue()).toOutputStream((OutputStream)outputStream);
            buildClient.putObject(bucket, thumbName, (InputStream)new ByteArrayInputStream(outputStream.toByteArray()), metadata);
        }
        catch (Exception e) {
            Boolean bl = false;
            return bl;
        }
        finally {
            this.shutdownClient(buildClient);
        }
        return true;
    }

    @Override
    public void downloadFiles(String name, String bucket, List<String> files, String relative, HttpServletResponse response) throws Exception {
        long start = System.currentTimeMillis();
        AmazonS3 ossClient = this.buildClient();
        try {
            ZipOutputStream zipOutputStream = ZipUtil.getZipOutputStream((OutputStream)response.getOutputStream(), (Charset)StandardCharsets.UTF_8);
            for (String file : files) {
                int len;
                String filename = FileUtil.getName((String)file);
                if (ObjectUtil.isNotEmpty((Object)relative)) {
                    int len2 = file.indexOf(relative);
                    if (len2 < 0) {
                        len2 = 0;
                    }
                    filename = file.substring(len2 + 1 + relative.length());
                }
                S3ObjectInputStream inputStream = ossClient.getObject(bucket, file).getObjectContent();
                zipOutputStream.putNextEntry(new ZipEntry(filename));
                byte[] buffer = new byte[1024];
                while ((len = inputStream.read(buffer)) > 0) {
                    zipOutputStream.write(buffer, 0, len);
                }
                zipOutputStream.closeEntry();
            }
            zipOutputStream.close();
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            throw e;
        }
        finally {
            this.shutdownClient(ossClient);
            log.debug("\u4e0b\u8f7d\u5b8c\u6210{},\u4e0b\u8f7d\u8017\u65f6{}", files, (Object)(System.currentTimeMillis() - start));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getObjectMeta(String bucket, String objectKey) {
        AmazonS3 ossClient = this.buildClient();
        try {
            Map data;
            Map map = data = ossClient.getObject(bucket, objectKey).getObjectMetadata().getUserMetadata();
            return map;
        }
        finally {
            this.shutdownClient(ossClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RecordVideo> listObjects(String bucket, String relative, List<String> suffix) {
        ArrayList<RecordVideo> datalist = new ArrayList<RecordVideo>();
        AmazonS3 ossClient = this.buildClient();
        try {
            ObjectListing list = ossClient.listObjects(bucket, relative);
            list.getObjectSummaries().forEach(item -> {
                try {
                    String name = item.getKey().replace(relative + "/", "");
                    if (!name.contains("/")) {
                        RecordVideo video = new RecordVideo(item.getKey(), item.getLastModified(), item.getSize());
                        video.setMetadata(this.getObjectMeta(bucket, item.getKey()));
                        datalist.add(video);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        finally {
            this.shutdownClient(ossClient);
        }
        datalist.removeIf(data -> {
            String fmt = FileUtil.getSuffix((String)data.getObjectKey());
            return !ObjectUtil.contains((Object)suffix, (Object)fmt);
        });
        return datalist.stream().sorted(Comparator.comparing(RecordVideo::getCreateTime)).collect(Collectors.toList());
    }

    @Override
    public void refreshClient() {
        this.shutdownClient(this.client);
        this.client = this.buildOutsideClient();
    }
}

