/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.live.stream;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.geoway.fczx.live.data.LiveRecordVo;
import com.geoway.fczx.live.data.yunxin.YxChannel;
import com.geoway.fczx.live.data.yunxin.YxRecordCallDto;
import com.geoway.fczx.live.data.yunxin.YxRecordDto;
import com.geoway.fczx.live.handler.AbstractLiveHandler;
import com.geoway.fczx.live.handler.AbstractStoreHandler;
import com.geoway.fczx.live.thirdapi.yunxin.YxRestService;
import com.geoway.ue.common.data.response.OpRes;
import java.net.URL;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class YxLiveServiceHandler
extends AbstractLiveHandler<YxRecordCallDto> {
    private static final Logger log = LoggerFactory.getLogger(YxLiveServiceHandler.class);
    @Autowired
    private YxRestService yxRestService;

    public YxLiveServiceHandler(AbstractStoreHandler abstractStoreHandler) {
        super(abstractStoreHandler);
    }

    @Override
    public OpRes<LiveRecordVo> startVideoRecord(YxRecordDto data) {
        String channelId = this.redisService.getStr("yunxin:" + data.getDroneSn());
        if (ObjectUtil.isEmpty((Object)channelId)) {
            log.error("\u672a\u627e\u5230\u8bbe\u5907{}\u89c6\u9891\u901a\u9053\u4fe1\u606f", (Object)data.getDroneSn());
            return new OpRes("\u672a\u627e\u5230\u8bbe\u5907\u4e91\u4fe1\u89c6\u9891\u901a\u9053\u4fe1\u606f", null, false);
        }
        data.setCid(channelId);
        Object set = this.yxRestService.recordConfig_v1(data.convertMap());
        if (set == null) {
            return new OpRes("\u4e0b\u53d1\u89c6\u9891\u5f55\u5236\u8bbe\u7f6e\u5931\u8d25", null, false);
        }
        Object res = this.yxRestService.startRecord_v1(channelId);
        if (res == null) {
            return new OpRes("\u5f00\u59cb\u5f55\u5236\u5931\u8d25", null, false);
        }
        LiveRecordVo liveParam = new LiveRecordVo(channelId, data.getDroneSn(), new Date());
        this.redisService.setWithExpire("record:" + data.getDroneSn(), JSONUtil.toJsonStr((Object)liveParam), this.liveProperties.getMaxPushDuration().intValue());
        return new OpRes(null, (Object)liveParam, true);
    }

    @Override
    public OpRes<Object> stopVideoRecord(YxRecordDto data) {
        String droneSn = data.getDroneSn();
        String channelId = this.redisService.getStr("yunxin:" + droneSn);
        if (ObjectUtil.isEmpty((Object)channelId)) {
            log.error("\u672a\u627e\u5230\u8bbe\u5907{}\u89c6\u9891\u901a\u9053\u4fe1\u606f", (Object)droneSn);
            return new OpRes("\u672a\u627e\u5230\u8bbe\u5907\u89c6\u9891\u901a\u9053\u4fe1\u606f", null, false);
        }
        YxChannel channel = this.yxRestService.channelStatus_v1(channelId);
        if (channel != null && ObjectUtil.equal((Object)channel.getStatus(), (Object)3)) {
            Object res = this.yxRestService.stopRecord_v1(channelId);
            if (res != null) {
                this.redisService.del("record:" + droneSn);
                return new OpRes(null, res, true);
            }
            return new OpRes("", null, false);
        }
        this.redisService.del("record:" + droneSn);
        return new OpRes(null, (Object)channel, true);
    }

    @Override
    public OpRes<JSONObject> saveVideoRecord(YxRecordCallDto data) {
        if (ObjectUtil.isEmpty((Object)data.getOrigUrl())) {
            return new OpRes("\u672a\u53d1\u73b0\u89c6\u9891\u539f\u4ef6\u4fe1\u606f", null, false);
        }
        JSONObject media = data.ConvertMediaFile(this.obsProperties.getObjectDirPrefix());
        try {
            URL url = new URL(data.getOrigUrl());
            this.storeService.putObject(this.obsProperties.getBucket(), media.getStr((Object)"objectKey"), url.openStream());
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u89c6\u9891\u81f3obs\u5931\u8d25", (Throwable)e);
            return new OpRes("\u4fdd\u5b58\u89c6\u9891\u81f3\u5bf9\u8c61\u5b58\u50a8\u5931\u8d25", null, false);
        }
        return new OpRes(null, (Object)media, true);
    }

    @Override
    public YxChannel openAiLiveStream(String deviceSn, int duration, String params) {
        String key = "rtmpai:" + deviceSn;
        String channelKey = "yunxinai:" + deviceSn;
        String channelName = "AI_" + deviceSn;
        if (this.redisService.checkExist(key) && this.redisService.getExpire(key) > 0L) {
            return this.redisService.getBean(key, YxChannel.class);
        }
        if (this.redisService.checkExist(channelKey)) {
            String cid = this.redisService.get(channelKey);
            YxChannel channel = this.yxRestService.againAddress_v1(cid);
            if (ObjectUtil.isNotEmpty((Object)channel)) {
                this.redisService.setWithExpire(key, JSONUtil.toJsonStr((Object)channel), duration);
                return channel;
            }
        } else {
            YxChannel channel = this.yxRestService.createChannel_v1(channelName);
            if (ObjectUtil.isNotEmpty((Object)channel)) {
                this.redisService.set(channelKey, channel.getCid());
                this.redisService.setWithExpire(key, JSONUtil.toJsonStr((Object)channel), duration);
                return channel;
            }
        }
        return null;
    }

    @Override
    public OpRes<Boolean> removeAiLiveStream(String deviceSn) {
        Object isDeleted;
        String key = "rtmpai:" + deviceSn;
        String channelKey = "yunxinai:" + deviceSn;
        String cid = this.redisService.get(channelKey);
        if (ObjectUtil.isNotEmpty((Object)cid) && (isDeleted = this.yxRestService.removeChannel_v1(cid)) == null) {
            return new OpRes("\u5220\u9664\u89c6\u9891\u89e3\u6790\u6d41\u5a92\u4f53\u670d\u52a1\u901a\u9053\u5931\u8d25", (Object)false, false);
        }
        this.redisService.del(key);
        return new OpRes(null, (Object)true, true);
    }
}

