/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.live.thirdapi.agora;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.geoway.fczx.live.data.LiveRecordVo;
import com.geoway.fczx.live.data.agora.AgoraAcquire;
import com.geoway.fczx.live.data.agora.AgoraConvert;
import com.geoway.fczx.live.data.agora.AgoraGoogleRes;
import com.geoway.fczx.live.data.agora.AgoraRecordStatus;
import com.geoway.fczx.live.data.agora.AgoraStartRecordRes;
import com.geoway.fczx.live.data.agora.AgoraStopRecordRes;
import com.geoway.fczx.live.data.property.HuaweiObsProperties;
import com.geoway.fczx.live.data.property.LiveApiProperties;
import com.geoway.fczx.live.data.yunxin.YxRecordDto;
import com.geoway.ue.common.data.response.OpRes;
import io.agora.media.RtcTokenBuilder2;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class AgoraRestService {
    private static final Logger log = LoggerFactory.getLogger(AgoraRestService.class);
    @Resource
    private RestTemplate liveApiRest;
    @Resource
    private LiveApiProperties liveProperties;
    @Resource
    private HuaweiObsProperties obsProperties;
    static int tokenExpirationInSeconds = 43200;
    static int privilegeExpirationInSeconds = 43200;
    static String RECORD_MODE = "mix";
    private static final String channelListUrl = "/dev/v1/channel/{appid}";
    private static final String startRecordLocalUrl = "/api/video/v1/record/start";
    private static final String stopRecordLocalUrl = "/api/video/v1/record/stop";
    private static final String acquireRecordUrl = "/v1/apps/{appid}/cloud_recording/acquire";
    private static final String startRecordUrl = "/v1/apps/{appid}/cloud_recording/resourceid/{resourceid}/mode/{mode}/start";
    private static final String stopRecordUrl = "/v1/apps/{appid}/cloud_recording/resourceid/{resourceid}/sid/{sid}/mode/{mode}/stop";
    private static final String queryRecordStateUrl = "/v1/apps/{appid}/cloud_recording/resourceid/{resourceid}/sid/{sid}/mode/{mode}/query";
    private static final String createConvertUrl = "/cn/v1/projects/{appId}/rtmp-converters";
    private static final String updateConvertUrl = "/cn/v1/projects/{appId}/rtmp-converters/{converterId}";
    private static final String removeConvertUrl = "/cn/v1/projects/{appId}/rtmp-converters/{converterId}";
    private static final String queryConvertUrl = "/v1/projects/{appId}/channels/{cname}/rtmp-converters";

    public String makeToken(String channel, String uid) {
        RtcTokenBuilder2 token = new RtcTokenBuilder2();
        return token.buildTokenWithUid(this.liveProperties.getAppId(), this.liveProperties.getAppCert(), channel, Integer.parseInt(uid), RtcTokenBuilder2.Role.ROLE_PUBLISHER, tokenExpirationInSeconds, privilegeExpirationInSeconds);
    }

    public Object listChannel(Map<String, Object> params) {
        String url = this.liveProperties.getServerUrl().concat(channelListUrl);
        ResponseEntity res = this.liveApiRest.exchange(url, HttpMethod.GET, this.buildHttpParams(params), String.class, new Object[]{this.liveProperties.getAppId()});
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u83b7\u53d6\u76f4\u64ad\u9891\u9053\u5217\u8868\u5931\u8d25{}", (Object)res);
            return null;
        }
        return JSONUtil.parseObj((String)((String)res.getBody())).getByPath("data.channels", JSONArray.class);
    }

    public AgoraAcquire acquireRecord(String channelName) {
        HashMap<String, Integer> req = new HashMap<String, Integer>();
        req.put("scene", 0);
        req.put("resourceExpiredHour", 24);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("cname", channelName);
        params.put("clientRequest", req);
        params.put("uid", this.liveProperties.getUid());
        String url = this.liveProperties.getServerUrl().concat(acquireRecordUrl);
        ResponseEntity res = this.liveApiRest.postForEntity(url, this.buildHttpParams(params), String.class, new Object[]{this.liveProperties.getAppId()});
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u83b7\u53d6\u4e91\u7aef\u5f55\u5236\u8d44\u6e90\u5931\u8d25{}", (Object)res);
            return null;
        }
        return (AgoraAcquire)JSONUtil.parseObj((String)((String)res.getBody())).toBean(AgoraAcquire.class);
    }

    public AgoraStartRecordRes startRecord(String channelName, String resId, String relativePath) {
        HashMap<String, Object> clientRequest = new HashMap<String, Object>();
        HashMap<String, Object> storageConfig = new HashMap<String, Object>();
        HashMap<String, Object> recordingConfig = new HashMap<String, Object>();
        HashMap<String, Integer> transcodingConfig = new HashMap<String, Integer>();
        HashMap<String, String[]> recordingFileConfig = new HashMap<String, String[]>();
        clientRequest.put("storageConfig", storageConfig);
        clientRequest.put("recordingConfig", recordingConfig);
        clientRequest.put("recordingFileConfig", recordingFileConfig);
        storageConfig.put("bucket", this.obsProperties.getBucket());
        storageConfig.put("accessKey", this.obsProperties.getAccessKey());
        storageConfig.put("secretKey", this.obsProperties.getSecretKey());
        storageConfig.put("region", this.liveProperties.getStorageRegion());
        storageConfig.put("vendor", this.obsProperties.getProvider().getVendor());
        clientRequest.put("token", this.makeToken(channelName, this.liveProperties.getUid()));
        List<String> dir = Arrays.asList(this.obsProperties.getObjectDirPrefix().split("/"));
        ArrayList<String> arr = new ArrayList<String>(dir);
        arr.add(relativePath);
        storageConfig.put("fileNamePrefix", arr);
        recordingConfig.put("channelType", 1);
        recordingConfig.put("streamTypes", 2);
        recordingConfig.put("streamMode", "default");
        recordingConfig.put("maxIdleTime", 60);
        recordingConfig.put("videoStreamType", 0);
        recordingConfig.put("subscribeUidGroup", 5);
        recordingConfig.put("transcodingConfig", transcodingConfig);
        recordingConfig.put("subscribeVideoUids", Collections.singletonList("#allstream#"));
        recordingConfig.put("subscribeAudioUids", Collections.singletonList("#allstream#"));
        transcodingConfig.put("width", 1280);
        transcodingConfig.put("height", 720);
        transcodingConfig.put("fps", 15);
        transcodingConfig.put("bitrate", 2260);
        recordingFileConfig.put("avFileType", new String[]{"hls", "mp4"});
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("cname", channelName);
        params.put("clientRequest", clientRequest);
        params.put("uid", this.liveProperties.getUid());
        String url = this.liveProperties.getServerUrl().concat(startRecordUrl);
        log.debug("\u8bf7\u6c42\u53c2\u6570\n{}", (Object)JSONUtil.toJsonStr(params));
        ResponseEntity res = this.liveApiRest.postForEntity(url, this.buildHttpParams(params), String.class, new Object[]{this.liveProperties.getAppId(), resId, RECORD_MODE});
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        log.debug("\u8fd4\u56de\u7ed3\u679c\n{}", (Object)JSONUtil.toJsonStr((Object)res.getBody()));
        if (!flag) {
            log.error("\u5f00\u59cb\u76f4\u64ad\u5f55\u5236\u5931\u8d25{}", (Object)res);
            return null;
        }
        return (AgoraStartRecordRes)JSONUtil.parseObj((String)((String)res.getBody())).toBean(AgoraStartRecordRes.class);
    }

    public AgoraStopRecordRes stopRecord(String channel, String resId, String sid) {
        HashMap<String, Boolean> clientRequest = new HashMap<String, Boolean>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("cname", channel);
        clientRequest.put("async_stop", false);
        params.put("clientRequest", clientRequest);
        params.put("uid", this.liveProperties.getUid());
        String url = this.liveProperties.getServerUrl().concat(stopRecordUrl);
        log.debug("\u8bf7\u6c42\u8def\u5f84{}\n\u8bf7\u6c42\u53c2\u6570{}", (Object)url, params);
        log.debug("\u8def\u5f84\u53c2\u6570:{},resId={},sid={},{}", new Object[]{this.liveProperties.getAppId(), resId, sid, RECORD_MODE});
        ResponseEntity res = this.liveApiRest.postForEntity(url, this.buildHttpParams(params), String.class, new Object[]{this.liveProperties.getAppId(), resId, sid, RECORD_MODE});
        log.debug("\u8fd4\u56de\u7ed3\u679c{}", (Object)res);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u505c\u6b62\u76f4\u64ad\u5f55\u5236\u5931\u8d25{}", (Object)res);
            return null;
        }
        return (AgoraStopRecordRes)JSONUtil.parseObj((String)((String)res.getBody())).toBean(AgoraStopRecordRes.class);
    }

    public AgoraGoogleRes createConvert(String channel, String rtmpUrl) {
        HashMap<String, Object> transcodeOptions = new HashMap<String, Object>();
        HashMap<String, Object> videoOptions = new HashMap<String, Object>();
        HashMap<String, Object> converter = new HashMap<String, Object>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Integer> canvas = new HashMap<String, Integer>();
        HashMap<String, Serializable> layout = new HashMap<String, Serializable>();
        HashMap<String, Integer> region = new HashMap<String, Integer>();
        params.put("converter", converter);
        converter.put("name", channel + "_CVT");
        converter.put("idleTimeout", 60);
        converter.put("rtmpUrl", rtmpUrl);
        converter.put("transcodeOptions", transcodeOptions);
        transcodeOptions.put("rtcChannel", channel);
        transcodeOptions.put("audioOptions", MapUtil.empty());
        transcodeOptions.put("videoOptions", videoOptions);
        videoOptions.put("codecProfile", "high");
        videoOptions.put("codec", "H.264");
        videoOptions.put("layoutType", 0);
        videoOptions.put("bitrate", 2260);
        videoOptions.put("frameRate", 15);
        videoOptions.put("gop", 30);
        videoOptions.put("canvas", canvas);
        videoOptions.put("layout", Collections.singletonList(layout));
        layout.put("rtcStreamUid", Integer.valueOf(Integer.parseInt(this.liveProperties.getAnchorUid())));
        layout.put("region", region);
        region.put("xPos", 0);
        region.put("yPos", 0);
        region.put("zIndex", 0);
        region.put("width", 1440);
        region.put("height", 1080);
        canvas.put("width", 1440);
        canvas.put("height", 1080);
        String url = this.liveProperties.getServerUrl().concat(createConvertUrl);
        log.debug("\u8bf7\u6c42\u8def\u5f84{}\n\u8bf7\u6c42\u53c2\u6570{}", (Object)url, params);
        log.debug("\u8def\u5f84\u53c2\u6570:{}", (Object)this.liveProperties.getAppId());
        ResponseEntity res = this.liveApiRest.postForEntity(url, this.buildHttpParams(params), String.class, new Object[]{this.liveProperties.getAppId()});
        log.debug("\u8fd4\u56de\u7ed3\u679c{}", (Object)res);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u521b\u5efa Converter\u5931\u8d25{}", (Object)res);
            return null;
        }
        return (AgoraGoogleRes)JSONUtil.parseObj((String)((String)res.getBody())).toBean(AgoraGoogleRes.class);
    }

    public List<AgoraConvert> queryConverter(String channel) {
        String url = this.liveProperties.getServerUrl().concat(queryConvertUrl);
        ResponseEntity res = this.liveApiRest.exchange(url, HttpMethod.GET, this.buildHttpParams(MapUtil.empty()), String.class, new Object[]{this.liveProperties.getAppId(), channel});
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u67e5\u8be2\u9891\u9053\u5185 Converter\u5931\u8d25{}", (Object)res);
            return null;
        }
        return ((JSONArray)JSONUtil.parseObj((String)((String)res.getBody())).getByPath("data.members", JSONArray.class)).toList(AgoraConvert.class);
    }

    public AgoraGoogleRes updateConvert(String convertId, String rtmpUrl) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, String> convert = new HashMap<String, String>();
        params.put("converter", convert);
        params.put("fields", "rtmpUrl");
        convert.put("rtmpUrl", rtmpUrl);
        String url = this.liveProperties.getServerUrl().concat("/cn/v1/projects/{appId}/rtmp-converters/{converterId}");
        log.debug("\u8bf7\u6c42\u8def\u5f84{}\n\u8bf7\u6c42\u53c2\u6570{}", (Object)url, params);
        log.debug("\u8def\u5f84\u53c2\u6570:{},convertId={}", (Object)this.liveProperties.getAppId(), (Object)convertId);
        ResponseEntity res = this.liveApiRest.exchange(url, HttpMethod.PATCH, this.buildHttpParams(params), String.class, new Object[]{this.liveProperties.getAppId(), convertId});
        log.debug("\u8fd4\u56de\u7ed3\u679c{}", (Object)res);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u66f4\u65b0 Converter\u5931\u8d25{}", (Object)res);
            return null;
        }
        return (AgoraGoogleRes)JSONUtil.parseObj((String)((String)res.getBody())).toBean(AgoraGoogleRes.class);
    }

    public boolean removeConvert(String convertId) {
        String url = this.liveProperties.getServerUrl().concat("/cn/v1/projects/{appId}/rtmp-converters/{converterId}");
        log.debug("\u8bf7\u6c42\u8def\u5f84{}", (Object)url);
        log.debug("\u8def\u5f84\u53c2\u6570:{},convertId={}", (Object)this.liveProperties.getAppId(), (Object)convertId);
        ResponseEntity res = this.liveApiRest.exchange(url, HttpMethod.DELETE, this.buildHttpParams(MapUtil.empty()), String.class, new Object[]{this.liveProperties.getAppId(), convertId});
        log.debug("\u8fd4\u56de\u7ed3\u679c{}", (Object)res);
        return this.resolveResultBool((ResponseEntity<String>)res);
    }

    public AgoraRecordStatus queryRecordState(String resId, String sid) {
        String url = this.liveProperties.getServerUrl().concat(queryRecordStateUrl);
        ResponseEntity res = this.liveApiRest.exchange(url, HttpMethod.GET, this.buildHttpParams(MapUtil.empty()), String.class, new Object[]{this.liveProperties.getAppId(), resId, sid, RECORD_MODE});
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u67e5\u8be2\u4e91\u7aef\u5f55\u5236\u72b6\u6001\u5931\u8d25{}", (Object)res);
            return null;
        }
        return (AgoraRecordStatus)JSONUtil.parseObj((String)((String)res.getBody())).toBean(AgoraRecordStatus.class);
    }

    public OpRes<LiveRecordVo> startRecordLocal(YxRecordDto params) {
        String url = this.liveProperties.getServerUrl().concat(startRecordLocalUrl);
        ResponseEntity res = this.liveApiRest.postForEntity(url, (Object)new HttpEntity((Object)params), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u5f00\u59cb\u672c\u5730\u5f55\u5236\u5931\u8d25\uff1a{}", (Object)res);
            return new OpRes(JSONUtil.parseObj((String)((String)res.getBody())).getStr((Object)"msg"), null, false);
        }
        return new OpRes(null, (Object)((LiveRecordVo)JSONUtil.parseObj((String)((String)res.getBody())).toBean(LiveRecordVo.class)), true);
    }

    public OpRes<Object> stopRecordLocal(YxRecordDto params) {
        String url = this.liveProperties.getServerUrl().concat(stopRecordLocalUrl);
        ResponseEntity res = this.liveApiRest.postForEntity(url, (Object)new HttpEntity((Object)params), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u7ed3\u675f\u672c\u5730\u5f55\u5236\u5931\u8d25\uff1a{}", (Object)res);
            return new OpRes(JSONUtil.parseObj((String)((String)res.getBody())).getStr((Object)"msg"), null, false);
        }
        return new OpRes(null, JSONUtil.parseObj((String)((String)res.getBody())).toBean(LiveRecordVo.class), true);
    }

    private HttpEntity<Map<String, Object>> buildHttpParams(Map<String, Object> params) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String customerKey = this.liveProperties.getAppKey();
        String customerSecret = this.liveProperties.getAppSecret();
        String plainCredentials = customerKey + ":" + customerSecret;
        String base64Credentials = new String(Base64.getEncoder().encode(plainCredentials.getBytes()));
        headers.set("Authorization", "Basic " + base64Credentials);
        return new HttpEntity(params, (MultiValueMap)headers);
    }

    private boolean resolveResultBool(ResponseEntity<String> res) {
        return ObjectUtil.equal((Object)res.getStatusCode(), (Object)HttpStatus.OK);
    }
}

