/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.live.thirdapi.cmlc;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.geoway.ue.common.data.response.OpRes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class CmlcAiRestService {
    private static final Logger log = LoggerFactory.getLogger(CmlcAiRestService.class);
    @Resource
    private RestTemplate aiApiRest;
    private static final String videoAnalysisListUrl = "/api/cmlc/task/list";
    private static final String videoAnalysisStartUrl = "/api/cmlc/task/start";
    private static final String videoAnalysisStopUrl = "/api/cmlc/task/stop";

    public OpRes<List<?>> videoAnalysisList(String serverUrl, Map<String, Object> param) {
        if (ObjectUtil.isEmpty((Object)serverUrl)) {
            return new OpRes("\u672a\u8bbe\u7f6e\u89c6\u9891\u89e3\u6790\u670d\u52a1\u5730\u5740", null, false);
        }
        String url = serverUrl.concat(videoAnalysisListUrl);
        ResponseEntity res = this.aiApiRest.exchange(url, HttpMethod.GET, new HttpEntity(param, (MultiValueMap)this.buildHttpHeaders()), String.class, new Object[0]);
        log.info("\u8c03\u7528\u63a5\u53e3\u8def\u5f84{}\n\u53c2\u6570{}\n\u8fd4\u56de\u7ed3\u679c{}", new Object[]{url, param, res});
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u4e2d\u79fb\u51cc\u4e91\u89c6\u9891\u4efb\u52a1\u5217\u8868\u83b7\u53d6\u5931\u8d25\uff1a{}", (Object)res);
            return new OpRes((String)res.getBody(), null, false);
        }
        return new OpRes(null, (Object)JSONUtil.parseObj((String)((String)res.getBody())).getBeanList((Object)"data", Object.class), true);
    }

    public OpRes<Boolean> videoAnalysisPush(String serverUrl, Map<String, Object> param) {
        if (ObjectUtil.isEmpty((Object)serverUrl)) {
            return new OpRes("\u672a\u8bbe\u7f6e\u89c6\u9891\u89e3\u6790\u670d\u52a1\u5730\u5740", (Object)false, false);
        }
        String url = serverUrl.concat(videoAnalysisStartUrl);
        log.info("\u89c6\u9891\u89e3\u6790\u5f00\u59cb\u63a8\u6d41{}\n\u53c2\u6570{}", (Object)url, param);
        ResponseEntity res = this.aiApiRest.postForEntity(url, (Object)new HttpEntity(param, (MultiValueMap)this.buildHttpHeaders()), String.class, new Object[0]);
        log.info("\u8c03\u7528\u63a5\u53e3\u8def\u5f84{}\n\u53c2\u6570{}\n\u8fd4\u56de\u7ed3\u679c{}", new Object[]{url, param, res});
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u4e2d\u79fb\u51cc\u4e91\u89c6\u9891\u5f00\u59cb\u89e3\u6790\u5931\u8d25\uff1a{}", (Object)res);
            return new OpRes((String)res.getBody(), (Object)false, false);
        }
        return new OpRes(null, (Object)true, true);
    }

    public OpRes<Boolean> videoAnalysisStop(String serverUrl, String id) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("plugin_name", "ai_recognition");
        param.put("plugin_task_id", id);
        param.put("plugin_args", "116");
        if (ObjectUtil.isEmpty((Object)serverUrl)) {
            return new OpRes("\u672a\u8bbe\u7f6e\u89c6\u9891\u89e3\u6790\u670d\u52a1\u5730\u5740", (Object)false, false);
        }
        String url = serverUrl.concat(videoAnalysisStopUrl);
        log.info("\u89c6\u9891\u89e3\u6790\u7ed3\u675f\u63a8\u6d41{}\n\u53c2\u6570{}", (Object)url, param);
        ResponseEntity res = this.aiApiRest.postForEntity(url, (Object)new HttpEntity(param, (MultiValueMap)this.buildHttpHeaders()), String.class, new Object[0]);
        log.info("\u8c03\u7528\u63a5\u53e3\u8def\u5f84{}\n\u53c2\u6570{}\n\u8fd4\u56de\u7ed3\u679c{}", new Object[]{url, param, res});
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u4e2d\u79fb\u51cc\u4e91\u89c6\u9891\u7ed3\u675f\u89e3\u6790\u5931\u8d25\uff1a{}", (Object)res);
            return new OpRes((String)res.getBody(), (Object)false, false);
        }
        return new OpRes(null, (Object)true, true);
    }

    private HttpHeaders buildHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        return headers;
    }

    private boolean resolveResultBool(ResponseEntity<String> res) {
        if (ObjectUtil.equal((Object)res.getStatusCode(), (Object)HttpStatus.OK) && ObjectUtil.isNotEmpty((Object)res.getBody())) {
            return ObjectUtil.equals((Object)JSONUtil.parseObj((String)((String)res.getBody())).getInt((Object)"code"), (Object)0);
        }
        return false;
    }
}

